﻿"use strict";

define([], function () {

    function configureRequireJs(root) {
        requirejs.config({
            baseUrl: root,
            paths: {
                bootstrap:              'bootstrap.min',
                jquery:                 'jquery-3.1.1.min',
                jq_val:                 'jquery.validate.min',
                jq_val_unobtrusive:     'jquery.validate.unobtrusive.min',
                jq_datatables:          'jquery.dataTables.min',
                moment_min:             'moment.min',
                moment_locale_de:       'moment/locale/de-custom',
                bootstrap_datetimepicker: 'bootstrap-datetimepicker-custom.min',
                bootstrap_colorpicker:   'bootstrap-colorpicker.min',
            },
            shim: {
                'bootstrap':                ['jquery'],
                'jq_val':                   ['jquery'],
                'jq_val_unobtrusive':       ['jq_val'],
                'bootstrap_datetimepicker': ['bootstrap', 'moment_locale_de'],
                'bootstrap_colorpicker':    ['bootstrap'],
            }
        });
    }

    function getConfig(content) {
        var config = {};

        if (typeof content == "string") {
            content = content.trim();
            if (content !== '')
                config = JSON.parse(content);
        }
        else if (typeof content == "object") {
            config = content;
        }

        return config;
    }

    function initModule($moduleRoot) {
        var moduleName = $moduleRoot.data('module');
        var config = {};
        try {
            var content = $moduleRoot.data('module-config');

            config = getConfig(content);
        }
        catch (e) {
            console.error(e);
        }

        require([moduleName], function (module) {
            module.init($moduleRoot, config);
        });
    }

    function initModuleFromDOM(domNode) {
        domNode.find('script[data-module]').each(function () {
            var moduleName = $(this).data('module');
            var config = {};
            try {
                var content = $(this).html();
                config = getConfig(content);
            }
            catch (e) {
                console.error(e);
            }

            require([moduleName], function (module) {
                module.init(config);
            });
        });
    }

    var appTag  = document.querySelector("script[data-main]");
    var path    = appTag.getAttribute('data-web-app-root');

    configureRequireJs(path + 'Scripts/');

    require(['jquery', 'bootstrap', 'Moduls/dataService', 'Moduls/data-tables'], function (jq, bs, dataService, datatables) {
        jq(function () {
            datatables.init();
            dataService.init(path);

            jq('*[data-module]').each(function () {
                initModule(jq(this));
            });

            jq(document).on('DOMNodeInserted', '*[data-module]', function (event) {
                if (event.target == event.currentTarget) {
                    initModule(jq(event.target));
                }
            });
        });
    });

    return {
        initModuleFromDOM: initModuleFromDOM
    }
});

