﻿define([], function () {


    var _root = null;
    return {
        init: function (root) {
            _root = root;
        },

        getIndexGridPartial: function (controller, controllerProfilId, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            $.get(_root + controller + '/IndexGrid/' + controllerProfilId, function (data) {
                cb(null, data);
            }).fail(function (err) {
                cb(err);
            });
        },

        getGeraeteDropDownListPartial: function (controller, refIdEingangDefinition, profilId, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            $.get(_root + controller + '/GeraeteDropDownList/?refIdEingangDefinition=' + refIdEingangDefinition + '&profilId='
                + profilId, function (data) {
                    cb(null, data);
                }).fail(function (err) {
                    cb(err);
                });
        },

        getEingangParameterIndexGridPartial: function (controller, refIdEingangDefinition, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            $.get(_root + controller + '/EingangParameterIndexGrid/?refIdEingangDefinition=' + refIdEingangDefinition, function (data) {
                cb(null, data);
            }).fail(function (err) {
                cb(err);
            });
        },

        getPortDetailsPartial: function (controller, changedInput, refIdEingang, refIdPortAktionDefinition, refIdGeraet, dauer, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            switch (changedInput) {
                case "RefIdEingangPortAktionDefinition":
                    $.get(_root + controller + '/OnChangeEingangPortAktionDefinition/?refIdEingang=' + refIdEingang + '&refIdEingangPortAktionDefinition='
                        + refIdPortAktionDefinition + '&dauer=' + dauer, function (data) {
                            cb(null, data);
                        }).fail(function (err) { cb(err); });
                    break;
                case "PortDetails_RefIdGeraet":
                    $.get(_root + controller + '/OnChangeGeraet/?refIdEingang=' + refIdEingang + '&refIdEingangPortAktionDefinition='
                        + refIdPortAktionDefinition + '&refIdGeraet=' + refIdGeraet + '&dauer=' + dauer, function (data) {
                            cb(null, data);
                        }).fail(function (err) { cb(err); });
                    break;
                default:

            }
        },

        getEreignisLogIndexGridPartial: function (controller, deviceBaseType, von, bis, controllerProfilId, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            var url = _root + controller + '/IndexGrid?deviceBaseType=' + deviceBaseType + '&selectedProfileTuerControllerId=' + controllerProfilId + '&selectedZeitraumVon=' + von + '&selectedZeitraumBis=' + bis;

            $.get(url, function (data) {
                cb(null, data);
            }).fail(function (err) {
                cb(err);
            });
        },

        deleteAllEreignisLog: function (controller, deviceBaseType, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            $.ajax({
                url: _root + controller + '/DeleteAll',
                type: 'POST',
                data: {
                    deviceBaseType: deviceBaseType
                },
                success: function (data) {
                    cb(null, data);
                },
                error: function (xhr, status, error) {
                    cb(err);
                },
                complete: function (xhr, status) {

                }
            });
        },

        getGeraeteDefinition: function (controller, refIdGeraeteDefinition, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            $.get(_root + controller + '/GetGeraeteDefinition/?refIdGeraeteDefinition=' + refIdGeraeteDefinition,
                function (data) {
                    cb(null, data);
                }).fail(function (err) {
                    cb(err);
                });
        },

        getSystempatchUebersichtPartial: function (controller, showAll, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            var url = _root + controller + '/SystempatchUebersicht?showAll=' + showAll;

            $.get(url, function (data) {
                cb(null, data);
            }).fail(function (err) {
                cb(err);
            });
        },

        getSystemCertificatesUebersichtPartial: function (controller, showAll, cb) {
            if (!cb)
                throw new Error('JS-Callback-Function not defined');

            var url = _root + controller + '/SystemCertificatesUebersicht?showAll=' + showAll;

            $.get(url, function (data) {
                cb(null, data);
            }).fail(function (err) {
                cb(err);
            });
        },
    };

});