﻿define(['jquery', 'jq_datatables'], function (jquery, jq_datatables) {

    function _ApplySelectableFeature($tbl) {
        if ($tbl.hasClass('data-table-selectable')) {
            $tbl.find('tbody tr').click(function (e) {
                var $tr = $(this);
                var selectionControl = $tr.find('td:first-of-type input[type="radio"], td:first-of-type input[type="checkbox"]');
                if (selectionControl.length <= 0) {
                    console.error("no input of type checkbox or radio found in the first cell!");
                    throw Error("no input of type checkbox or radio found in the first cell!");
                }

                if (e.target !== selectionControl[0]) {
                    selectionControl.prop('checked', !selectionControl.prop('checked'));
                }

            });
        }
    }

    function _ApplyFilterFeature($tbl, dataTableCnf) {
        var filterHeaders = $tbl.find('thead tr th.data-table-filter-text, thead tr th.data-table-filter-select');
        if (filterHeaders.length > 0) {
            if ($tbl.find('tfoot').length <= 0) {
                var $thead = $tbl.find('thead');
                var $tfoot = $('<tfoot></tfoot>');
                $tfoot.html($thead.html());
                $tfoot.find('th:not(.data-table-filter-text, datat-table-filter-select)').empty();
                $tfoot.insertAfter($thead);
            }
        }

        dataTableCnf.initComplete = function () {
            var filterFooters = $tbl.find('tfoot tr th.data-table-filter-text, tfoot tr th.data-table-filter-select');
            if (filterFooters.length <= 0) {
                return;
            }

            var table = this.api();

            filterFooters.each(function () {
                var $th = $(this);

                if ($th.hasClass('data-table-filter-text')) {
                    var placeholder = $th.text();
                    $th.html('');
                    var $textbox = $('<input type="text" placeholder="' + placeholder + '" class="data-table-filter-input form-control text-box single-line" />');
                    $th.append($textbox);
                }
                else if ($th.hasClass('data-table-filter-select')) {
                    var $select = $('<select class="data-table-filter-select form-control text-box single-line"><option value=""></option></select>');
                    $th.html('');
                    $th.append($select);
                }
            });


            table.columns().every(function () {
                var col = this;
                var $textbox = $('input', col.footer());
                if ($textbox.length > 0) {
                    $textbox.on('keyup change', function () {
                        if (col.search() !== this.value) {
                            col.search(this.value)
                                .draw();
                        }
                    });
                }


                var $select = $('select', col.footer());
                if ($select.length > 0) {
                    col.data().unique().sort().each(function (val) {
                        $select.append('<option value="' + val + '">' + val + '</option>');
                    });

                    $select.on('change', function () {
                        var val = $(this).val();
                        val = $.fn.dataTable.util.escapeRegex(val);
                        col.search(val ? '^' + val + '$' : '', true, false)
                            .draw();
                    });
                }


            });
        };
    }

    function _InitDataTable($tbl, globalConf) {
        var dataTableCnf = {
            language: globalConf.resx.dataTable
        };

        dataTableCnf.lengthMenu = [[10, 20, 50, -1], [10, 20, 50, "Alle"]];
        dataTableCnf.aoColumnDefs = [{ "searchable": false, "aTargets": ["no-search"] }];
        dataTableCnf.pageLength = 20;
        dataTableCnf.stateSave = true;

        _ApplySelectableFeature($tbl);
        _ApplyFilterFeature($tbl, dataTableCnf);

        $tbl.DataTable(dataTableCnf);

        $(".dataTables_filter input[type='search']").addClass('form-control text-box single-line');
    }

    function _GetConfig() {
        var appTag = document.querySelector("script[data-main]");

        var globalConf = {};
        try {
            var jsonStr = appTag.innerHTML;
            if (jsonStr !== null && jsonStr !== '') {
                globalConf = JSON.parse(jsonStr);
            }
        }
        catch (e) {
            console.error(e.message);
        }

        return globalConf;
    }

    return {
        init: function () {
            var globalConf = _GetConfig();

            $('table.data-table').each(function () {
                _InitDataTable($(this), globalConf);
            });
        },

        InitDataTable: function ($tbl) {
            var globalConf = _GetConfig();

            _InitDataTable($tbl, globalConf);
        }
    };
});