﻿define([], function () {

    var controllerName = "RegisterDevice";

    function _GetDatahubServiceUrl() {
        $.ajax({
            url: 'GetDatahubServiceUrl',
            type: 'POST',
            data: {
                'Host': $('#ServiceUrl').val(),
            },
            dataType: "json",
            traditional: true,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            success: function (serviceUrlBuilderResultModel) {
                $("#serviceUrlResultMsg").html("&nbsp;");
                $("#serviceUrlResultMsg").removeClass("serviceConnectionResultError");
                $("#serviceUrlResultMsg").removeClass("serviceConnectionResultOk");

                if (serviceUrlBuilderResultModel) {
                    if (serviceUrlBuilderResultModel.hasError === false) {
                        $("#serviceUrlResult").html(serviceUrlBuilderResultModel.serviceUrl);

                        if (serviceUrlBuilderResultModel.tsuiWebAppUrl !== null) {
                            $("#tsuiUrl").html(serviceUrlBuilderResultModel.tsuiWebAppUrl);
                            $("#tsuiUrl").attr("href", serviceUrlBuilderResultModel.tsuiWebAppUrl);
                            $("#tsuiUrl").removeClass("hidden");
                        }
                    }
                    else {
                        $("#serviceUrlResult").html("&nbsp;");
                        if (serviceUrlBuilderResultModel.errorMessage !== null) {
                            $("#serviceUrlResultMsg").html(serviceUrlBuilderResultModel.errorMessage);
                            $("#serviceUrlResultMsg").addClass("serviceConnectionResultError");
                            $("#serviceUrlResultMsg").removeClass("serviceConnectionResultOk");
                        }
                    }
                }
                else {
                    $("#serviceUrlResult").html("&nbsp;");
                }
            },
            error: function (jqXHR, textStatus, error) {
                $("#serviceUrlResultMsg").html("&nbsp;");
                $("#serviceUrlResult").html("&nbsp;");
                $("#tsuiUrl").addClass("hidden");
                $("#tsuiUrl").html();
                $("#tsuiUrl").removeAttr("href");

                if (jqXHR) {
                    console.log(jqXHR);
                }
            }
        });
    }

    function _CheckDatahubConnection() {

        $('#checkConnectionWait').removeClass('hidden');
        $('#checkConnectionResult').empty();

        $.ajax({
            url: 'BuildUrlAndCheckDataHubConnection',
            type: 'POST',
            data: {
                'host': $('#ServiceUrl').val(),
                'directDatahubSecret': $('#DirectDatahubSecret').val(),
                'isDisabledSslCertificateValidation': $('#IsActiveDisabledSslCertificateValidation').is(':checked'),
            },
            dataType: "json",
            traditional: true,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            success: function (message) {
                $("#checkConnectionResult").removeClass("serviceConnectionResultError");
                $("#checkConnectionResult").addClass("serviceConnectionResultOk");
                $("#checkConnectionResult").html(message);
            },
            error: function (jqXHR, textStatus, error) {
                $("#checkConnectionResult").removeClass("serviceConnectionResultOk");
                $("#checkConnectionResult").addClass("serviceConnectionResultError");

                if (jqXHR) {
                    if (jqXHR.responseJSON.message) {
                        $("#checkConnectionResult").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $("#checkConnectionResult").html("error occured");
                    }
                }
                else {
                    $("#checkConnectionResult").html(error);
                }
            },
            complete: function () {
                $('#checkConnectionWait').addClass('hidden');
            }
        });
    }

    return {
        init: function () {
            $('#ServiceUrl').on('focusout', function () {
                if ($(this).val().length > 3) {
                    _GetDatahubServiceUrl();
                }
                if ($(this).val().length > 0 && $('#DirectDatahubSecret').val().length > 0) {
                    _CheckDatahubConnection();
                }
            });
            $('#DirectDatahubSecret').on('focusout', function () {
                if ($(this).val().length > 0 && $('#ServiceUrl').val().length > 0) {
                    _CheckDatahubConnection();
                }
            });
            $('#IsActiveDisabledSslCertificateValidation').change(function () {
                if ($(this).val().length > 0 && $('#ServiceUrl').val().length > 0) {
                    _CheckDatahubConnection();
                }
            });
        }
    }
})