﻿define(['Moduls/data-tables'], function (dataTable) {

    var controllerName = "NetzwerkEinstellung";

    function openModal(interfaceName) {

        $("#btn-reload").prop('disabled', true)
        $("#computeDialog").modal("show");

        _GetConnectionState(interfaceName)
    }

    function closeModal() {
        $("#computeDialog").modal('hide');
        $("#btn-reload").prop('disabled', false);
    }

    function _GetConnectionState(interfaceName) {

        $("#connectionState").addClass("hidden");
        $("#ConnectionStateDetailsPanelID").addClass("hidden");
        $("#waitConnectionState").removeClass("hidden");
        $("#dialogNoConnectionState").addClass("hidden")
        $("#dialogErrorConnectionState").addClass("hidden");
        $("#dialogErrorConnectionState").empty();

        _ShowConnectionState(null);

        $.ajax({
            url: "/" + controllerName + '/GetConnectionState',
            dataType: "json",
            type: 'GET',
            data: {
                "interfaceName": interfaceName,
            },
            cache: false,
            success: function (data) {
                if ($.trim(data)) {
                    _ShowConnectionState(data);
                }
                else {
                    $("#dialogNoConnectionState").removeClass("hidden")
                }
            },
            error: function (jqXHR, textStatus, error) {
                $("#dialogErrorConnectionState").removeClass("hidden");
                if (jqXHR) {
                    if (jqXHR.responseJSON) {
                        if (jqXHR.responseJSON.message) {
                            $("#dialogErrorConnectionState").html(jqXHR.responseJSON.message);
                            console.log(jqXHR.responseJSON.message);
                        }
                        else {
                            $('#dialogErrorConnectionState').html("error occured");
                        }
                    }
                    else {
                        $('#dialogErrorConnectionState').html(jqXHR.statusText);
                    }
                }
                else {
                    $('#dialogErrorConnectionState').html("error occured");
                }
            },
            complete: function () {
                $("#waitConnectionState").addClass("hidden");
            }
        });
    }

    function _ShowConnectionStateProperty(propertyName, propertyValue) {
        var propertyLabelName = propertyName + "Group"

        if (!propertyValue) {
            $(propertyName).addClass("hidden");
            $(propertyLabelName).addClass("hidden");
            $(propertyName).empty();

            return
        }

        $(propertyName).html(propertyValue);
        $(propertyName).removeClass("hidden");
        $(propertyLabelName).removeClass("hidden");
    }

    function _ShowConnectionState(data) {
        _ShowConnectionStateProperty("#connectionStateState",null)
        _ShowConnectionStateProperty("#connectionStateSsid", null)
        _ShowConnectionStateProperty("#connectionStateFrequency", null)
        _ShowConnectionStateProperty("#connectionStateIPAddress", null)
        _ShowConnectionStateProperty("#connectionStateSignalStrength", null)
        _ShowConnectionStateProperty("#connectionStateGroupCcipher", null)
        _ShowConnectionStateProperty("#connectionStatePairwiseCipher", null)
        _ShowConnectionStateProperty("#connectionStateOperationMode", null)
        _ShowConnectionStateProperty("#connectionStateKeyManagement", null)
        _ShowConnectionStateProperty("#connectionStateWifiGeneration", null)
        _ShowConnectionStateProperty("#connectionStateSendBitrate", null)
        _ShowConnectionStateProperty("#connectionStateReceiveBitrate", null)
        _ShowConnectionStateProperty("#connectionStateAccesspointMacAddress", null)

        if (!data || !data.connectionState) {
            return
        }

        _ShowConnectionStateProperty("#connectionStateState", data.connectionState.wpaState)
        _ShowConnectionStateProperty("#connectionStateSsid", data.connectionState.ssid)
        _ShowConnectionStateProperty("#connectionStateFrequency", data.connectionState.frequency)
        _ShowConnectionStateProperty("#connectionStateIPAddress", data.connectionState.ipAddress)
        _ShowConnectionStateProperty("#connectionStateSignalStrength", data.connectionState.signalStrength)
        _ShowConnectionStateProperty("#connectionStateGroupCcipher", data.connectionState.groupCipher)
        _ShowConnectionStateProperty("#connectionStatePairwiseCipher", data.connectionState.pairwiseCipher)
        _ShowConnectionStateProperty("#connectionStateOperationMode", data.connectionState.operationMode)
        _ShowConnectionStateProperty("#connectionStateKeyManagement", data.connectionState.keyManagement)
        _ShowConnectionStateProperty("#connectionStateWifiGeneration", data.connectionState.wifiGeneration)
        _ShowConnectionStateProperty("#connectionStateSendBitrate", data.connectionState.sendBitrate)
        _ShowConnectionStateProperty("#connectionStateReceiveBitrate", data.connectionState.receiveBitrate)
        _ShowConnectionStateProperty("#connectionStateAccesspointMacAddress", data.connectionState.accesspointMacAddress)

        $("#connectionState").removeClass("hidden");
        $("#ConnectionStateDetailsPanelID").removeClass("hidden");
    }

    return {
        init: function () {
            $('.data-table').each(function () {
                var oTable = $(this).dataTable();

                var orderColumnIndex = oTable.fnSettings().aaSorting[0][0];
                if (orderColumnIndex === 0) {
                    oTable.fnSort([[1, 'asc']]);
                }
            });

            $(".networkConnectionState").on("click", function() {
                var interfaceName = $(this).data("interfacename");

                openModal(interfaceName);
            });

            $("#btn-closeModal").on("click", function () {
                closeModal();
            });
        }
    };
});