﻿define([], function () {

    var controllerName = "Mobilfunk";

    function openModal() {

        $("#btn-reload").prop('disabled', true)
        $("#computeDialog").modal("show");

        _GetRssiInformation()
    }

    function closeModal() {
        $("#computeDialog").modal('hide');
        $("#btn-reload").prop('disabled', false);
    }

    function _GetRssiInformation() {

        $.ajax({
            url: controllerName + '/GetRssiInformation',
            dataType: "json",
            type: 'GET',
            success: function (data) {
                $("#modalConnectionState").text(data.connectionStateDescription);
                $("#modalMessage").text(data.errorCodeDescription);
                /*$("#modalConnectionQuality").text(data.connectionQuality);*/
                $("#modalConnectionQualityIcon").attr("src", "./Content/Images/" + data.connectionQualityIcon);
                $("#modalConnectionQualityIcon").attr("title", data.connectionQualityDescription);

                if (data.errorCode != 0) {
                    $("#modalMessageGroup").removeClass("hidden");
                }
                else {
                    $("#modalMessageGroup").addClass("hidden");
                }
  
                if ($("#computeDialog").is(":hidden") == false) {
                    setTimeout(function () { _GetRssiInformation(); }, 2000);
                }
            },
            error: function (error) {
                console.log(error);

                $("#modalMessageGroup").removeClass("hidden");
                $("#modelMessage").text(error.text);
                $("#modalConnectionState").text("");
                $("#modalConnectionQuality").text("");
                $("#modalConnectionQualityIcon").attr("src", "./Content/Images/devstate_mobile_0_24h.png");

                if ($("#computeDialog").is(":hidden") == false) {
                    setTimeout(function () { _GetRssiInformation(); }, 2000);
                }
            }
        });
    }

    return {
        init: function () {
            $("#btn-openModal").click(function () {
                openModal();
            });

            $("#btn-closeModal").click(function () {
                closeModal();
            });
        }
    }
})