﻿define([], function () {

    var controllerName = "MemoryDump";

    function openModalDownload(fileName) {

        $("#downloadComputeDialog").modal("show");

        _StartDownload(fileName)
    }

    function closeModalDownload() {
        $("#downloadComputeDialog").modal('hide');
        $('#btn-openModalDownloadComputeDialog').removeAttr('disabled');
    }

    function _GetDownloadResult() {
        $.ajax({
            url: controllerName + '/GetDownloadDumpResult',
            type: 'GET',
            cache: false,
            dataType: "json",
            success: function (memoryDump) {
                var timeoutId;

                if (memoryDump) {
                    if (memoryDump.isCompleted !== true) {
                        timeoutId = setTimeout(function () { _GetDownloadResult(); }, 2000);

                        return;
                    }

                    clearTimeout(timeoutId);

                    if (memoryDump.errorMessage) {
                        $("#dialogResultException").html(memoryDump.errorMessage);
                        $("#dialogResultException").removeClass("hidden");
                    }
                    else if (memoryDump.filePathBase64) {
                        $("#dialogResultException").addClass("hidden");

                        window.location.href = controllerName + "/DownloadFile?filePathBase64=" + memoryDump.filePathBase64;
                    }

                    $('#downloadDialogAjaxLoaderIcon').addClass("hidden");
                    $("#downloadDialogInProgressMessage").addClass("hidden");
                    $('#btn-openModalDownload').removeAttr('disabled');

                    closeModalDownload();
                }
                else {
                    timeoutId = setTimeout(function () { _GetDownloadResult(); }, 5000);
                }
            },
            error: function (jqXHR, textStatus, error) {
                if (jqXHR) {
                    if (jqXHR.responseJSON.message) {
                        $("#dialogResultException").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $("#dialogResultException").html("error occured");
                    }
                }
                else {
                    $("#dialogResultException").html(error);
                }

                $("#dialogResultException").removeClass("hidden");
            }
        });
    }

    function _StartDownload(fileName) {

        $("#downloadDialogResultSuccess").addClass("hidden");
        $("#dialogResultException").addClass("hidden");
        $("#dialogResultException").html();

        $("#downloadDialogResultWarning").addClass("hidden");
        $("#downloadDialogResultWarningMessage").addClass("hidden");
        $("#downloadDialogResultWarningMessage").html();
        $("#downloadDialogResultWarningDownload").removeAttr("href");

        $('#btn-openModalDownload').attr('disabled', 'disabled');
        $('#downloadDialogAjaxLoaderIcon').removeClass("hidden");
        $("#downloadDialogInProgressMessage").removeClass("hidden");

        $.ajax({
            url: controllerName + '/StartDownloadDump',
            type: 'POST',
            cache: false,
            data: { 'fileName': fileName },
            dataType: "json",
            traditional: true,
            success: function () {
                setTimeout(function () { _GetDownloadResult(); }, 2000);
            },
            error: function (jqXHR, textStatus, error) {
                if (jqXHR) {
                    if (jqXHR.responseJSON.message) {
                        $("#dialogResultException").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $("#dialogResultException").html("error occured");
                    }
                }
                else {
                    $("#dialogResultException").html(error);
                }

                $("#dialogResultException").removeClass("hidden");
                closeModalDownload();
            }
        });
    }

    return {
        init: function () {
            $(".btnDownload").on('click', function (event) {
                openModalDownload($(this).data("filepathbase64"));
            });

            $("#btn-closeModalDownload").on('click', function () {
                closeModalDownload();
            }); 
        }
    }
})