﻿define([], function () {

    var controllerName = "MemoryDump";

    var createMemoryDumpCheckIntervalMs = 30000;

    var timeoutIdCreateMemoryDump;
    var intervalIdCreateMemoryDump;

    function openModalCreateMemoryDump() {

        $("#createMemoryDumpDialog").modal("show");

        _StartCreateMemoryDump()
    }

    function closeModalCreateMemoryDump() {
        $("#createMemoryDumpDialog").modal('hide');
        $('#btn-closeModalCreateMemoryDump').removeAttr('disabled');
    }

    function _CheckIsWebAppAvailable() {
        var checkUrl = $("#checkIsAvailableData").data("checkurl")
        var redirectUrl = $("#checkIsAvailableData").data("redirecturl")

        $.get(checkUrl, function (data, status) {
            if (status = 200) {
                clearInterval(intervalIdCreateMemoryDump);
                clearTimeout(timeoutIdCreateMemoryDump);

                $("#createMemoryDumpDialogResultSuccess").removeClass("hidden");
                closeModalCreateMemoryDump();

                window.location.href = redirectUrl;
            }
        });
    }

    function _WaitForCompleteCreateMemoryDump() {
        intervalIdCreateMemoryDump = setInterval(_CheckIsWebAppAvailable, createMemoryDumpCheckIntervalMs);
    }

    function _StartCreateMemoryDump() {

        $("warnMessage").addClass("hidden");
        $("#btn-closeModalCreateMemoryDump").addClass("hidden");
        $("#createMemoryDumpDialogResultSuccess").addClass("hidden");
        $("#dialogResultException").addClass("hidden");
        $("#dialogResultException").html();

        $('#btn-closeModalCreateMemoryDump').attr('disabled', 'disabled');
        $('#createMemoryDumpDialogAjaxLoaderIcon').removeClass("hidden");
        $("#createMemoryDumpDialogInProgressMessage").removeClass("hidden");

        $.ajax({
            url: controllerName + '/CreateDump',
            type: 'POST',
            dataType: "json",
            data: {
                'IsAllowedSecret': $('#IsAllowedSecret').val(),
            },
            traditional: true,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            beforeSend: function (xhr) {
                xhr.setRequestHeader("RequestVerificationToken", $('input:hidden[name="__RequestVerificationToken"]').val());
            },
            success: function () {
                timeoutIdCreateMemoryDump = setTimeout(_WaitForCompleteCreateMemoryDump(), createMemoryDumpCheckIntervalMs / 2);
            },
            error: function (jqXHR, textStatus, error) {
                if (jqXHR) {
                    if (jqXHR.responseJSON.message) {
                        $("#dialogResultException").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $("#dialogResultException").html("error occured");
                    }
                }
                else {
                    $("#dialogResultException").html(error);
                }

                $("#dialogResultException").removeClass("hidden");
                $("#btn-closeModalCreateMemoryDump").removeClass("hidden");
                $('#createMemoryDumpDialogAjaxLoaderIcon').addClass("hidden");
                $("warnMessage").removeClass("hidden");

                closeModalCreateMemoryDump();
            }
        });
    }

    return {
        init: function () {
            $("#formMemoryDump").submit(function (e) {
                if ($(this).find('.input-validation-error').length != 0) {
                    return false;   
                }

                openModalCreateMemoryDump();

                return false; //submit abbrechen. nicht vom controller verarbeitet
            });

            $("#btn-closeModalCreateMemoryDump").click(function () {
                closeModalCreateMemoryDump();

                $("warnMessage").removeClass("hidden");
            });
        }
    }
})