﻿define(['Moduls/dataService', 'bootstrapper'], function (dataService, bootstrapper) {

    var controllerName = "Log";

    function ClearContent() {
        $('.logAnsichtPre').empty();
    }

    function LoadLogLevel() {
        var selectedLogfile = $('#SelectedLogfile').val();

        $("#SelectedLogLevel").attr("disabled", selectedLogfile == "DCFSysLogMessages" || selectedLogfile == "DCFSystemstart" || selectedLogfile == "DCFSystempatches" || selectedLogfile == "DCFMobilfunkLogMessages" || selectedLogfile == "DCFFirmwareupdate" || selectedLogfile == "DCFWLANWpaSupplicantLogMessages");

        var url = controllerName + '/GetLogLevel?logFileKey=' + selectedLogfile;
        $.ajax({
            url: url,
            type: 'GET',
            datatype: 'json',
            success: function (result) {
                $(function () {
                    $("#SelectedLogLevel").val(result);
                });
            }
        });
    }

    function ChangeLogLevel() {
        var selectedLogfile = $('#SelectedLogfile').val();
        var selectedLogLevel = $('#SelectedLogLevel').val();

        var url = controllerName + '/SetLogLevel?logLevel=' + selectedLogLevel + '&logFileKey=' + selectedLogfile;

        ClearContent();

        $('#rootLogFileContent').load(url);
    }

    function LoadLogfiles() {
        var selectedLogfile = $('#SelectedLogfile').val();
        var selectedDate = $('#SelectedDate').val();

        $("#SelectedDate").attr("disabled", selectedLogfile == "DCFSysLogMessages" || selectedLogfile == "DCFSystemstart" || selectedLogfile == "DCFSystempatches" || selectedLogfile == "DCFMobilfunkLogMessages" || selectedLogfile == "DCFFirmwareupdate" || selectedLogfile == "DCFWLANWpaSupplicantLogMessages");

        var url = controllerName + '/GetLogContent?logFileKey=' + selectedLogfile + '&sDate=' + selectedDate;

        ClearContent();
        
        $('#refreshLogfileText').addClass('hidden');
        $('#refreshLogfileWait').removeClass('hidden');

        $('#rootLogFileContent').load(url);
        $('#refreshLogfileWait').addClass('hidden');
        $('#refreshLogfileText').removeClass('hidden');
    }

    return {
        init: function () {

            $("#SelectedDate").change(function () {
                LoadLogfiles();
            });

            $("#SelectedLogLevel").change(function () {
                ChangeLogLevel();
            });

            $("#SelectedLogfile").change(function () {
                LoadLogLevel();
                LoadLogfiles();
            });

            $(".btn-loadContent").click(function () {
                LoadLogfiles();
            });

            LoadLogLevel();
            LoadLogfiles();

            $(".partialContent").each(function (index, item) {
                var $item = $(item);
                var partialUrl = $item.data("url");
                if (partialUrl && partialUrl.length > 0) {
                    $.get(partialUrl, function (html) {
                        $item.html(html);
                        bootstrapper.initModuleFromDOM($item);
                    }).fail(function () {
                        $item.html("Could not load content");
                    });
                }
            });
        }
    };
});
