﻿define(['Moduls/dataService'], function (dataService) {

    function getSelectedRefIdGeraeteDefinition() {
        var $auswahlSelect  = $('#auswahlSelect');
        var selectedValue   = $auswahlSelect.val();

        return selectedValue;
    }

    function refreshAdresse() {
        $('#ajaxLoaderGif').removeClass('hidden');

        var selectedRefIdGeraeteDefinition = getSelectedRefIdGeraeteDefinition();

        dataService.getGeraeteDefinition("HardwareGeraete", selectedRefIdGeraeteDefinition, function (err, data) {
            if (err) {
                $('#ajaxLoaderGif').addClass('hidden');
                throw err;
            }

            if (data.standardAdresse) {
                $('#Adresse').val(data.standardAdresse);
                if (data.istAdresseFest == true) {
                    $('#Adresse').prop('readonly', true);
                }
            }
            $('#ajaxLoaderGif').addClass('hidden');
        });

    }

    return {
        init: function (config) {
            $('#auswahlSelect').change(function () {
                refreshAdresse();
            });            

            refreshAdresse();
        }
    };

});