﻿define([], function () {
    "use strict";

    var controllerName = "Cleanup";

    function _IsCleanupAllDatabasesRunning() {

        $.ajax({
            url: controllerName + '/IsCleanupAllRunning',
            type: 'POST',
            datatype: 'json',

            success: function (returnedData) {
                var isRunning = returnedData.isRunning;

                if (isRunning == true) {
                    setTimeout(function () { _IsCleanupAllDatabasesRunning(); }, 1000);
                }
                else {
                    $('#cleanupAllDatabaseWait').addClass('hidden');
                    $('#btnCleanupAllDatabase').prop('disabled', false);

                    $('#alertSuccessCleanupAllDatabase').removeClass('hidden');
                    $('#alertErrorCleanupAllDatabase').addClass('hidden');
                }
            },
            error: function (xhr, status, error) {
                console.log(xhr.responseText);

                $('#alertErrorCleanupAllDatabase').html(xhr.responseText);
                $('#alertErrorCleanupAllDatabase').removeClass('hidden');
                $('#alertSuccessCleanupAllDatabase').addClass('hidden');

                $('#cleanupAllDatabaseWait').addClass('hidden');
                $('#btnCleanupAllDatabase').prop('disabled', false);
            }
        });
    }

    function _CleanupAllDatabases() {

        $('#alertErrorCleanupAllDatabase').addClass('hidden');
        $('#btnCleanupAllDatabase').prop('disabled', true);
        $('#cleanupAllDatabaseWait').removeClass('hidden');
        $('#alertErrorCleanupAllDatabase').html();
        $('#alertSuccessCleanupAllDatabase').addClass('hidden');

        $.ajax({
            url: controllerName + '/AllDatabases',
            type: 'POST',
            datatype: 'json',

            success: function () {
                _IsCleanupAllDatabasesRunning();
            },
            error: function (xhr, status, error) {
                console.log(xhr.responseText);

                $('#alertErrorCleanupAllDatabase').html(xhr.responseText);
                $('#alertErrorCleanupAllDatabase').removeClass('hidden');

                $('#cleanupAllDatabaseWait').addClass('hidden');
                $('#btnCleanupAllDatabase').prop('disabled', false);
            }
        });
    }

    return {
        init: function () {

            $('#btnCleanupAllDatabase').on("click",
                function () {
                    _CleanupAllDatabases();
                });
        }
    };
});
