﻿define([], function () {
    "use strict";

    function _getCookie(name) {
        var value = "; " + document.cookie;
        var parts = value.split("; " + name + "=");

        if (parts.length === 2)
            return parts.pop().split(";").shift();
    }

    async function _AJAXSubmit(oFormElement) {
        const formData = new FormData(oFormElement);

        $('#alertUploadError').addClass('hidden');
        $('#alertUploadError').empty();
        $('#alertUploadSuccess').addClass('hidden');
        $('#alertUploadSuccess').empty();

        try {
            try {
                if ($('#fileSelector').get(0).files.length === 0) {
                    console.log("no files selected");
                    return;
                }
                $('#uploadFileWait').removeClass('hidden');
                $('#btnUpload').prop('disabled', true);

                const response = await fetch(oFormElement.action, {
                    method: 'POST',
                    headers: { 'RequestVerificationToken': _getCookie('RequestVerificationToken') },
                    body: formData
                });

                if (response.status === 200) {
                     response.json().then(
                        function (value) {
                            $('#alertUploadSuccess').html(value.message);
                            $('#alertUploadSuccess').removeClass('hidden');
                         });
                    $('#fileSelector').val('');

                    window.location.replace("/BackupRestore");    //Redirect
                }
                else {
                    response.json().then(
                        function (value) {
                            $('#alertUploadError').html(value.message);
                            $('#alertUploadError').removeClass('hidden');
                        });
                }
            }
            catch (error) {
                console.error('Error:', error);

                $('#alertUploadError').removeClass('hidden');
                $('#alertUploadError').html(error);
            }
        }
        finally {
            $('#uploadFileWait').addClass('hidden');
            $('#btnUpload').prop('disabled', false);
        }
    }

    return {
        init: function () {
            $('#uploadForm').submit(function (event)
            {
                _AJAXSubmit(this);

                return false;
            });
        }
    };
});
