import cti_module 1.0

MainBasisLayoutCTI {

   width:	480;		// displaywidth = von hardware gesetzt
   height:	272;		// displayheight = von hardware gesetzt

   // Customizeable Properties

   colorBackground:	"black";

   property int    layoutCellWidth: 60;
   property int    layoutCellHeight: 48;
   property int    layoutCellHeightStatus: 20
   property int    layoutCellHeightLastRow: 40;
   property int    layoutCellSpace: 10;
   property int    layoutTopMargin: 5;

   property int    bookingButtonImageWidth: 48;
   property int    bookingButtonImageHeight: 48;

   property int    projectPageHeader_height: layoutCellHeight+4
   property int    listElementHeight: layoutCellHeight*1.5 + layoutCellHeight ;  // 72+48 120
   property int    listEntryHeight:   listElementHeight-layoutCellHeightLastRow // -40
   property int    listElementWidth: mainLayout.width
//    property string listEntryColor: "#44AAAAAA" // leichtes grau, wenn die Eintraege sich abheben sollen
   property string listEntryColor: colorBackground
   property string listButtonFillColor: "#66777777"; 
   property string listButtonBorderColor: 		mainLayout.colorActive 

    property int   listNumColumn:              2
   property int    listViewScrollMode: 0;	// 0-Seitenweise oder 1-zeilenweise scrollen
   property int    listViewShowEntryCount: 2	// Anzahl sichtbarer Listeneintrage 
   property int    listTextIconSpace: 8
   property int    listTextPadding: 8

   property int    lowerPanel_Width: mainLayout.layoutWidth-mainLayout.layoutCellWidth*4-16 // NOTE: 	layoutCellWidth = 60 ==> 224 Breite
   property int    lowerPanel_Height: 28
   property int    lowerPanel_x: mainLayout.x+mainLayout.layoutCellWidth*2+8
   property int    lowerPanel_y: mainLayout.layoutHeight+mainLayout.y-lowerPanel_Height //272  // Startposition ausserhalb

   property int    lowerPanel_spacing: 12
   property int    lowerPanel_leftpadding: 4
   property int    lowerPanel_toppadding: 4

   property int    smallButton_width: 28
   property int    smallButton_height: 28

   property int    listButton_width: 60+mainLayout.layoutCellWidth*2*2; //mainLayout.layoutCellWidth

   property int    centeredTextSize: 22

   property int    layoutButtonHeight: layoutCellHeight+layoutCellSpace;

   property int    statusMargin: 8

   property var localeDefault:		Qt.locale(customLocale);

   property bool   automatikModusVisible:    mainLayout.automatikModusVisible  ; //false;
   property bool   automatikModusActive:     mainLayout.automatikModusActive; // wenn false,dann manual
   property string automatikAktivColor:         "#2196F3"
   property string automatikInaktivColor:       "#BABABA"
   property int   fontPixelSizeSmall:       12;
   property string textControlButton_Auto:    "Automatik Modus"
   property string textControlButton_Manual:  "Manueller Modus"

   property bool   enrollFinger_visible:    mainLayout.enrollFinger_visible;

   onCustomLocaleChanged: {
      if(customLocale)
            localeDefault = Qt.locale(customLocale);
   }

// Beginn Emulation Style
   x: _mainWindow.width/2-width/2
   y: 175
   Image {
            id:         _BackgroundImage;
//            source: "../../images/Timi3_Touch_Background.png"
            anchors.horizontalCenter: parent.horizontalCenter
            z: -999
            // sourceSize.width: 1024                 sourceSize.height: 1024
      }

// Ende emulation

}
