import QtQuick.Window 2.0
import QtQuick.Controls 2.12
import QtQuick 2.12

import 'styles'
import 'forms'
import 'scripts'
import cti_module 1.0

Window
{
   id: _mainWindow

   DefaultStyle800{
      id:  mainLayout;

   property bool listColorAlt: true
   }
   width: 1024 // App Window width, im Style ist die Displaygroesse
   height: 768 // App Window height
   title: mainLayout.g_TitleString
   objectName: "Main_Window";
   visible:    true;
   property int global_visible_Status:                 0

   property alias setScaleTouchLayout:             mainLayout.scaleEnabled
   property alias setScrollEnabled:                mainLayout.scrollEnabled
   property alias globalColorBackground:           mainLayout.colorBackground

   property alias globalBackground_source:         mainLayout.globalBackgroundImageSource
   property alias globalBackgroundImage_visible:   mainLayout.globalBackgroundImagevisible

   property alias globalKeyRepeatValue:            mainLayout.keyRepeatValue;
   property alias globalSetAnalogClock_enable:     mainLayout.analogClock;

   property alias globalColorText:                 mainLayout.colorText;
   property alias globalColorActive:               mainLayout.colorActive
   property alias globalColorTextStatus:           mainLayout.colorTextStatus
   property alias globalListButtonFillColor:       mainLayout.listButtonFillColor
   property alias globalColorClockLarge:           mainLayout.colorClockLarge
   property alias globalListButtonTextColor:       mainLayout.listButtonTextColor
   property alias globalKeyboard_enabled:          mainLayout.gKeyboard_enabled

   property alias symbolLan:                       g_symbolPanel.iconLanName
   property alias symbolWireless:                  g_symbolPanel.iconWirelessName
   property alias symbolVPN:                       g_symbolPanel.iconVPNName
   property alias symbolBC:                        g_symbolPanel.iconBCName

   property alias customLocale:                    mainLayout.customLocale;

   property alias sharedStatusClock_visible:       _sharedStatusClock.visibleDummy;
   property alias sharedTxtStatusMsgLeft_text:     mainLayout.textStatusMessage
//    property alias upperStatusVisible:                 _sharedTxtStatusMsgLeftOrig.visible
//    property alias lowerStatusVisible:                 _sharedTxtStatusMsgLeft.visible
   property alias sharedBusyIndicator_enable:      _sharedBusyIndicator.running;

   property alias set_textControlButton_Info:     mainLayout.textControlButton_Info
   property alias set_textControlButton_Clear:    mainLayout.textControlButton_Clear
   property alias set_textControlButton_Home:     mainLayout.textControlButton_Home
   property alias set_textControlButton_OK:       mainLayout.textControlButton_OK
   property alias set_textControlButton_Yes:      mainLayout.textControlButton_Yes
   property alias set_textControlButton_No:       mainLayout.textControlButton_No
   property alias set_textControlButton_Auto:     mainLayout.textControlButton_Auto
   property alias set_textControlButton_Manual:   mainLayout.textControlButton_Manual

   property alias set_automatikModus_visible:     mainLayout.automatikModusVisible
   property alias set_automatikModus_active:      mainLayout.automatikModusActive
   property alias set_symbolpanel_visible:         g_symbolPanel.visible;

   // Pageproperties
   property alias boot_visible:                    bootPage.visible;
   property alias bootTxtMessage_text:             bootPage.bootTxtMessage;

   property alias enrollFingerprintPage_text:      enrollFingerprintPage.enrollFingerprintMessage;
   property alias enrollfingerprint_text:          enrollFingerprintPage.enrollFingerprintMessage;
   property alias enrollfingerprint_visible:       enrollFingerprintPage.visible;

   property alias enrollFingerprintOTPMessage_text: enrollFingerprintOTPPage.enrollFingerprintOTPMessage
   property alias enrollFingerprintOTPHeader_text:  enrollFingerprintOTPPage.enrollFingerprintOTPHeader
   property alias enrollfingerprintotp_visible:     enrollFingerprintOTPPage.visible;

   property alias enrollFinger_visible:            mainLayout.enrollFinger_visible

   property alias bootdata_visible:                bootDataPage.visible;
   property alias bootDataTxtMessage_text:         bootDataPage.bootDataTxtMessage;

   property alias booking_visible:                 bookingPage.visible;
   property alias bookingTxtMessage_text:          bookingPage.bookingTxtMessage
   property alias bookingCallToAction_text:        bookingPage.bookingCallToAction;

   property alias set_bookingSource:               bookingPage.bookingModelSource;
   property alias set_bookingData:                 bookingPage.bookingModelData;
   property alias set_bookingQuery:                bookingPage.bookingModelQuery;

   property alias bookingdoublequestion_visible:            bookingdoublequestionPage.visible;
   property alias bookingDoubleQuestionTxtMessage_text:     bookingdoublequestionPage.bookingDoubleQuestionTxtMessage_text;
   property alias bookingDoubleQuestionCallToAction_text:   bookingdoublequestionPage.bookingDoubleQuestionCallToAction;

   property alias home_visible:                       homePage.visible;
   property alias homepin_visible:                    homePinPage.visible;

   property alias homeCompanyLogo_source:             mainLayout.homeCompanyLogo_source;
   property alias homeCallToAction_text:              mainLayout.homeCallToAction_text;
   property alias homePinCallToAction_text:           mainLayout.homePinCallToAction_text;
   property alias homeFingerEnrollButton_text:        homePage.homeFingerEnrollButton_text;

   property alias confirmerror_visible:               confirmErrorPage.visible;
   property alias confirmerrorTxtMessage_text:        confirmErrorPage.confirmErrorTxtMessage;
   property alias confirmerrorImgCalltoAction_source: confirmErrorPage.confirmErrorImgCallToAction_source;

   property alias employeemessages_visible:           employeeMessagesPage.visible;
   property alias employeeMessagesTxtMessage_text:    employeeMessagesPage.employeeMessages_Message_text;
   property alias employeeMessagesMessageTime_text:   employeeMessagesPage.employeeMessages_MessageTime_text;
   property alias employeeMessagesStatusRight_text:   employeeMessagesPage.employeeMessages_StatusRight_text;

   property alias selectlist_visible:                 selectListPage.visible;
   property alias selectlistTxtMessage_text:          selectListPage.selectListTxtMessage;
   property alias selectlistCallToAction_text:        selectListPage.selectListCallToAction;
   property alias set_selectlistSource:               selectListPage.selectListModelSource;
   property alias set_selectListData:                 selectListPage.selectListModelData;
   property alias set_selectListQuery:                selectListPage.selectListModelQuery;

   property alias inputtext_visible:                  mainLayout.inputTextPage_visible
   property alias inputtextTextMessage_text:          mainLayout.inputTextTxtMessage
   property alias inputtextCallToAction_text:         mainLayout.inputTextCallToAction_text
//   property alias inputtextTextField_text:            mainLayout.inputTextField_text
//   property alias inputtextTextField_readonly:        mainLayout.inputTextField_readOnly
   property alias inputtextTextFieldReg_exp:          mainLayout.inputTextreg_exp
   property alias inputtext_DigitsOnly:               mainLayout.inputTextDigitsOnly

   property alias inputtextTextField_readonly:        inputTextPage.inputTextField_readOnly
    property alias inputtextTextField_text:           inputTextPage.inputTextField_text


   property alias inputnumber_visible:                mainLayout.inputNumberPage_visible
   property alias inputnumberTextMessage_text:        mainLayout.inputNumberTxtMessage
   property alias inputnumberCallToAction_text:       mainLayout.inputNumberCallToActiontext
//   property alias inputnumberTextField_text:         mainLayout.inputNumberField_text
//   property alias inputnumberTextField_readonly:      mainLayout.inputNumberTextField_readOnly
   property alias inputnumberReg_exp:                 mainLayout.inputNumberreg_exp
   property alias inputnumber_passwordMode:           mainLayout.passwordMode
   property alias inputnumber_seperator:              inputNumberPage.inputNumber_seperator
   property alias inputnumberTextField_text:          inputNumberPage.inputNumberField_text
   property alias inputnumberTextField_readonly:      inputNumberPage.inputNumberTextField_readOnly

   property alias inputpin_visible:                   mainLayout.inputPINPage_visible
   property alias inputPinTxtMessage_text:            mainLayout.inputPinTxtMessage
   property alias inputPinCallToAction_text:          mainLayout.inputPinCallToActiontext
   property alias inputpin_Min:                       mainLayout.iMinInputPin
   property alias inputpin_Max:                       mainLayout.iMaxInputPin

   property alias sysinfoidentity_visible: sysinfoidentityPage.visible;
   property alias sysinfoidentity_li0_name: sysinfoidentityPage.li0_name;
   property alias sysinfoidentity_li0_value: sysinfoidentityPage.li0_value;
   property alias sysinfoidentity_li1_name: sysinfoidentityPage.li1_name;
   property alias sysinfoidentity_li1_value: sysinfoidentityPage.li1_value;
   property alias sysinfoidentity_li2_name: sysinfoidentityPage.li2_name;
   property alias sysinfoidentity_li2_value: sysinfoidentityPage.li2_value;
   property alias sysinfoidentity_li3_name: sysinfoidentityPage.li3_name;
   property alias sysinfoidentity_li3_value: sysinfoidentityPage.li3_value;
   property alias sysinfoidentity_li4_name: sysinfoidentityPage.li4_name;
   property alias sysinfoidentity_li4_value: sysinfoidentityPage.li4_value;
   property alias sysinfoidentity_li5_name: sysinfoidentityPage.li5_name;
   property alias sysinfoidentity_li5_value: sysinfoidentityPage.li5_value;
   property alias sysinfoidentity_li6_name: sysinfoidentityPage.li6_name;
   property alias sysinfoidentity_li6_value: sysinfoidentityPage.li6_value;
   property alias sysinfoidentity_cellCountName: sysinfoidentityPage.cellCountName;
   property alias sysinfoidentity_cellCountValue: sysinfoidentityPage.cellCountValue;

   property alias sysinfonetwork_visible: sysinfonetworkPage.visible;
   property alias sysinfonetwork_li0_name: sysinfonetworkPage.li0_name;
   property alias sysinfonetwork_li0_value: sysinfonetworkPage.li0_value;
   property alias sysinfonetwork_li1_name: sysinfonetworkPage.li1_name;
   property alias sysinfonetwork_li1_value: sysinfonetworkPage.li1_value;
   property alias sysinfonetwork_li2_name: sysinfonetworkPage.li2_name;
   property alias sysinfonetwork_li2_value: sysinfonetworkPage.li2_value;
   property alias sysinfonetwork_li3_name: sysinfonetworkPage.li3_name;
   property alias sysinfonetwork_li3_value: sysinfonetworkPage.li3_value;
   property alias sysinfonetwork_li4_name: sysinfonetworkPage.li4_name;
   property alias sysinfonetwork_li4_value: sysinfonetworkPage.li4_value;
   property alias sysinfonetwork_li5_name: sysinfonetworkPage.li5_name;
   property alias sysinfonetwork_li5_value: sysinfonetworkPage.li5_value;
   property alias sysinfonetwork_li6_name: sysinfonetworkPage.li6_name;
   property alias sysinfonetwork_li6_value: sysinfonetworkPage.li6_value;
   property alias sysinfonetwork_cellCountName: sysinfonetworkPage.cellCountName;
   property alias sysinfonetwork_cellCountValue: sysinfonetworkPage.cellCountValue;

   property alias sysinfonetworkwlan_visible: sysinfonetworkwlanPage.visible;
   property alias sysinfonetworkwlan_li0_name: sysinfonetworkwlanPage.li0_name;
   property alias sysinfonetworkwlan_li0_value: sysinfonetworkwlanPage.li0_value;
   property alias sysinfonetworkwlan_li1_name: sysinfonetworkwlanPage.li1_name;
   property alias sysinfonetworkwlan_li1_value: sysinfonetworkwlanPage.li1_value;
   property alias sysinfonetworkwlan_li2_name: sysinfonetworkwlanPage.li2_name;
   property alias sysinfonetworkwlan_li2_value: sysinfonetworkwlanPage.li2_value;
   property alias sysinfonetworkwlan_li3_name: sysinfonetworkwlanPage.li3_name;
   property alias sysinfonetworkwlan_li3_value: sysinfonetworkwlanPage.li3_value;
   property alias sysinfonetworkwlan_li4_name: sysinfonetworkwlanPage.li4_name;
   property alias sysinfonetworkwlan_li4_value: sysinfonetworkwlanPage.li4_value;
   property alias sysinfonetworkwlan_li5_name: sysinfonetworkwlanPage.li5_name;
   property alias sysinfonetworkwlan_li5_value: sysinfonetworkwlanPage.li5_value;
   property alias sysinfonetworkwlan_li6_name: sysinfonetworkwlanPage.li6_name;
   property alias sysinfonetworkwlan_li6_value: sysinfonetworkwlanPage.li6_value;
   property alias sysinfonetworkwlan_cellCountName: sysinfonetworkwlanPage.cellCountName;
   property alias sysinfonetworkwlan_cellCountValue: sysinfonetworkwlanPage.cellCountValue;

   property alias sysinfonetworkvpn_visible: sysinfonetworkvpnPage.visible;
   property alias sysinfonetworkvpn_li0_name: sysinfonetworkvpnPage.li0_name;
   property alias sysinfonetworkvpn_li0_value: sysinfonetworkvpnPage.li0_value;
   property alias sysinfonetworkvpn_li1_name: sysinfonetworkvpnPage.li1_name;
   property alias sysinfonetworkvpn_li1_value: sysinfonetworkvpnPage.li1_value;
   property alias sysinfonetworkvpn_li2_name: sysinfonetworkvpnPage.li2_name;
   property alias sysinfonetworkvpn_li2_value: sysinfonetworkvpnPage.li2_value;
   property alias sysinfonetworkvpn_li3_name: sysinfonetworkvpnPage.li3_name;
   property alias sysinfonetworkvpn_li3_value: sysinfonetworkvpnPage.li3_value;
   property alias sysinfonetworkvpn_li4_name: sysinfonetworkvpnPage.li4_name;
   property alias sysinfonetworkvpn_li4_value: sysinfonetworkvpnPage.li4_value;
   property alias sysinfonetworkvpn_li5_name: sysinfonetworkvpnPage.li5_name;
   property alias sysinfonetworkvpn_li5_value: sysinfonetworkvpnPage.li5_value;
   property alias sysinfonetworkvpn_li6_name: sysinfonetworkvpnPage.li6_name;
   property alias sysinfonetworkvpn_li6_value: sysinfonetworkvpnPage.li6_value;
   property alias sysinfonetworkvpn_cellCountName: sysinfonetworkvpnPage.cellCountName;
   property alias sysinfonetworkvpn_cellCountValue: sysinfonetworkvpnPage.cellCountValue;

   property alias sysinfoconfiguration_visible: sysinfoconfigurationPage.visible;
   property alias sysinfoconfiguration_li0_name: sysinfoconfigurationPage.li0_name;
   property alias sysinfoconfiguration_li0_value: sysinfoconfigurationPage.li0_value;
   property alias sysinfoconfiguration_li1_name: sysinfoconfigurationPage.li1_name;
   property alias sysinfoconfiguration_li1_value: sysinfoconfigurationPage.li1_value;
   property alias sysinfoconfiguration_li2_name: sysinfoconfigurationPage.li2_name;
   property alias sysinfoconfiguration_li2_value: sysinfoconfigurationPage.li2_value;
   property alias sysinfoconfiguration_li3_name: sysinfoconfigurationPage.li3_name;
   property alias sysinfoconfiguration_li3_value: sysinfoconfigurationPage.li3_value;
   property alias sysinfoconfiguration_li4_name: sysinfoconfigurationPage.li4_name;
   property alias sysinfoconfiguration_li4_value: sysinfoconfigurationPage.li4_value;
   property alias sysinfoconfiguration_li5_name: sysinfoconfigurationPage.li5_name;
   property alias sysinfoconfiguration_li5_value: sysinfoconfigurationPage.li5_value;
   property alias sysinfoconfiguration_li6_name: sysinfoconfigurationPage.li6_name;
   property alias sysinfoconfiguration_li6_value: sysinfoconfigurationPage.li6_value;
   property alias sysinfoconfiguration_cellCountName: sysinfoconfigurationPage.cellCountName;
   property alias sysinfoconfiguration_cellCountValue: sysinfoconfigurationPage.cellCountValue;

   property alias sysinfostate_visible: sysinfostatePage.visible;
   property alias sysinfostate_li0_name: sysinfostatePage.li0_name;
   property alias sysinfostate_li0_value: sysinfostatePage.li0_value;
   property alias sysinfostate_li1_name: sysinfostatePage.li1_name;
   property alias sysinfostate_li1_value: sysinfostatePage.li1_value;
   property alias sysinfostate_li2_name: sysinfostatePage.li2_name;
   property alias sysinfostate_li2_value: sysinfostatePage.li2_value;
   property alias sysinfostate_li3_name: sysinfostatePage.li3_name;
   property alias sysinfostate_li3_value: sysinfostatePage.li3_value;
   property alias sysinfostate_li4_name: sysinfostatePage.li4_name;
   property alias sysinfostate_li4_value: sysinfostatePage.li4_value;
   property alias sysinfostate_li5_name: sysinfostatePage.li5_name;
   property alias sysinfostate_li5_value: sysinfostatePage.li5_value;
   property alias sysinfostate_li6_name: sysinfostatePage.li6_name;
   property alias sysinfostate_li6_value: sysinfostatePage.li6_value;
   property alias sysinfostate_cellCountName: sysinfostatePage.cellCountName;
   property alias sysinfostate_cellCountValue: sysinfostatePage.cellCountValue;

   property alias sysinfotransponder_visible: sysinfotransponderPage.visible;
   property alias sysinfotransponder_li0_name: sysinfotransponderPage.li0_name;
   property alias sysinfotransponder_li0_value: sysinfotransponderPage.li0_value;
   property alias sysinfotransponder_li1_name: sysinfotransponderPage.li1_name;
   property alias sysinfotransponder_li1_value: sysinfotransponderPage.li1_value;
   property alias sysinfotransponder_li2_name: sysinfotransponderPage.li2_name;
   property alias sysinfotransponder_li2_value: sysinfotransponderPage.li2_value;
   property alias sysinfotransponder_li3_name: sysinfotransponderPage.li3_name;
   property alias sysinfotransponder_li3_value: sysinfotransponderPage.li3_value;
   property alias sysinfotransponder_li4_name: sysinfotransponderPage.li4_name;
   property alias sysinfotransponder_li4_value: sysinfotransponderPage.li4_value;
   property alias sysinfotransponder_li5_name: sysinfotransponderPage.li5_name;
   property alias sysinfotransponder_li5_value: sysinfotransponderPage.li5_value;
   property alias sysinfotransponder_li6_name: sysinfotransponderPage.li6_name;
   property alias sysinfotransponder_li6_value: sysinfotransponderPage.li6_value;
   property alias sysinfotransponder_cellCountName: sysinfotransponderPage.cellCountName;
   property alias sysinfotransponder_cellCountValue: sysinfotransponderPage.cellCountValue;

   property alias sysinfomobilfunk_visible: sysinfomobilfunkPage.visible;
   property alias sysinfomobilfunk_li0_name: sysinfomobilfunkPage.li0_name;
   property alias sysinfomobilfunk_li0_value: sysinfomobilfunkPage.li0_value;
   property alias sysinfomobilfunk_li1_name: sysinfomobilfunkPage.li1_name;
   property alias sysinfomobilfunk_li1_value: sysinfomobilfunkPage.li1_value;
   property alias sysinfomobilfunk_li2_name: sysinfomobilfunkPage.li2_name;
   property alias sysinfomobilfunk_li2_value: sysinfomobilfunkPage.li2_value;
   property alias sysinfomobilfunk_li3_name: sysinfomobilfunkPage.li3_name;
   property alias sysinfomobilfunk_li3_value: sysinfomobilfunkPage.li3_value;
   property alias sysinfomobilfunk_li4_name: sysinfomobilfunkPage.li4_name;
   property alias sysinfomobilfunk_li4_value: sysinfomobilfunkPage.li4_value;
   property alias sysinfomobilfunk_li5_name: sysinfomobilfunkPage.li5_name;
   property alias sysinfomobilfunk_li5_value: sysinfomobilfunkPage.li5_value;
   property alias sysinfomobilfunk_li6_name: sysinfomobilfunkPage.li6_name;
   property alias sysinfomobilfunk_li6_value: sysinfomobilfunkPage.li6_value;
   property alias sysinfomobilfunk_cellCountName: sysinfomobilfunkPage.cellCountName;
   property alias sysinfomobilfunk_cellCountValue: sysinfomobilfunkPage.cellCountValue;

   property alias setClockImageFace_source:     mainLayout.clockImageFace_source;
   property alias setClockImageSecond_source:   mainLayout.clockImageSecond_source;
   property alias setClockImageMinute_source:   mainLayout.clockImageMinute_source;
   property alias setClockImageHour_source:     mainLayout.clockImageHour_source;
   property alias setClockImagePoint_source:    mainLayout.clockImagePoint_source;

   signal qmlkeypressSignaltolib(string text, int iKey, int iType)

   function receiveButtonfromlib(buttonpressed, type )//, buttonID)
   {
      qmlkeypressSignaltolib("hardware", buttonpressed, type)
//        console.log("---qml Hardware key to lib--->", buttonpressed)
      return 0
   }

   function setGlobalVisible(bvalue)
   {
      if(bvalue)
         global_visible_Status++;
      else
         global_visible_Status--;
      if(global_visible_Status)
      {  _sharedTxtStatusMsgLeft.visible = false
      }
      else
      {
         sharedTxtStatusMsgLeft_text=""
         _sharedTxtStatusMsgLeft.visible = true
      }

   }

   onBookingdoublequestion_visibleChanged:
   {
      setGlobalVisible(bookingdoublequestion_visible)
   }
   onBooking_visibleChanged:
   {
      setGlobalVisible(booking_visible)
   }
   onConfirmerror_visibleChanged:
   {
      setGlobalVisible(confirmerror_visible)
   }

   onSelectlist_visibleChanged:
   {
      setGlobalVisible(selectlist_visible)
   }
   onInputnumber_visibleChanged:
   {
      setGlobalVisible(inputnumber_visible)
   }
   onInputpin_visibleChanged:
   {
      setGlobalVisible(inputpin_visible)
   }

   HelpGrid {
      id: helpGrid;
   }

   CTIBusyIndicator {
      id:             _sharedBusyIndicator;
      anchors.fill:   mainLayout;
   }

   StatusText {
      id:                 _sharedTxtStatusMsgLeft;
      anchors.leftMargin:     mainLayout.statusMargin
      anchors.top:            mainLayout.top
      anchors.left:           mainLayout.left;
      anchors.topMargin:      mainLayout.statusMargin/2
      text:                   mainLayout.textStatusMessage
//      font.pixelSize:   22
   }

   ClockSmall {
      id:                 _sharedStatusClock;
      anchors.rightMargin: mainLayout.statusMargin
      anchors.right:      mainLayout.right
      anchors.top:        mainLayout.top
      currentPixelSize:   mainLayout.fontPixelSizeSmallDate_Time
      property bool visibleDummy: false // Platzhalter, wegen Steuerung von Businesslayer
      visible: false; //Diese Clock ist beim Touch nicht erwuenscht

   }

   Boot {
      id: bootPage;
   }

   EnrollFingerprint {
      id: enrollFingerprintPage;
   }

   EnrollFingerprintOTP {
      id: enrollFingerprintOTPPage;
   }

   BootData {
      id: bootDataPage;
   }
   BookingDoubleQuestionTouch {
      id: bookingdoublequestionPage;
   }
   BookingTouch {
      id: bookingPage;
   }

   Home {
      id: homePage;
   }

   HomePin {
      id: homePinPage
   }

   EmployeeMessagesTouch {
      id: employeeMessagesPage;
   }

   ConfirmError {
      id: confirmErrorPage;
   }

   SymbolPanel {
      id: g_symbolPanel
      z: 99
      anchors.right:      sysinfonetworkPage.right
      anchors.top:        sysinfonetworkPage.top
      visible: false //sysinfoGlobalPagevisible
   }
   AutomaticPanel
   {
      visible: mainLayout.automatikModusVisible
   }

   SelectListTouch {
   id:   selectListPage
   }
   InputText {
      id: inputTextPage
   }
   InputNumber   {
      id: inputNumberPage
   }
   InputPIN {
        id: inputPINPage
   }

   Sysinfo {
      id: sysinfonetworkPage;
   }
   Sysinfo {
      id: sysinfomobilfunkPage;
   }
   Sysinfo {
      id: sysinfonetworkwlanPage;
   }
   Sysinfo {
      id: sysinfonetworkvpnPage;
   }
   Sysinfo {
      id: sysinfoconfigurationPage;
   }
   Sysinfo {
      id: sysinfostatePage;
   }
   Sysinfo {
      id: sysinfoidentityPage;
   }
   Sysinfo {
      id: sysinfotransponderPage;
   }

}
