import QtQuick 2.9
import cti_module 1.0



TerminalPage {
   id:      _sysinfoPage;

   property int cellCountName:   2;
   property int cellCountValue:  5;

   property string li0_name : "";  property string li0_value : "";
   property string li1_name : "";  property string li1_value : "";
   property string li2_name : "";  property string li2_value : "";
   property string li3_name : "";  property string li3_value : "";
   property string li4_name : "";  property string li4_value : "";
   property string li5_name : "";  property string li5_value : "";
   property string li6_name : "";  property string li6_value : "";


   onLi0_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(0, "name", _sysinfoPage.li0_name);
   }
   onLi0_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(0, "value", _sysinfoPage.li0_value);
   }
   onLi1_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(1, "name", _sysinfoPage.li1_name);
   }
   onLi1_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(1, "value", _sysinfoPage.li1_value);
   }
   onLi2_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(2, "name", _sysinfoPage.li2_name);
   }
   onLi2_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(2, "value", _sysinfoPage.li2_value);
   }
   onLi3_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(3, "name", _sysinfoPage.li3_name);
   }
   onLi3_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(3, "value", _sysinfoPage.li3_value);
   }
   onLi4_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(4, "name", _sysinfoPage.li4_name);
   }
   onLi4_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(4, "value", _sysinfoPage.li4_value);
   }
   onLi5_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(5, "name", _sysinfoPage.li5_name);
   }
   onLi5_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(5, "value", _sysinfoPage.li5_value);
   }
   onLi6_nameChanged: {
      if(_listElements.completed)
         _listElements.setProperty(6, "name", _sysinfoPage.li6_name);
   }
   onLi6_valueChanged: {
      if(_listElements.completed)
         _listElements.setProperty(6, "value", _sysinfoPage.li6_value);
   }

   ListModel {
      id: _listElements;

      property bool completed: false;
      Component.onCompleted: {
            append({"name": "",	"value": ""});
            append({"name": "",	"value": ""});
            append({"name": "",	"value": ""});
            append({"name": "",	"value": ""});
            append({"name": "",	"value": ""});
            append({"name": "",	"value": ""});
            append({"name": "",	"value": ""});

            completed = true;
      }
   }

   ListView {
      id: _listSysinfo;

      property int currentFontPixelSize: mainLayout.fontPixelSizeStatus ? mainLayout.fontPixelSizeStatus : 18;

      y:                         mainLayout.layoutCellHeight + mainLayout.layoutCellSpace/2 +(mainLayout.layoutCellSpace/2)*!mainLayout.desingnTouch // +8;
      anchors.horizontalCenter:  parent.horizontalCenter;
      width:                     mainLayout.width-mainLayout.statusMargin*2;
      height:                    3*mainLayout.layoutCellHeight + 3*mainLayout.layoutCellSpace + mainLayout.layoutCellHeightLastRow*!mainLayout.desingnTouch
      interactive:               false
      model: _listElements

      delegate: Rectangle {
            id:                  rect1;
            border.width:        0;
            width:               _listSysinfo.width;
            height:              _listSysinfo.currentFontPixelSize + 6 +4*mainLayout.desingnTouch - mainLayout.layoutScaleOffset/4
            color:               mainLayout.colorBackground;

            Text {
               id:               txtName;
               color:            mainLayout.colorText;
               anchors.left:     parent.left;
               font.pixelSize:   _listSysinfo.currentFontPixelSize+4*mainLayout.desingnTouch - mainLayout.layoutScaleOffset/2
               verticalAlignment:   Text.AlignVCenter;
               horizontalAlignment: Text.AlignHLeft;
               width:            _sysinfoPage.cellCountName*mainLayout.layoutCellWidth + (_sysinfoPage.cellCountName-1)*mainLayout.layoutCellSpace;
               height:           parent.height;
               rightPadding:     mainLayout.layoutCellSpace;
               wrapMode:         Text.NoWrap;
               font.italic:      true;
               text:             name ? name + ": " : "";
            }
            Text {
               id:               txtValue;
               color:            mainLayout.colorText;
               font.pixelSize:   _listSysinfo.currentFontPixelSize+4*mainLayout.desingnTouch - mainLayout.layoutScaleOffset/2
               verticalAlignment:   Text.AlignVCenter;
               horizontalAlignment: Text.AlignHLeft;
               width:            _sysinfoPage.cellCountValue*mainLayout.layoutCellWidth + (_sysinfoPage.cellCountValue-1)*mainLayout.layoutCellSpace;
               height:           parent.height;
               anchors.left:     txtName.right;
               wrapMode:         Text.NoWrap;
               text:             value
            }
   Rectangle{ border.width: 1; border.color: "green"; anchors.fill: txtName; color: "transparent"; visible: mainLayout.g_enableDebug   }
   Rectangle{ border.width: 1; border.color: "blue"; anchors.fill: txtValue; color: "transparent"; visible: mainLayout.g_enableDebug   }
// border.width: 1; border.color: "red";
      }
      spacing: 6+mainLayout.layoutScaleOffset/2;
   }
   Rectangle{ border.width: 1; border.color: "yellow"; anchors.fill: _listSysinfo; color: "transparent"; visible: mainLayout.g_enableDebug   }

   ControlButton {
      myButtonId: "FKT_Key_Clear"
      iHWKey: 1067
      text:     mainLayout.textControlButton_Home
      width:   140
      x: mainLayout.layoutTopMargin
      anchors.bottom: _sysinfoPage.bottom
      anchors.bottomMargin:  mainLayout.layoutCellHeightLastRow/2
      buttonTextColor: mainLayout.controlButtonTextColor
      pixelSize: mainLayout.fontPixelSizeKeyText
      visible: mainLayout.desingnTouch
   }
        ControlButton{
         id: _KeyUpListView
         invertSendValue: true
         myButtonId: "FKT_Key_Up"
         iHWKey: 1072
         anchors.right:  _sysinfoPage.horizontalCenter
         anchors.rightMargin:  mainLayout.layoutTopMargin+6
         source:     globalPathToImages+"control_hoch_48h.png"
         // border.width: 0
         anchors.bottom: _sysinfoPage.bottom
         anchors.bottomMargin:  mainLayout.layoutCellHeightLastRow/2
         visible: mainLayout.desingnTouch
   width: mainLayout.controlButtonWidth*2
   height: mainLayout.controlButtonHeight+4
   imageFillMode:             Image.Stretch


      }
      ControlButton{
         id: _KeyDownListView
         invertSendValue: true
         myButtonId: "FKT_Key_Down"
         iHWKey: 1082
         anchors.left:       _sysinfoPage.horizontalCenter
         anchors.leftMargin:  mainLayout.layoutTopMargin+6
         source:     globalPathToImages+"control_runter_48h.png"
         // border.width: 0
         anchors.bottom: _sysinfoPage.bottom
         anchors.bottomMargin:  mainLayout.layoutCellHeightLastRow/2
         visible: mainLayout.desingnTouch
         width: mainLayout.controlButtonWidth*2
         height: mainLayout.controlButtonHeight+4
imageFillMode:             Image.Stretch

      }

   TouchButton{ // OK-Taste, wenn lange gedrueckt, nicht sichtbar
      id: debug_rectangle
      x:                   mainLayout.layoutTopMargin;
      y:                   mainLayout.layoutTopMargin-mainLayout.desingnTouch*25;
      width:               (100+mainLayout.desingnTouch*25) *2 ;
      height:              50+mainLayout.desingnTouch*25;
      iHWKey:           1079
      myButtonId:       "hardware";
      keyPressHoldTime: 2000
      tapHandler_id.bLongPressOnly: true
   }
   Rectangle{ border.width: 2; border.color: "blue"; anchors.fill: debug_rectangle; visible: mainLayout.g_enableDebug   }
}
