import cti_module 1.0
import QtQuick.Controls 2.2
import QtQuick 2.12

// TODO: die control button und die liste

TerminalPage {
   id:                                          _selectListPage;
   property int iSelectedIndex:     -1
   property alias selectListTxtMessage:         _selectListTxtMessage.text
   property alias selectListCallToAction:       _selectListCallToAction.text

   property alias selectListModelSource:        _jsonDataModel.source
   property alias selectListModelData:          _jsonDataModel.json
   property alias selectListModelQuery:         _jsonDataModel.query // aktuell unbenutzt, Filtern geht in C# besser
   color: mainLayout.listButtonFillColor

   function resetListView()
   {
/* Original
      // Reset Auswahl: kein Element gewaehlt, Ansicht auf Anfang
      _selectionGrid.positionViewAtIndex(0, GridView.Beginning)
      if(_selectionGrid.currentIndex >= 0)
         _selectionGrid.currentItem.aliasState = "DESELECTED"
      _selectionGrid.currentIndex = -1
*/
      iSelectedIndex=0;
      for (var s = 0; s < _selectionGrid.count; s++)
      {
         if(_selectionGrid.model.get(s).isSelected)
         {
            iSelectedIndex=s;
            _selectionGrid.currentIndex =s
         }
      }
      // Reset Auswahl: kein Element gewaehlt, Ansicht auf Anfang
     _selectionGrid.positionViewAtIndex( iSelectedIndex, GridView.Beginning)
      _selectionGrid.currentIndex = iSelectedIndex
   }

   onVisibleChanged:
   {
      resetListView()
   }
   TimeSmall{ // Uhr ohne Datum
      id: _time
      anchors.right:          _leftPage.right
      anchors.topMargin:      0
      anchors.rightMargin:    0
   }

   DateSmall { // nur Datum
      id: _date
        anchors.left:         _leftPage.left
        anchors.topMargin:    0
        anchors.leftMargin:   0
   }

// help json tags: https://goessner.net/articles/JsonPath/
// Kopie, mit Aenderungen git: https://github.com/ubuntudroid/qml-utils
// git Original: https://github.com/kromain/qml-utils
   JSONListModel {
       id:              _jsonDataModel
      onDataChanged:
      {
         resetListView()
      }

   }

   Rectangle{
      id:            _leftPage
      width:      mainLayout.widthCallToAction       //
      height:        _selectListPage.height -( 2*mainLayout.layoutTopMargin*mainLayout.desingnTouch)
      color:         "transparent"
      x:          mainLayout.layoutTopMargin*mainLayout.desingnTouch+( (mainLayout.width/2-mainLayout.widthCallToAction/2) *!mainLayout.desingnTouch)
      y:          mainLayout.layoutTopMargin*mainLayout.desingnTouch


// StatusText mit Link auf Text mainLayout.textStatusMessage, globaler Statustext entfernt
      StatusText {
         id:                  _sharedTxtStatusSelectList;
         font.pixelSize:      mainLayout.fontPixelSizeCallToAction
         width:               _leftPage.width
         anchors.left:        _leftPage.left;
         text:                mainLayout.textStatusMessage
         visible:             _selectListPage.visible
         anchors.top:            _leftPage.top
//         anchors.topMargin:      mainLayout.layoutCellSpace
      }


// Debug
      Rectangle { anchors.fill: _sharedTxtStatusSelectList; color: "transparent"; border.width: 2; border.color: "lightblue"; visible: mainLayout.g_enableDebug }

      MessageArea {
         id:                     _selectListTxtMessage;
         y:                      mainLayout.layoutCellSpace*2*mainLayout.desingnTouch+mainLayout.layoutCellHeight*!mainLayout.desingnTouch - mainLayout.layoutCellSpace*mainLayout.scaleEnabled
         horizontalAlignment :   mainLayout.messageAreaTextAlign
         anchors.horizontalCenter:  _leftPage.horizontalCenter;
         width:                     _leftPage.width
      }
// Debug
      Rectangle{ border.width: 2; border.color: "yellow"; anchors.fill: _selectListTxtMessage; color: "transparent"; visible: mainLayout.g_enableDebug }

      CallToActionArea {
         id:                     _selectListCallToAction
         textAlignmentH:         mainLayout.callToActionTextAlign
         height:                 mainLayout.heightCallToAction
         anchors.top:            _selectListTxtMessage.bottom
         anchors.topMargin:      mainLayout.callToActionTopMargin
      }
// Debug
      Rectangle{ border.width: 2; border.color: "red"; anchors.fill: _selectListCallToAction; color: "transparent"; visible: mainLayout.g_enableDebug }

      ControlButton {
         myButtonId:             "FKT_Key_Clear"
         iHWKey:                 1067
         text:                   mainLayout.textControlButton_No
         width:                  140
         anchors.bottom:         _leftPage.bottom
         buttonTextColor:        mainLayout.controlButtonTextColor
         pixelSize:              mainLayout.fontPixelSizeKeyText
// falls notwendig, onKlicked -> Reset: _selectionGrid.currentItem.sState = "RELEASED"
      }

      ControlButton {
         myButtonId:             "FKT_Key_OK"
         iHWKey:                 1079
         text:                   mainLayout.textControlButton_OK
         width:                  140
         x:                      150+20
         anchors.bottom:         _leftPage.bottom
         buttonTextColor:        mainLayout.controlButtonTextColor
         pixelSize:              mainLayout.fontPixelSizeKeyText
// falls notwendig, onKlicked -> Reset: _selectionGrid.currentItem.sState = "RELEASED"
      }
   }

   GridView {
      id:                        _selectionGrid
      width:                    30*mainLayout.scaleEnabled + _selectListPage.width/2-mainLayout.layoutTopMargin-6;
      height:                   mainLayout.layoutScaleOffset + _selectListPage.height-2*mainLayout.layoutTopMargin-6

      anchors.top:               _selectListPage.top
      anchors.topMargin:         mainLayout.layoutTopMargin+4 -8*mainLayout.scaleEnabled
      anchors.right:             _selectListPage.right
      anchors.rightMargin:       mainLayout.layoutTopMargin-(mainLayout.layoutTopMargin/2)*mainLayout.scaleEnabled

      clip:                      true;
      snapMode:                  GridView.SnapToRow;
      currentIndex:              -1 // nichts ausgewält beim start
      cellWidth:                 (_selectionGrid.width/mainLayout.listNumColumn)-4
      cellHeight:                mainLayout.listCellHeight + 10*mainLayout.scaleEnabled
      model:                     _jsonDataModel.model
      delegate:   Item {
         id: _iItem
            x:                      mainLayout.bookCellSpacing/2
            y:                      mainLayout.bookCellSpacing/2
            width:                  _selectionGrid.cellWidth
            height:                 _selectionGrid.cellHeight + 6*mainLayout.scaleEnabled
            property alias aliasButtonID: _listelem.myButtonId

            SelectListEntry {
               id: _listelem
               listEntryText:          model.ButtonText
               myButtonId:             model.ButtonID
               isEnabled:              model.enable ? model.enable : true
               textColor:              mainLayout.listButtonTextColor
               width:                  _selectionGrid.cellWidth-9-4
               height:                 _selectionGrid.cellHeight-mainLayout.listCellSpacing-mainLayout.listCellSpacing*mainLayout.scaleEnabled
               anchors.centerIn:  parent
               colorPreselect:          model.ColorPreselect ? model.ColorPreselect : ""
            MouseArea {
               id: mArea
               anchors.fill:        parent
               onPressed:
               {
                  _selectionGrid.currentIndex = index;
                  qmlkeypressSignaltolib(_selectionGrid.currentItem.aliasButtonID, 1084, 0);
               }
            }
         }// ListEntry
   Rectangle{ border.width: 2; border.color: "blue"; anchors.fill: _listelem; color: "transparent"; visible: mainLayout.g_enableDebug  }
      }// Item
      ScrollIndicator.vertical: ScrollIndicator {
         id: _scrollBarGrid
         size: 0.2
         active: true;
         visible: (_selectionGrid.count>10)
         contentItem: Rectangle {
            implicitWidth:  6
            implicitHeight: 100
            radius: width / 2
            color:  Qt.lighter(mainLayout.listButtonFillColor, 1.6)
         }
         background: Rectangle {
            id:      _ScrollBackRecGrid
            color:  Qt.darker(mainLayout.listButtonFillColor, 1.6)
         }
      }
      onMovementStarted:
      {
         // TimeKeeper Key
         qmlkeypressSignaltolib("FKT_Key_Move_Start", 1084,1)
      }
      onMovementEnded:
      {
         qmlkeypressSignaltolib("FKT_Key_Move_End", 1084,1)
      }

   } // GridView
 //debug
   Rectangle{ border.width: 1; border.color: "green"; anchors.fill: _selectionGrid; color: "transparent"; visible: mainLayout.g_enableDebug   }
   Rectangle{ border.width: 2; border.color: "purple"; anchors.fill: _leftPage; color: "transparent"; visible: mainLayout.g_enableDebug  }
}   // _selectListPage
