import cti_module 1.0
//import QtQuick.Controls 2.2
import QtQuick 2.12

TerminalPage {
   id:                                          _selectListPage;
   property alias selectListTxtMessage:         _selectListTxtMessage.text
   property alias selectListCallToAction:       _selectListCallToAction.text
   property int iViewPage: 0
   property int iPagesMax: 0
   property int iMovingDirection:  0
   property int iSelectedIndex:     -1

   property alias selectListModelSource:        _jsonDataModel.source
   property alias selectListModelData:          _jsonDataModel.json
   property alias selectListModelQuery:         _jsonDataModel.query // aktuell unbenutzt, Filtern geht in C# besser
   color: mainLayout.listButtonFillColor

   function resetListView()
   {
      iSelectedIndex=0;
      for (var s = 0; s < _selectionGrid.count; s++)
      {
         if(_selectionGrid.model.get(s).isSelected)
         {
            iSelectedIndex=s;
            _selectionGrid.currentIndex =s
         }
      }
      // Reset Auswahl: kein Element gewaehlt, Ansicht auf Anfang
      iViewPage=iSelectedIndex/4;
     _selectionGrid.positionViewAtIndex(iViewPage*4, GridView.Beginning)
      iPagesMax=(_selectionGrid.count/4)-1
      iMovingDirection=0;
   }

   onVisibleChanged:
   {
           resetListView()
   }

   function receiveButtonfromlib(buttonpressed, type)
   {
      var i_index =-1
      var i_x=0
      var i_y=0
      if(buttonpressed==1075)    // Oben/Links
      {
         i_x=80
         i_y=10+_selectionGrid.cellHeight*iViewPage*2
      }

      if(buttonpressed==1071)    // Oben/Rechts
      {
         i_x=400
         i_y=10+_selectionGrid.cellHeight*iViewPage*2

      }

      if(buttonpressed==1066)    // Unten/Links
      {
         i_x=80
         i_y=10+_selectionGrid.cellHeight*(iViewPage*2+1)

      }

      if(buttonpressed==1069)    // Unten/Rechts
      {
         i_x=400
         i_y=10+_selectionGrid.cellHeight*(iViewPage*2+1)
      }

      if(i_x>0)
      {
         if( !_selectionGrid.itemAt( i_x, i_y).isEnabled )
            return;
         i_index=_selectionGrid.indexAt(i_x, i_y)
         if(i_index>=0)
         {
            _selectionGrid.currentIndex=i_index
            qmlkeypressSignaltolib(_selectionGrid.currentItem.myButtonId, buttonpressed, type);
         }
      }
      else // sonstige Taste zurueckgeben/weiterleiten
      {
         keyTapSignal("hardware", buttonpressed, type)
      }
      return _selectionGrid.currentIndex
   }
   function keyTapSignal(text, iKey,iType)
   {
      if(iType<2)
      {
         if(iMovingDirection)
            return;  // Bewegung noch aktiv, warten!

         if(iKey == 1072)	// move up / Key down
         {
            if(iViewPage>0)
            {
//                iViewPage--;
               iMovingDirection=1;
               _selectionGrid.flick(0,750)
            }
         }

         if(iKey == 1082)	// move down
         {
            if(iViewPage < iPagesMax )
            {
//                iViewPage++;
               iMovingDirection=2;
               _selectionGrid.flick(0,-750)
            }
         }
      }
      qmlkeypressSignaltolib(text,  iKey,iType )

   }

   TimeSmall{ // Uhr ohne Datum
      id: _time
      anchors.right:          _leftPage.right
      anchors.topMargin:      0
      anchors.rightMargin:    0
      visible:            mainLayout.desingnTouch
   }

   DateSmall { // nur Datum
      id: _date
      anchors.left:         _leftPage.left
      anchors.topMargin:    0
      anchors.leftMargin:   0
      visible:            mainLayout.desingnTouch
   }

// help json tags: https://goessner.net/articles/JsonPath/
// Kopie, mit Aenderungen git: https://github.com/ubuntudroid/qml-utils
// git Original: https://github.com/kromain/qml-utils
   JSONListModel {
      id:              _jsonDataModel
      onDataChanged:
      {
         resetListView()
      }
   }

   Rectangle{
      id:            _leftPage
      width:         _selectListPage.width-mainLayout.statusMargin*2 // -> Touch: mainLayout.widthCallToAction       //
      height:        _selectListPage.height-( 2*mainLayout.layoutTopMargin*mainLayout.desingnTouch)
      color:         "transparent"
      x:             mainLayout.statusMargin

      MessageArea {
         id:                     _selectListTxtMessage;
         y:                      mainLayout.layoutCellHeightStatus+mainLayout.statusMargin+mainLayout.layoutCellHeight + mainLayout.layoutCellSpace + (mainLayout.controlButtonHeight ? mainLayout.controlButtonHeight : 60)
         horizontalAlignment :   mainLayout.messageAreaTextAlign
         anchors.left:           _leftPage.left;
         width:                  _leftPage.width
         height:                 mainLayout.layoutCellHeight+6-mainLayout.layoutCellHeightStatus-mainLayout.statusMargin // = 26
         verticalAlignment:      Text.AlignVCenter;
         minimumPixelSize:       16
         fontSizeMode:           Text.Fit
      }
// Debug Rectangle { color: "transparent"; anchors.fill: _selectListTxtMessage; border.width: 2; border.color: "red"}
      CallToActionArea {
         id:                     _selectListCallToAction
         y:                      mainLayout.layoutCellHeightStatus+mainLayout.statusMargin
         anchors.left:           _leftPage.left;
         width:                  _leftPage.width
         height:                 mainLayout.layoutCellHeight+6-mainLayout.layoutCellHeightStatus-mainLayout.statusMargin // = 26
         textAlignmentH:         mainLayout.callToActionTextAlign
         dotLineEnabled:         0;
      }
// Debug Rectangle { color: "transparent"; anchors.fill: _selectListCallToAction; border.width: 2; border.color: "yellow"}

      ControlButton {
         myButtonId:             "FKT_Key_Clear"
         iHWKey:                 1067
         text:                   mainLayout.textControlButton_No
         width:                  140
         anchors.bottom:         _leftPage.bottom
         buttonTextColor:        mainLayout.controlButtonTextColor
         pixelSize:              mainLayout.fontPixelSizeKeyText
         visible:                mainLayout.desingnTouch
      }
      ControlButton {
         myButtonId:             "FKT_Key_OK"
         iHWKey:                 1079
         text:                   mainLayout.textControlButton_OK
         width:                  140
         x:                      150
         anchors.bottom:         _leftPage.bottom
         buttonTextColor:        mainLayout.controlButtonTextColor
         pixelSize:              mainLayout.fontPixelSizeKeyText
         visible:                mainLayout.desingnTouch
      }

   }

   GridView {
      id:                        _selectionGrid
      width:                     _selectListPage.width-mainLayout.listCellSpacing*2
      height:                    cellHeight*2
      clip:                      true;
      snapMode:                  GridView.SnapToRow;
      boundsMovement:            Flickable.StopAtBounds;
      currentIndex:              -1 // nichts ausgewält beim start
      x:                         mainLayout.listCellSpacing*2
      y:                         mainLayout.layoutCellHeight+6
      cellWidth:                 (_selectionGrid.width/mainLayout.listNumColumn)
      cellHeight:                4+mainLayout.layoutCellSpace+mainLayout.layoutButtonHeight+mainLayout.layoutCellHeight

      model:                     _jsonDataModel.model

      delegate: SelectListEntry
      {
         listEntryText:          model.ButtonText
         myButtonId:             model.ButtonID
         isEnabled:              model.enable ? model.enable : true
         textColor:              mainLayout.listButtonTextColor;
         width:                  _selectionGrid.cellWidth-mainLayout.listCellSpacing*2
         height:                 80//_selectionGrid.cellHeight-mainLayout.listCellSpacing
         radius:                 mainLayout.bottonFrameRadius*mainLayout.listCellSpacing
         txt_horizontalAlignment:         Text.AlignHCenter
         colorPreselect:          model.ColorPreselect ? model.ColorPreselect : ""
      }  // ListEntry

      onMovementStarted:
      {
         // TimeKeeper Key
         qmlkeypressSignaltolib("FKT_Key_Move_Start", 1084,1)
      }
      onMovementEnded:
      {
         if(iMovingDirection==1) //Down, list up
         {  //console.log("move end pages --");
            iViewPage--;
         }
         if(iMovingDirection==2) //Up, list Down
         {  //console.log("move end pages ++ ");
            iViewPage++
         };
         iMovingDirection=0

         qmlkeypressSignaltolib("FKT_Key_Move_End", 1084,1)
      }

   } // GridView
//     Rectangle { border.color: "yellow";      border.width: 1; anchors.fill: _selectionGrid; color: "transparent" }
//     Rectangle { border.color: "red";      border.width: 1; anchors.fill: _leftPage; color: "transparent" }

}   // _selectListPage
