import QtQuick 2.12
import QtQuick.Controls 2.12
/*
import QtQuick.VirtualKeyboard 2.2
import QtQuick.VirtualKeyboard.Settings 2.2
import QtQuick.VirtualKeyboard.Styles 2.2
*/
import cti_module 1.0

TerminalPage {
   id:        _InputPageText;
   visible:    mainLayout.inputTextPage_visible

   property alias inputTextField_readOnly:   _inputTextkeys.readOnly
   property alias inputTextField_text:       _inputTextkeys.text

   onVisibleChanged:
   {
      if (visible)
      {
//          if(mainLayout.inputTextDigitsOnly)
//             _inputTextkeys.inputMethodHints = Qt.ImhDigitsOnly
//          else
//
         _inputTextkeys.inputMethodHints = Qt.ImhNone
      }
   }
   Rectangle
   {  id:   _inputMessageFrame
      y:                         mainLayout.layoutCellHeightStatus+8// 48
      anchors.horizontalCenter:  _InputPageText.horizontalCenter;

      width:         6*mainLayout.layoutCellWidth + 3*mainLayout.layoutCellSpace;
      height:        2*mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
      color:         mainLayout.listButtonFillColor  //  "#454545"
      MessageArea {
         id:                           _inputTxtMessage;
         y:                            5 //mainLayout.layoutCellHeightStatus + mainLayout.layoutCellSpace;
         width:                        _inputMessageFrame.width-mainLayout.statusMargin
         anchors.horizontalCenter:     _inputMessageFrame.horizontalCenter
         x:                            mainLayout.statusMargin/2 //16-Touch
         height:                       mainLayout.layoutCellHeight+mainLayout.layoutCellSpace*!mainLayout.desingnTouch
         wrapMode:                     Text.Wrap
         text:                         mainLayout.inputTextTxtMessage
      }
//Debug Rectangle{      color: "transparent";  border.width: 2;  border.color: "#bbbb33";  anchors.fill:  _inputTxtMessage }

//      TextInput
      TextField
      {  id:      _inputTextkeys
         anchors.horizontalCenter:  _inputMessageFrame.horizontalCenter;
//         placeholderText:     "input Text here..."
         font.pixelSize:			   (mainLayout.fontPixelSizeDefault ? mainLayout.fontPixelSizeDefault : 16)
         color:                     mainLayout.colorText;
         focus:                     _InputPageText.visible
         cursorVisible:             activeFocus
         anchors.top:               _inputTxtMessage.bottom
         width:                     _inputMessageFrame.width-mainLayout.statusMargin
         x:                         mainLayout.statusMargin/2 //16-Touch
//         text:                      mainLayout.inputTextField_text
//         readOnly:                  mainLayout.inputTextField_readOnly
         background: Rectangle {
                     implicitWidth: 10
                     implicitHeight: 10
                      color:           "#323232"
                      anchors.fill:    _inputTextkeys
         }
         Rectangle{      color: "transparent";  border.width: 2;  border.color: "gray";  anchors.fill:  _inputTextkeys }
         validator:  RegExpValidator { regExp: RegExp(mainLayout.inputTextreg_exp) }
         onAccepted:
         {   //console.log("Edit finished :", focusReason, "Text: ", _inputTextkeys.text );
            qmlkeypressSignaltolib(_inputTextkeys.text, 25, 4);  //HACK: die Funktion ruft Tasteneingabe auf, mit der 4 wird das Ereignis 25 draus-> Texteingabe
         }

      }
      ControlButton {
         myButtonId:       "FKT_Key_Clear"
         iHWKey:           1067
         text:             mainLayout.textControlButton_No
         width:            140
         anchors.bottom:   _inputMessageFrame.bottom
         anchors.bottomMargin: mainLayout.listTextIconSpace
         anchors.right:       _ButtonRight.left
         anchors.rightMargin:    mainLayout.statusMargin/2
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }
      ControlButton {
         id:               _ButtonRight
         myButtonId:       "FKT_Key_OK"
         iHWKey:           1079
         text:             mainLayout.textControlButton_OK
         width:            140
         anchors.right:       _inputMessageFrame.right
         anchors.rightMargin:    mainLayout.statusMargin/2

         anchors.bottom:   _inputMessageFrame.bottom
         anchors.bottomMargin : mainLayout.listTextIconSpace
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }
   }
     CallToActionArea
    {
        id: _inputCallToAction;
        width:    mainLayout.widthCallToAction+mainLayout.layoutCellSpace*2
        text:     mainLayout.inputTextCallToAction_text
    }
/*
//Debug Rectangle{      color: "transparent";  border.width: 2;  border.color: "red";  anchors.fill:  _inputCallToAction }
   InputPanel {
      id:      inputPanel
      y:       _InputPageText.height
      width:   parent.width+40
      x: -20
      visible: mainLayout.gKeyboard_enabled && mainLayout.desingnTouch //&& mainLayout.inputTextPage_visible

      Component.onCompleted:
      {
         VirtualKeyboardSettings.locale = mainLayout.customLocale
         keyboard.style.characterPreviewMargin = -20
      }
        states: State {
            name: "visible"
            when: inputPanel.active
            PropertyChanges {
                target: inputPanel
                y: parent.height - inputPanel.height
            }

        }
        transitions: Transition {
            from: ""
            to: "visible"
            reversible: true
            ParallelAnimation {
                NumberAnimation {
                    properties: "y"
                    duration: 300
                    easing.type: Easing.InOutQuad
                }
            }
        }

    }
    */
}   // _InputPageText


