import cti_module 1.0

import QtQuick 2.12
import QtQuick.Controls 2.12

TerminalPage {
   id:        _inputNumberPage;
   visible:    mainLayout.inputNumberPage_visible
   property bool showKeyPanel: false
//   property alias inputNumberTextField_readOnly:   inputPanelDigits.readOnly //_inputField.readOnly
//    property alias inputNumberField_text:         inputPanelDigits.text  //  _inputField.text
    property alias inputNumber_seperator:           inputPanelDigits.seperator
property bool inputNumberTextField_readOnly:   false
property string inputNumberField_text:           ""


   onVisibleChanged:
   {
      if (visible)
      {
         _inputNumberPage.showKeyPanel=true
         if(mainLayout.passwordMode)
            _inputField.echoMode= TextInput.Password
         else
            _inputField.echoMode = TextInput.Normal
      }
      else
         _inputNumberPage.showKeyPanel=false
   }

   TimeSmall{ // Uhr ohne Datum
      id: _time
      anchors.right:          _helpPageLeftInput.right
      anchors.topMargin:      0 + mainLayout.layoutScaleOffset
      anchors.rightMargin:    0
      visible:    mainLayout.desingnTouch
   }

   DateSmall { // nur Datum
      id: _date
      anchors.left:           _helpPageLeftInput.left
      anchors.leftMargin:     0
      anchors.topMargin:      0 + mainLayout.layoutScaleOffset
      visible:                mainLayout.desingnTouch
   }

   Rectangle{
      id:         _helpPageLeftInput
      width:      mainLayout.widthCallToAction       //
      height:     _inputNumberPage.height-( 2*mainLayout.layoutTopMargin*mainLayout.desingnTouch)
      color:      "transparent"
      x:          mainLayout.layoutTopMargin*mainLayout.desingnTouch+( (mainLayout.width/2-mainLayout.widthCallToAction/2) *!mainLayout.desingnTouch)
      y:          mainLayout.layoutTopMargin*mainLayout.desingnTouch
      z:          20
      visible:    mainLayout.desingnTouch

      MessageArea {
         id:                        _inputTxtMessage;
         y:                         mainLayout.layoutCellSpace*2*mainLayout.desingnTouch+mainLayout.layoutCellHeight*!mainLayout.desingnTouch;
         horizontalAlignment :      mainLayout.messageAreaTextAlign// Text.AlignLeft;
         anchors.horizontalCenter:  _helpPageLeftInput.horizontalCenter;
         width:                     _helpPageLeftInput.width
         text:                      mainLayout.inputNumberTxtMessage

      }
      CallToActionArea {
         id:                  _inputCallToAction;
         width:               _helpPageLeftInput.width
         textAlignmentH:      mainLayout.callToActionTextAlign
         height:              mainLayout.heightCallToAction
         anchors.top:         _inputTxtMessage.bottom
         anchors.topMargin:   mainLayout.callToActionTopMargin
         text:  mainLayout.inputNumberCallToActiontext
      }
//debug
   Rectangle{ border.width: 2; border.color: "yellow"; anchors.fill: _inputTxtMessage; color: "transparent" ; visible: mainLayout.g_enableDebug  }
   Rectangle{ border.width: 2; border.color: "red"; anchors.fill: _inputCallToAction; color: "transparent"; visible: mainLayout.g_enableDebug  }

      ControlButton {
         myButtonId:       "FKT_Key_Clear"
         iHWKey:           1067
         text:             mainLayout.textControlButton_Home//"Home"
         width:            140
         anchors.bottom:   _helpPageLeftInput.bottom
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }
      ControlButton {
         myButtonId:       "FKT_Key_OK"
         iHWKey:           1079
         text:             mainLayout.textControlButton_OK
         width:            140
         x:                150+20
         anchors.bottom:   _helpPageLeftInput.bottom
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }

   }
   Rectangle{ border.width: 2; border.color: "purple"; anchors.fill: _helpPageLeftInput; color: "transparent"; visible: mainLayout.g_enableDebug  }

   MessageArea {
      id:      _inputTxtMessage480;
      y:       100//mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
      z:       2
      width:    mainLayout.widthCallToAction+mainLayout.layoutCellWidth+mainLayout.layoutCellSpace*3
      height:                       mainLayout.layoutCellHeight+mainLayout.layoutCellSpace*!mainLayout.desingnTouch
      anchors.horizontalCenter:     _helpPageLeftInput.horizontalCenter;
      visible: !mainLayout.desingnTouch
      text:    mainLayout.inputNumberTxtMessage
    }
// Debug    Rectangle{      color: "transparent";  border.width: 2;  border.color: "red";  anchors.fill:  _inputTxtMessage480 }
   CallToActionArea {
      id: _inputCallToAction480;
      width:    mainLayout.widthCallToAction+mainLayout.layoutCellWidth+mainLayout.layoutCellSpace*3
      visible:  !mainLayout.desingnTouch
      text:     mainLayout.inputNumberCallToActiontext
    }
/*
   TextField  {
      id:               _inputField
      font.pixelSize:   (mainLayout.fontPixelSizeDefault ? mainLayout.fontPixelSizeDefault : 16)
      color:            mainLayout.colorText;
      y: 50 + (!mainLayout.desingnTouch*mainLayout.layoutCellSpace)
      anchors.right:          _inputNumberPage.right
      anchors.rightMargin:    mainLayout.desingnTouch*mainLayout.layoutTopMargin+(!mainLayout.desingnTouch*(_inputNumberPage.width/2-_inputField.width/2))
//      width:   mainLayout.desingnTouch*(_inputNumberPage.width/2-mainLayout.layoutTopMargin*2)+(!mainLayout.desingnTouch*_inputCallToAction480.width)
      width:  inputPanelDigits.width-inputPanelDigits.keySpacing*2
      horizontalAlignment: TextInput.AlignHCenter;
     inputMethodHints: Qt.ImhDigitsOnly
      validator: RegExpValidator { regExp: RegExp(mainLayout.inputNumberreg_exp) }
//      validator: RegExpValidator{regExp: /^[0-9,./]+$/ }

      focus:                     _inputNumberPage.visible
      cursorVisible:             activeFocus
      background: Rectangle {
                     implicitWidth: 10
                     implicitHeight: 10
                      color:           "#323232"
                      anchors.fill:    _inputField
         }
      onReadOnlyChanged:
      {
//         console.log("----------->>Edit Readonly: ", readOnly);
         if(readOnly)
         {
            _inputNumberPage.showKeyPanel=false
         }
      }
      onAccepted:
      { // console.log("----------->>Edit finished :", focusReason, "Text: ", _inputField.text, "inputMethodHints: ", _inputField.inputMethodHints );
                  qmlkeypressSignaltolib(_inputField.text, 25, 4); //HACK: die Funktion ruft Tasteneingabe auf, mit der 4 wird das Ereignis 25 draus-> Texteingabe
      }

   }

   Rectangle{      color: "transparent";  border.width: 2;  border.color: "gray";  anchors.fill:  _inputField }
   KeyPad{
      id: inputPanelDigits
      y: _inputNumberPage.height
      anchors.horizontalCenter:  _inputField.horizontalCenter;
      active: mainLayout.gKeyboard_enabled && mainLayout.desingnTouch  //&& _inputNumberPage.visible

      states: State {
            name: "visible"
//            when: mainLayout.inputNumberPage_visible //_inputNumberPage.showIt//inputPanelDigits.active
            when: _inputNumberPage.showKeyPanel
            PropertyChanges {  target: inputPanelDigits;  y: _inputField.y+_inputField.height+20}

        }

        transitions: Transition {
            from: ""
            to: "visible"
            reversible: true
            ParallelAnimation {
                NumberAnimation {
                    properties: "y"
                    duration: 300
                    easing.type: Easing.InOutQuad
                }
            }
        }
    }
//Debug Rectangle{      color: "transparent";  border.width: 2;  border.color: "yellow";  anchors.fill:  inputPanelDigits }
   signal clicked(string text, int iKey)

    onClicked:
    {
       if( _inputNumberPage.showKeyPanel)
       {
         if(iKey == Qt.Key_Backspace)
         {    var position = _inputField.cursorPosition
               _inputField.text = _inputField.text.substring(0, _inputField.cursorPosition - 1) +
                              _inputField.text.substring(_inputField.cursorPosition, _inputField.text.length)
               _inputField.cursorPosition = position - 1
         }
         else if( (iKey ==  Qt.Key_Enter) || (iKey == Qt.Key_Return) )
         { if(_inputField.text.length) // blocken, wenn nichts eingegeben
            _inputField.accepted()
         }
         else  if(iKey == Qt.Key_Clear) _inputField.text = ''
         else { // insert text
               var position = _inputField.cursorPosition
               _inputField.text = _inputField.text.substring(0, _inputField.cursorPosition) + text +
                              _inputField.text.substring(_inputField.cursorPosition, _inputField.text.length)
               _inputField.cursorPosition = position + 1
         }
       }
    }
*/

      PanelInputDigits{
         id: inputPanelDigits
         isNumberInput: true
         passwordMode: false

         anchors.right: _inputNumberPage.right
         anchors.rightMargin: mainLayout.layoutTopMargin*mainLayout.desingnTouch*!mainLayout.scaleEnabled + (!mainLayout.desingnTouch*(_inputNumberPage.width/2-width/2))
         anchors.verticalCenter : _inputNumberPage.verticalCenter
         anchors.verticalCenterOffset: 60*!mainLayout.desingnTouch // fuer classic, weiter oben


//         anchors.rightMargin: mainLayout.layoutTopMargin*mainLayout.desingnTouch*!mainLayout.scaleEnabled
              // anchors.rightMargin: mainLayout.layoutTopMargin*mainLayout.desingnTouch*!mainLayout.scaleEnabled
//               enableAnimation: false
//               mCTRL_home_IconSource: globalPathToImages+"control_transponder.svg"
//               mCTRL_home_enabled: true
         // anchors.verticalCenter : _inputNumberPage.verticalCenter
      }

}   // _inputNumberPage
