import cti_module 1.0

// https://doc.qt.io/qt-5/richtext-html-subset.html

TerminalPage {
   id:       _employeeMessagesPage;

   property alias employeeMessages_Message_text:        _employeeMessagesTxtMessage.text;
   property alias employeeMessages_StatusRight_text:    _employeeMessagesStatusMsgRight.text;
   property alias employeeMessages_MessageTime_text:    _employeeMessagesTxtMessageTime.text;

   StatusText {
      id:                        _employeeMessagesStatusMsgRight;
//      anchors.top:               parent.top
      anchors.top:               _employeeMessagesTxtMessageTime.bottom
//      anchors.topMargin:         mainLayout.statusMargin
      anchors.right:             parent.right;
      anchors.rightMargin:       mainLayout.statusMargin
      horizontalAlignment:       Text.AlignRight;
      // font.pixelSize:            20
      height: mainLayout.layoutCellHeightStatus+mainLayout.layoutScaleOffset
   }

   StatusText {
      id:                        _employeeMessagesTxtMessageTime;
      anchors.top:               _employeeMessagesPage.top
      anchors.topMargin:         10 //mainLayout.statusMargin
      anchors.right:             parent.right;
      anchors.rightMargin:       mainLayout.statusMargin
      horizontalAlignment:       Text.AlignRight;
      // font.pixelSize:            20
      height: mainLayout.layoutCellHeightStatus+mainLayout.layoutScaleOffset
   }

   Text {
      id:                        _employeeMessagesTxtMessage;
      y:                         mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
      anchors.horizontalCenter:  parent.horizontalCenter;
      textFormat:                Text.RichText;
      color:                     mainLayout.colorText;
      verticalAlignment:         Text.AlignTop;
      // font.pixelSize:            24;
      font.pixelSize:            mainLayout.fontPixelSizeMessage
      height:                    _employeeMessagesPage.height- mainLayout.layoutCellHeightLastRow*3-( mainLayout.layoutCellSpace*3);
      width:                     parent.width-120;
   }
// debug
   Rectangle{ border.width: 1; border.color: "yellow"; anchors.fill: _employeeMessagesTxtMessage; color: "transparent"; visible: mainLayout.g_enableDebug   }
   Rectangle{ border.width: 1; border.color: "red"; anchors.fill: _employeeMessagesTxtMessageTime; color: "transparent"; visible: mainLayout.g_enableDebug  }
   Rectangle{ border.width: 1; border.color: "green"; anchors.fill: _employeeMessagesStatusMsgRight; color: "transparent"; visible: mainLayout.g_enableDebug  }
      ControlButton {
         myButtonId:             "FKT_Key_Clear"
         iHWKey:                 1067
         text:                   mainLayout.textControlButton_Home
         width:                  140
         x:                      40
         anchors.bottom:         _employeeMessagesPage.bottom
         anchors.bottomMargin:   mainLayout.layoutCellHeightLastRow/2
         buttonTextColor:        mainLayout.controlButtonTextColor
         pixelSize:              mainLayout.fontPixelSizeKeyText
      }

     ControlButton{
         myButtonId:             "FKT_Key_Up"
         iHWKey:                 1072
         anchors.right:          _employeeMessagesPage.horizontalCenter
         anchors.rightMargin:  mainLayout.layoutTopMargin+6
         source:                 globalPathToImages+"control_hoch_48h.png"
         // border.width:           2
         anchors.bottom:         _employeeMessagesPage.bottom
         anchors.bottomMargin:   mainLayout.layoutCellHeightLastRow/2
   width: mainLayout.controlButtonWidth*2
   height: mainLayout.controlButtonHeight+4
   imageFillMode:             Image.Stretch

      }
      ControlButton{
         myButtonId:             "FKT_Key_Down"
         iHWKey:                 1082
         anchors.left:           _employeeMessagesPage.horizontalCenter//width/2+20
         anchors.leftMargin:  mainLayout.layoutTopMargin+6
         source:                 globalPathToImages+"control_runter_48h.png"
         // border.width:           2
         anchors.bottom:         _employeeMessagesPage.bottom
         anchors.bottomMargin:   mainLayout.layoutCellHeightLastRow/2
   width: mainLayout.controlButtonWidth*2
   height: mainLayout.controlButtonHeight+4
   imageFillMode:             Image.Stretch


      }

}   // employeeMessages
