import cti_module 1.0
import QtQuick.Controls 2.2
//import '../custom_xml';

TerminalPage {
   id:        _bookingPage;

   property alias    bookingButtonList:    _bookingButtonList;
   property alias    bookingTxtMessage:    _bookingTxtMessage.text;
   property alias    bookingCallToAction:  _bookingCallToAction.text;

   property alias    bookingModelSource:   _jsonDataModelBooking.source
   property alias    bookingModelData:     _jsonDataModelBooking.json
   property alias    bookingModelQuery:    _jsonDataModelBooking.query // aktuell unbenutzt, Filtern geht in C# besser

   property string   iselected;
   property bool     b_scrollUpEnabled: false
   property bool     b_scrollDownEnabled: false


   function resetListView()
   {
      // Reset Auswahl: kein Element gewaehlt, Ansicht auf Anfang
      _bookingButtonList.currentIndex = 1
      _bookingButtonList.positionViewAtIndex(0, GridView.Beginning)
   }

   onVisibleChanged:
   {
      resetListView()
   }

   TimeSmall{ // Uhr ohne Datum
      id: _time
      anchors.right:    _helpPageLeft.right
      anchors.topMargin: 0 + mainLayout.layoutScaleOffset
      anchors.rightMargin: 0
      visible: mainLayout.desingnTouch
   }

   DateSmall { // nur Datum
      id: _date
      anchors.left: _helpPageLeft.left
      anchors.topMargin: 0 + mainLayout.layoutScaleOffset
      anchors.leftMargin: 0
      visible: mainLayout.desingnTouch
   }
Rectangle{ color: "transparent" ;      border.width: 1;      border.color: "gray"; anchors.fill:_date ; visible: mainLayout.g_enableDebug   }
Rectangle{ color: "transparent" ;      border.width: 1;      border.color: "darkgray"; anchors.fill:_time ; visible: mainLayout.g_enableDebug   }

   Rectangle{
      id:         _helpPageLeft
      width:      mainLayout.widthCallToAction       //
      height:     _bookingPage.height-( 2*mainLayout.layoutTopMargin*mainLayout.desingnTouch)
      color:      "transparent"
      x:          mainLayout.layoutTopMargin*mainLayout.desingnTouch+( (mainLayout.width/2-mainLayout.widthCallToAction/2) *!mainLayout.desingnTouch)
      y:          mainLayout.layoutTopMargin*mainLayout.desingnTouch
      z:          20

      MessageArea {
         id:                     _bookingTxtMessage;
         y:                      mainLayout.layoutCellSpace*2*mainLayout.desingnTouch+mainLayout.layoutCellHeight*!mainLayout.desingnTouch - mainLayout.layoutCellSpace*mainLayout.scaleEnabled
         horizontalAlignment :   mainLayout.messageAreaTextAlign// Text.AlignLeft;
         anchors.horizontalCenter:  _helpPageLeft.horizontalCenter;
         width:                     _helpPageLeft.width

      }
      CallToActionArea {
         id: _bookingCallToAction;
//         width:               _helpPageLeft.width
         textAlignmentH:      mainLayout.callToActionTextAlign
         height:              mainLayout.heightCallToAction
         anchors.top: _bookingTxtMessage.bottom
         anchors.topMargin: mainLayout.callToActionTopMargin
      }

// //debug
      Rectangle{ border.width: 2; border.color: "yellow"; anchors.fill: _bookingTxtMessage; visible: mainLayout.g_enableDebug   }
      Rectangle{ border.width: 2; border.color: "red"; anchors.fill: _bookingCallToAction; visible: mainLayout.g_enableDebug   }

      ControlButton {
         myButtonId:       "FKT_Key_Clear"
         iHWKey:           1067
         text:             mainLayout.textControlButton_Home//"Home"
         width:            140
         anchors.bottom:   _helpPageLeft.bottom
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }
      ControlButton {
         myButtonId:       "FKT_Key_Info"
         iHWKey:           1073
         text:             mainLayout.textControlButton_Info//"Info"
         width:            140
         x:                150+20 //*mainLayout.scaleEnabled
         anchors.bottom:   _helpPageLeft.bottom
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }

   }
//   Rectangle{ color: "transparent" ;      border.width: 2;      border.color: "green"; anchors.fill:_helpPageLeft }

   JSONListModel {
      id:              _jsonDataModelBooking
      onDataChanged:
      {
         resetListView()
      }
   }
// debug
   Rectangle{ border.width: 2; border.color: "purple"; anchors.fill: _helpPageLeft; color: "transparent"; visible: mainLayout.g_enableDebug  }
   GridView {
      id:                        _bookingButtonList
      width:                    30*mainLayout.scaleEnabled + _bookingPage.width/2-mainLayout.layoutTopMargin-6;
      height:                   30*mainLayout.scaleEnabled + _bookingPage.height-2*mainLayout.layoutTopMargin
      anchors.top:               _bookingPage.top
      anchors.topMargin:         mainLayout.layoutTopMargin-15*mainLayout.scaleEnabled
      anchors.right:             _bookingPage.right
      anchors.rightMargin:       mainLayout.layoutTopMargin
      clip:                      true;
      snapMode:                  GridView.SnapToRow;
      currentIndex:              -1 // nichts ausgewält beim start
      cellWidth:                 (_bookingButtonList.width/mainLayout.bookingNumColumn)-mainLayout.bookCellSpacing/2
      cellHeight:                _bookingButtonList.height/3

      model:                     _jsonDataModelBooking.model

      delegate:   Item {
            x:          mainLayout.bookCellSpacing/2
            y:          mainLayout.bookCellSpacing/2
            width:      _bookingButtonList.cellWidth
            height:     _bookingButtonList.cellHeight
            BookingButtonTouch {
               text:                   model.ButtonText
               myButtonId:             model.ButtonID
               source:                 model.IconPath ? model.IconPath : ""
               isEnabled:              model.enable
               width:                  _bookingButtonList.cellWidth-mainLayout.bookCellSpacing
               height:                 _bookingButtonList.cellHeight-mainLayout.bookCellSpacing
               anchors.centerIn:  parent
               colorPreselect:          model.ColorPreselect ? model.ColorPreselect : ""
//fontPixelSizeTextDefault: mainLayout.fontPixelSizeDefault+20*mainLayout.scaleEnabled
            }
      }// ListEntry
      onMovementStarted:
      {  //console.log("--- start move --- ", _bookingButtonList.currentIndex)
         // TimeKeeper Key
         qmlkeypressSignaltolib("FKT_Key_Move_Start", 1084,1)
      }
      onMovementEnded:
      {  //console.log("--- end move --- ", _bookingButtonList.currentIndex)
         qmlkeypressSignaltolib("FKT_Key_Move_End", 1084,1)
      }

      ScrollIndicator.vertical: ScrollIndicator {
         id: _scrollBarGrid
         size: 0.2
         active: true;
         visible: (_bookingButtonList.count>6)

         contentItem: Rectangle {
            implicitWidth:  6
            implicitHeight: 100
            radius: width / 2
            color:  Qt.lighter(mainLayout.listButtonFillColor, 1.6)


         }
         background: Rectangle {
            id:      _ScrollBackRecGrid
            color:   mainLayout.listButtonFillColor
         }
      }
   } // GridView
// Rectangle{ color: "transparent" ;      border.width: 1;      border.color: "blue"; anchors.fill:_bookingButtonList }

/*
   ControlButton{
      id:            _KeyUpListView
      myButtonId:    "FKT_Key_Up"
      iHWKey:        1072
      source:        globalPathToImages+"control_hoch_48h.png"
      border.width:  0
      anchors.horizontalCenter:     _bookingButtonList.horizontalCenter
      anchors.top:                  _bookingPage.top
      visible:       b_scrollDownEnabled
      height:        32
      width:         32
   }

   ControlButton{
      id:            _KeyDownListView
      myButtonId:    "FKT_Key_Down"
      iHWKey:        1082
      source:        globalPathToImages+"control_runter_48h.png"
      border.width:  0
      anchors.horizontalCenter:     _bookingButtonList.horizontalCenter
      anchors.bottom:               _bookingPage.bottom
      visible:       b_scrollDownEnabled
      height:        32
      width:         32

   }
   */
}   // bookingPage
