import QtQuick 2.12
import QtQuick.Controls 2.12

Rectangle {
   id:   _touchButtonPad
   signal clicked(string text, int iKey)
   property bool bAnimation: true
   property bool isCtrlKey: false
   property string parentColor:  "#323232"
   property string defaultColor: "#323232"
   property string pressedColor:  Qt.lighter(defaultColor, 2.0)
   property alias source:        _icon.source
   property int     iHWKey:           1084
   property string  myButtonId:       "empty";
   property alias   label_id:         _label;
   property alias   text:             _label.text;
   property int     iImageWidth:       46+8*mainLayout.scaleEnabled //mainLayout.touchButtonImageSizeDefault   ? mainLayout.touchButtonImageSizeDefault	: mainLayout.bookingButtonImageWidth;
   property int     iImageHeight:      46+8*mainLayout.scaleEnabled //mainLayout.touchButtonImageSizeDefault  ? mainLayout.touchButtonImageSizeDefault  : mainLayout.bookingButtonImageHeight;
   property double  scaleFactor:        1.25
   color: _touchButtonPad.defaultColor
   radius: 5 //width/2
   width:   mainLayout.touchButtonImageSizeDefault + 16*mainLayout.scaleEnabled
   height:  mainLayout.touchButtonImageSizeDefault + 16*mainLayout.scaleEnabled
   onClicked:
   {
      if(isCtrlKey)
         receiveButtonfromlib(iHWKey, 1 )
      else
         parent.clicked(text,iKey)

   }

   Text
   {
      id: _label;
      anchors.centerIn:       _touchButtonPad
      font.pixelSize:             20 //24
      color:                      mainLayout.colorKeyPadText

   }
   Image
   {
      id: _icon;
      anchors.centerIn:             _touchButtonPad
      sourceSize.width:           _touchButtonPad.iImageWidth
      sourceSize.height:          _touchButtonPad.iImageHeight

   }

   state: "INACTIVE"

   states: [
       State {
           name: "ACTIVE"
               PropertyChanges { target: _touchButtonPad ; color: _touchButtonPad.pressedColor }

       },
       State {
           name: "INACTIVE"
               PropertyChanges { target: _touchButtonPad ; color: _touchButtonPad.defaultColor }
       }

   ]

   transitions: [

       Transition {
           to: "ACTIVE"
           ScaleAnimator { target: _touchButtonPad; from: 1; to: scaleFactor; duration: 10 }
       },
       Transition {
           to: "INACTIVE"
           ScaleAnimator { target: _touchButtonPad; from: scaleFactor; to: 1; duration: 10 }
       }
   ]

   //    debug    	 border.color: "yellow";      border.width: 1
//   border.color: Qt.lighter(defaultColor, 2.3)

   MouseArea {
      anchors.fill: _touchButtonPad
      onReleased:
      {
         if(parent.state == "ACTIVE")
            _touchButtonPad.clicked(_label.text, _touchButtonPad.iHWKey)
         if(bAnimation)
            parent.state = "INACTIVE"
      }

      onPressed:
      {
         if(bAnimation)
            parent.state = "ACTIVE"
      }

      onCanceled:
      {
         parent.state = "INACTIVE"
      }
   onPositionChanged:
   {  //NOTE: pruefen ob Bewegung den Touchbereich verlassen hat, falls ja ist status gedrueckt ungueltig
      if( ( (mouseX>parent.width) || (mouseX<0) || (mouseY>parent.height) || (mouseY<0)  ) )
      {
         onCanceled()
      }
   }
   } // MouseArea
}// _touchButtonPad
