import QtQuick 2.9

Item {
    id: itemGrid;

    implicitWidth: parent.width;
    implicitHeight: parent.height;
    anchors.fill: parent;
    anchors.topMargin: mainLayout.layoutTopMargin;
    anchors.leftMargin: mainLayout.layoutDiff;
    x: 20
    z: 500;
    visible: mainLayout.showHelpGrid;

    Grid {
        id: rowLayoutStatus

        //property int diffHeight: mainLayout.layoutCellHeight-mainLayout.layoutCellHeightStatus-mainLayout.layoutTopMargin;
        property int diffHeight: height - mainLayout.layoutCellSpace - mainLayout.layoutCellHeightStatus;
        property double opacityHelpGrid: 0.3;
//        property string colorHelpGrid: String("#f6edc0");
        property string colorHelpGrid: String("#FF5555");

        z: 500;
        height: mainLayout.layoutCellHeight + mainLayout.layoutCellSpace - mainLayout.layoutTopMargin;
        columns: 7;
        spacing: 0;
        visible: mainLayout.showHelpGrid;
        opacity: rowLayoutStatus.opacityHelpGrid;

        Rectangle { id: statusCell1; color: "#99FF0000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: mainLayout.layoutCellHeightStatus; }
        Rectangle { id: statusCell2; color: "#9900FF00"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: mainLayout.layoutCellHeightStatus; }
        Rectangle { id: statusCell3; color: "#AA0000FF"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 65 ; height: mainLayout.layoutCellHeightStatus; }
        Rectangle { id: statusCell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: mainLayout.layoutCellHeightStatus; }
        Rectangle { id: statusCell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 65 ; height: mainLayout.layoutCellHeightStatus; }
        Rectangle { id: statusCell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: mainLayout.layoutCellHeightStatus; }
        Rectangle { id: statusCell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: mainLayout.layoutCellHeightStatus; }

        Rectangle { id: status2Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: rowLayoutStatus.diffHeight; }
        Rectangle { id: status2Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: rowLayoutStatus.diffHeight; }
        Rectangle { id: status2Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 65 ; height: rowLayoutStatus.diffHeight; }
        Rectangle { id: status2Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: rowLayoutStatus.diffHeight; }
        Rectangle { id: status2Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 65 ; height: rowLayoutStatus.diffHeight; }
        Rectangle { id: status2Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: rowLayoutStatus.diffHeight; }
        Rectangle { id: status2Cell7; color: "#990000FF"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: 70 ; height: rowLayoutStatus.diffHeight; }
    }

    Grid {
        id: firstLayout
        height: 2*mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
        anchors.top: rowLayoutStatus.bottom; // helpLineHorizontalTop1.top;
        //anchors.topMargin: mainParent.cellSpace;
        columns: 9;
        spacing: mainLayout.layoutCellSpace;
        visible: mainLayout.showHelpGrid;
        opacity: rowLayoutStatus.opacityHelpGrid;
        z: 500;

        Rectangle { id: row1Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell8; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row1Cell9; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }

        Rectangle { id: row2Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell8; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row2Cell9; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
    }

    Grid {
        id: secondLayout
        height: 2*mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
        anchors.top: firstLayout.bottom; // helpLineHorizontalBottom1.top
        anchors.topMargin: mainLayout.layoutCellSpace;
        columns: 9;
        spacing: mainLayout.layoutCellSpace;
        visible: mainLayout.showHelpGrid;
        opacity: rowLayoutStatus.opacityHelpGrid;
        z: 500;

        Rectangle { id: row3Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell8; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row3Cell9; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }

        Rectangle { id: row4Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell8; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row4Cell9; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
    }

        Grid {
        id: thirdLayout
        height: mainLayout.layoutCellHeight + mainLayout.layoutCellHeightLastRow + mainLayout.layoutCellSpace;
        anchors.top: secondLayout.bottom; // helpLineHorizontalBottom1.top
        anchors.topMargin: mainLayout.layoutCellSpace;
        columns: 7;
        spacing: mainLayout.layoutCellSpace;
        visible: mainLayout.showHelpGrid;
        opacity: rowLayoutStatus.opacityHelpGrid;
        z: 500;

        Rectangle { id: row5Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row5Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row5Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row5Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row5Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row5Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }
        Rectangle { id: row5Cell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeight; }


        Rectangle { id: row6Cell1; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
        Rectangle { id: row6Cell2; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
        Rectangle { id: row6Cell3; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
        Rectangle { id: row6Cell4; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
        Rectangle { id: row6Cell5; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
        Rectangle { id: row6Cell6; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
        Rectangle { id: row6Cell7; color: "#00000000"; border.color: rowLayoutStatus.colorHelpGrid; border.width: 1; width: mainLayout.layoutCellWidth; height: mainLayout.layoutCellHeightLastRow; }
    }

	HelpLineVertical {
		id: helpLineVerticalCenter;
		anchors.horizontalCenter: parent.horizontalCenter;
		z: 999;
	}
	HelpLineVertical {
		id: helpLineVerticalLeft;
		anchors.rightMargin: 2*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace + ((mainLayout.layoutCellSpace + mainLayout.layoutCellWidth) / 2) - (helpLineVerticalCenter.border.width * 2);
		anchors.right: helpLineVerticalCenter.left;
		z: 999;
	}
	HelpLineVertical {
		id: helpLineVerticalRight;
		anchors.leftMargin: 2*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace + ((mainLayout.layoutCellSpace + mainLayout.layoutCellWidth) / 2) + (helpLineVerticalCenter.border.width / 2);
		anchors.left: helpLineVerticalCenter.right;
		z: 999;
	}
	HelpLineHorizontal {
		id: helpLineHorizontalStatus;
		anchors.topMargin: mainLayout.layoutCellHeightStatus + mainLayout.layoutTopMargin - 1;
		anchors.top: parent.top;
		z: 999;
	}
	HelpLineHorizontal {
		id: helpLineHorizontalTop1;
		anchors.topMargin: mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
		anchors.top: parent.top;
		z: 999;
	}
	HelpLineHorizontal {
		id: helpLineHorizontalTop2;
		anchors.top: helpLineHorizontalTop1.bottom;
		anchors.topMargin: mainLayout.layoutCellHeight + mainLayout.layoutCellSpace - helpLineHorizontalTop1.border.width;
		z: 999;
	}
	HelpLineHorizontal {
		id: helpLineHorizontalBottom1;
		anchors.top: helpLineHorizontalTop2.bottom
		anchors.topMargin: mainLayout.layoutCellHeight + mainLayout.layoutCellSpace - helpLineHorizontalTop2.border.width;
		z: 999;
	}
	HelpLineHorizontal {
		id: helpLineHorizontalBottom2;
		anchors.top: helpLineHorizontalBottom1.bottom
		anchors.topMargin: mainLayout.layoutCellHeight + mainLayout.layoutCellSpace - helpLineHorizontalBottom1.border.width;
		z: 999;
	}
}
