import QtQuick 2.9
Rectangle {
    id: itemMainDate;
    property string _DateFormat: String("dddd, dd.MM.yyyy");
    anchors.top: parent.top
    anchors.topMargin: mainLayout.layoutTopMargin
    anchors.leftMargin: mainLayout.statusMargin
    anchors.left: parent.left

    property string _textColor:        mainLayout.colorTextDateTime
    property int  currentPixelSize:    (mainLayout.fontPixelSizeSmallDate_Time  ? mainLayout.fontPixelSizeSmallDate_Time : mainLayout.fontPixelSizeDefault);
    property alias  clockDate_text:    txtClockDate.text;

    ClockFunctions {
        id: clockFunc1

        property string shortDateFormatDefault: String("dd.MM.yyyy");
//        property string longDateFormatDefault: String("dddd, dd.MM.yyyy");
      property string longDateFormatDefault: itemMainDate._DateFormat

        property string currentDateFormat:   mainLayout.smallDateFormat ? mainLayout.smallDateFormat : longDateFormatDefault;
        property var currentLocale:          mainLayout.myLocale       ? mainLayout.myLocale       : mainLayout.localeDefault;

        Timer {
            interval: 500; running: true; repeat: true; triggeredOnStart: true;
            onTriggered: clockFunc1.showDate(itemMainDate, clockFunc1.currentDateFormat, clockFunc1.currentLocale);
        }
    }

    height:    mainLayout.layoutCellHeightStatus;
    width:     3*mainLayout.layoutCellWidth + 3*mainLayout.layoutCellSpace;
    color:     "transparent"


    Text {
        id:                   txtClockDate;
        color:                _textColor
        verticalAlignment:    Text.AlignBottom;
        anchors.bottom:       parent.bottom;
        font.pixelSize:       itemMainDate.currentPixelSize;
        font.family:          mainLayout.fontFamilySemiBold;
        elide:                Text.ElideRight;
        wrapMode:             Text.Wrap;
        width:                3*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace;
    }
}
