import QtQuick 2.9

Rectangle {
    id: itemClock;
    property int	currentPixelSize:	    mainLayout.fontPixelSizeStatus ? mainLayout.fontPixelSizeStatus : 16;
    property alias  clockHours_text:	txtClockHours.text;
    property alias  clockMinutes_text:	txtClockMinutes.text;
    property alias  clockPoint_text:	txtClockPoint.text;
    property alias  clockDate_text:		txtClockDate.text;
    ClockFunctions {
        id: clockFunc

        property string shortDateFormatDefault: String("dd.MM.yyyy");

        property string currentDateFormat: mainLayout.shortDateFormat ? mainLayout.shortDateFormat : shortDateFormatDefault;
        property var	currentLocale:	   mainLayout.myLocale        ? mainLayout.myLocale        : mainLayout.localeDefault;

        Timer {
            interval: 500; running: true; repeat: true; triggeredOnStart: true;
            onTriggered: clockFunc.showTime(itemClock, clockFunc.currentDateFormat, clockFunc.currentLocale);
        }
    }

    z:			10;
    color:		"#00000000"; // transparent
    height:		mainLayout.layoutCellHeightStatus;
    width:		mainLayout.layoutCellWidth //+ 3*mainLayout.layoutCellSpace;

    Text {
        id:						txtClockHours
        color:					mainLayout.colorText
        text:					"00"
        anchors.bottom:			parent.bottom;
        anchors.right:			txtClockPoint.left
        verticalAlignment:		Text.AlignBottom
        font.family:			mainLayout.fontFamilyRegular;
        horizontalAlignment:	Text.AlignHCenter
        height:					parent.height;
        font.pixelSize:			itemClock.currentPixelSize;
    }

    Text {
        id:						txtClockPoint
        color:					mainLayout.colorText
        text:					":"
        anchors.right:			txtClockMinutes.left;
        anchors.bottom:			parent.bottom;
        verticalAlignment:		Text.AlignBottom
        font.family:			mainLayout.fontFamilyRegular;
        horizontalAlignment:	Text.AlignHCenter
        width:					8;
        height:					parent.height;
        font.pixelSize:			itemClock.currentPixelSize;
    }

    Text {
        id:						txtClockMinutes
        color:					mainLayout.colorText
        text:					"00"
        anchors.right:			parent.right
        anchors.bottom:			parent.bottom;
        verticalAlignment:		Text.AlignBottom
        font.family:			mainLayout.fontFamilyRegular;
        horizontalAlignment:	Text.AlignHCenter
        height:					parent.height;
        font.pixelSize:			itemClock.currentPixelSize;
    }

    Text {
        id:						txtClockDate
        color:					mainLayout.colorText
        text:					"01.01.0001"
        verticalAlignment:		Text.AlignBottom
        anchors.bottom:			parent.bottom;
        horizontalAlignment:	Text.AlignHCenter
        anchors.right:			txtClockHours.left;
        anchors.rightMargin:	15;
        font.pixelSize:			itemClock.currentPixelSize;
        font.family:			mainLayout.fontFamilyRegular;
        height:					parent.height;
    }
}
