import QtQuick 2.9

Rectangle {
    id: itemMainClock;

    property int	currentPixelSizeTime:	mainLayout.fontPixelSizeClockTime ? mainLayout.fontPixelSizeClockTime : 60;
    property int	currentPixelSizeDate:	mainLayout.fontPixelSizeClockDate ? mainLayout.fontPixelSizeClockDate : 16;

    property alias  clockHours_text:		txtClockHours.text;
    property alias  clockMinutes_text:		txtClockMinutes.text;
    property alias  clockPoint_text:		txtClockPoint.text;
    property alias  clockDate_text:			txtClockDate.text;
    property string clockFont:            mainLayout.fontFamilySemiBold;
    property string clockColor:           mainLayout.colorClockLarge;

     property int	widthDefault:    3*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace

    ClockFunctions {
         id: clockFunc

         property string shortDateFormatDefault: String("dd.MM.yyyy");
         property string longDateFormatDefault: String("dddd, dd.MM.yyyy");

         property string currentDateFormat: mainLayout.longDateFormat ? mainLayout.longDateFormat : longDateFormatDefault;
         property var	currentLocale:	   mainLayout.myLocale       ? mainLayout.myLocale       : mainLayout.localeDefault;

        Timer {
            interval: 500; running: true; repeat: true; triggeredOnStart: true;
            onTriggered: clockFunc.showTime(itemMainClock, clockFunc.currentDateFormat, clockFunc.currentLocale);
        }
    }

      height:     mainLayout.layoutCellHeight;
      width:      mainLayout.widthClockLargeDate? mainLayout.widthClockLargeDate  : itemMainClock.widthDefault;
      color:      "#00000000"; // transparent

    Text {
        id:						txtClockHours;
        color:					clockColor;
        text:					"00";
        anchors.top:			parent.top;
        anchors.right:			txtClockPoint.left;
        verticalAlignment:		Text.AlignVCenter;
        font.family:			clockFont//mainLayout.fontFamilySemiBold;
        horizontalAlignment:	Text.AlignHCenter;
        height:					mainLayout.layoutCellHeight;
        font.pixelSize:			itemMainClock.currentPixelSizeTime;
    }

    Text {
        id:						txtClockPoint;
        color:					clockColor
        text:					":";
        anchors.horizontalCenter: parent.horizontalCenter;
        anchors.top:			parent.top;
        verticalAlignment:		Text.AlignVCenter;
        font.family:			clockFont//mainLayout.fontFamilySemiBold;
        horizontalAlignment:	Text.AlignHCenter;
        width:					20;
        height:					mainLayout.layoutCellHeight;
        font.pixelSize:			itemMainClock.currentPixelSizeTime;
    }

    Text {
        id:						txtClockMinutes;
        color:					clockColor
        text:					"00";
        anchors.left:			txtClockPoint.right;
        anchors.top:			parent.top;
        verticalAlignment:		Text.AlignVCenter;
        font.family:			clockFont//mainLayout.fontFamilySemiBold;
        horizontalAlignment:	Text.AlignHCenter;
        height:					mainLayout.layoutCellHeight;
        font.pixelSize:			itemMainClock.currentPixelSizeTime;
    }

    Text {
        id:						txtClockDate;
        color:					clockColor
        text:					"Montag, 01.01.0001";
        verticalAlignment:		Text.AlignTop;
        anchors.top:			txtClockPoint.bottom;
        anchors.topMargin:		mainLayout.layoutCellSpace;
        horizontalAlignment:	Text.AlignHCenter;
        anchors.horizontalCenter: parent.horizontalCenter;
        font.pixelSize:			itemMainClock.currentPixelSizeDate;
        font.family:			mainLayout.fontFamilySemiBold;
        elide:					Text.ElideRight;
        wrapMode:				Text.Wrap;
        width:					itemMainClock.width // 3*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace;
        height:				mainLayout.layoutCellHeight;
    }
}
