import cti_module 1.0

Canvas {
    id: callToAction;

    property alias text:            label.text;
    property alias color:           label.color;
    property alias elide:           label.elide
    property alias wrapMode:        label.wrapMode
    property alias textAlignmentH:   label.horizontalAlignment
//    property int dotLineEnabled:    1
    property int dotLineEnabled: 0//!mainLayout.desingnTouch*1
    z:   2

    property int	heightDefault:     mainLayout.layoutCellHeight + 2*mainLayout.layoutCellSpace;
    property int	widthDefault:      3*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace;
    property string currentColorActive: (mainLayout.colorActive ? mainLayout.colorActive : "#2196f3");

    width:  mainLayout.widthCallToAction	? mainLayout.widthCallToAction  : callToAction.widthDefault;
    height: mainLayout.heightCallToAction   ? mainLayout.heightCallToAction : callToAction.heightDefault;

    y: 3*mainLayout.layoutCellHeight + 3*mainLayout.layoutCellSpace
    anchors.horizontalCenter: parent.horizontalCenter;

    onCurrentColorActiveChanged: callToAction.requestPaint()

    onPaint: {
                if(callToAction.dotLineEnabled)
                {
                    var context  = getContext("2d");

                    context.strokeStyle = currentColorActive;
                    context.setLineDash([10,6]);
//                    context.strokeRect(parent.x, parent.y, callToAction.width, callToAction.height);
                    context.strokeRect(0, 0, callToAction.width, callToAction.height);
                }
    }
    Text {
        id: label;
        property int fontPixelSizeDefault: 18;  //20
        font.pixelSize:   (mainLayout.fontPixelSizeCallToAction ? mainLayout.fontPixelSizeCallToAction : fontPixelSizeDefault);
        color:            currentColorActive;
        anchors.fill:     parent;
        width:            parent.width;
        height:           parent.height;
        wrapMode:         Text.Wrap;
    }
}
