import QtQuick 2.12
import cti_module 1.0

// Buttons, welche auf der Buchungseite zu sehen sind. Icon und Text uebereinander
Rectangle {
    id: button_tapp_area;

    property string myButtonId:  "empty";
	 property bool  isHighlight:  true;
    property alias text:         label.text;
    property alias source:       icon.source;
    property alias labelHeight:  label.height;
    property alias isEnabled:    button_tapp_area.visible
    property string colorPreselect: ""
    property int   hpos:         0;
    property int   hw_key: 1084

    x:               hpos*(mainLayout.width-mainLayout.layoutCellWidth*2*2);
    implicitWidth:   50
    implicitHeight:  50

    color:           mainLayout.listButtonFillColor;
    radius:          mainLayout.bottonFrameRadius;
    border.width:    mainLayout.bottonFrameWidth;
    border.color:    mainLayout.listButtonFillColor;

    state: "RELEASED"
    states: [
       State {
//           name: "SELECTED"
            name: "PRESSED"
                  PropertyChanges { target: button_tapp_area ;      border.color:    mainLayout.buttonSelectedColor }
       },
       State {
           name: "RELEASED"
               PropertyChanges { target: button_tapp_area ;
                     border.color: (colorPreselect) ? button_tapp_area.colorPreselect : mainLayout.listButtonFillColor  }
       }
      ]
// Note: wenn Darstellung vom html Code uebernommen wird, muss noch ein rechteck rein(icon kann dann raus), falls farbe des Eintrages angepasst wird
       Image
       {
          id: icon;
          fillMode:                Image.PreserveAspectFit;
//          sourceSize.width:			mainLayout.bookingButtonImageWidth   ? mainLayout.bookingButtonImageWidth	: mainLayout.imageWidthDefault;
          sourceSize.height:			mainLayout.bookingButtonImageHeight  ? mainLayout.bookingButtonImageHeight  : mainLayout.imageHeightDefault;
          anchors.horizontalCenter:	button_tapp_area.horizontalCenter
          anchors.bottom:				label.top;
         anchors.bottomMargin:		mainLayout.listTextIconSpace

       }
       Text
       {
          id: label;
          verticalAlignment:		Text.AlignTop;
          anchors.bottom:			button_tapp_area.bottom;
          anchors.bottomMargin:	 mainLayout.listTextIconSpace;
          anchors.horizontalCenter: icon.horizontalCenter;
          color:					mainLayout.listButtonTextColor
          width:					parent.width;
          height:					mainLayout.bookingButtonTouchTextHeigth
      }

    TapHandler
    {
         id: _tapHandler_
		 mKey: hw_key
		 bAnimation: isHighlight//true
 		 blockRepeat: true
    }

} //main rec tap handler

