﻿define(['bootstrap_datetimepicker'],
    function () {

    function _GetConfig() {
        var appTag = document.querySelector("script[data-main]");

        var globalConf = {};
        try {
            var jsonStr = appTag.innerHTML;
            globalConf = JSON.parse(jsonStr);
        }
        catch (e) {
            console.error(e);
        }

        return globalConf;
    }

    function _setConfig(_viewMode, _format, _startDate, _endDate) {
        if (_viewMode == null) {
            _viewMode = 'days';
        }
        if (_format == null) {
            _format = false;
        }
        if (_startDate == null) {
            _startDate = false;
        }
        if (_endDate == null) {
            _endDate = false;
        }

        var globalConf = _GetConfig();
        var datetimePickerCnf = globalConf.resx.datetimePicker;

        $('.datetimepicker').datetimepicker({
            locale:             'de',
            calendarWeeks:      true,
            keepOpen:           false,
            showTodayButton:    true,
            showClear:          true,
            showClose:          true,
            format:             _format,
            viewMode:           _viewMode,
            minDate:            _startDate,
            maxDate:            _endDate,
            //sideBySide:       true,
            tooltips: {
                today:          datetimePickerCnf.today,
                clear:          datetimePickerCnf.clear,
                close:          datetimePickerCnf.close,
                selectMonth:    datetimePickerCnf.selectMonth,
                prevMonth:      datetimePickerCnf.prevMonth,
                nextMonth:      datetimePickerCnf.nextMonth,
                selectYear:     datetimePickerCnf.selectYear,
                prevYear:       datetimePickerCnf.prevYear,
                nextYear:       datetimePickerCnf.nextYear,
                selectDecade:   datetimePickerCnf.selectDecade,
                prevDecade:     datetimePickerCnf.prevDecade,
                nextDecade:     datetimePickerCnf.nextDecade,
                prevCentury:    datetimePickerCnf.prevCentury,
                nextCentury:    datetimePickerCnf.nextCentury,
                selectTime:     datetimePickerCnf.selectTime,
                pickHour:       datetimePickerCnf.pickHour,
                pickMinute:     datetimePickerCnf.pickMinute,
                incrementHour:  datetimePickerCnf.incrementHour,
                decrementHour:  datetimePickerCnf.decrementHour,
                incrementMinute: datetimePickerCnf.incrementMinute,
                decrementMinute: datetimePickerCnf.decrementMinute
            }
        });
    }

    function _convertDateToddmmyyyy(date) {

        var year        = date.getFullYear().toString();
        var month       = ("0" + (date.getMonth() + 1).toString()).slice(-2);
        var day         = ("0" + date.getDate().toString()).slice(-2);
        var ddmmyyyy    = day + '.' + month + '.' + year;

        return ddmmyyyy;
    }

    function _convertDateTommyyyy(date) {

        var year    = date.getFullYear().toString();
        var month   = ("0" + (date.getMonth() + 1).toString()).slice(-2);
        var mmyyyy  = month + '.' + year;

        return mmyyyy;
    }

    function _convertDateToyyyy(date) {

        var year = date.getFullYear().toString();

        return year;
    }

    function _convertDateToIso(date) {

        var year        = date.getFullYear().toString();
        var month       = ("0" + (date.getMonth() + 1).toString()).slice(-2);
        var day         = ("0" + date.getDate().toString()).slice(-2);
        var isoDate     = year + '-' + month + '-' + day;

        return isoDate;
    }

    function _convertDatetimeToIso(datetime) {

        var year    = datetime.getFullYear().toString();
        var month   = ("0" + (datetime.getMonth() + 1).toString()).slice(-2);
        var day     = ("0" + datetime.getDate().toString()).slice(-2);
        var hour    = ("0" + (datetime.getHours()).toString()).slice(-2);
        var minute  = ("0" + (datetime.getMinutes()).toString()).slice(-2);
        var second  = ("0" + (datetime.getSeconds()).toString()).slice(-2);

        var isoDatetime = year + '-' + month + '-' + day + 'T' + hour + ":" + minute + ":" + second;

        return isoDatetime;
    }

    function _convertIsoToDateTime(sIsoDatetime) {
        if (sIsoDatetime == undefined || sIsoDatetime == '')
            return;

        var year    = sIsoDatetime.substr(0, 4);
        var month   = sIsoDatetime.substr(5, 2);
        var day     = sIsoDatetime.substr(8, 2);
        var hours   = sIsoDatetime.substr(11, 2);
        var minutes = sIsoDatetime.substr(14, 2);
        var seconds = sIsoDatetime.substr(17, 2);

        return new Date(year, month - 1, day, (hours == '') ? 0 : hours, (minutes == '') ? 0 : minutes, (seconds == '') ? 0 : seconds);
    }

    return {
        init: function (config) {
        },
        setConfig: function (viewMode, format, startDate, endDate) {
            _setConfig(viewMode, format, startDate, endDate);
        },
        convertDateToddmmyyyy: function (date) {
            return _convertDateToddmmyyyy(date);
        },
        convertDateTommyyyy: function (date) {
            return _convertDateTommyyyy(date);
        },
        convertDateToyyyy: function (date) {
            return _convertDateToyyyy(date);
        },
        convertDateToIso: function (date) {
            return _convertDateToIso(date);
        },
        convertDatetimeToIso: function (datetime) {
            return _convertDatetimeToIso(datetime);
        },
        convertIsoToDateTime: function (sIsoDatetime) {
            return _convertIsoToDateTime(sIsoDatetime);
        }
    };
});