﻿define([], function () {

    function checkKonvertierung() {

        var kodierungInput = $('#CheckKonvertierung_KodierungInput').val();
        var transponderTyp = $('#CheckKonvertierung_TransponderTyp').val();

        $.ajax({
            url: '/TransponderEinstellungen/CheckKonvertierung',
            type: 'POST',
            data: {
                transponderTyp: transponderTyp,
                kodierungInput: kodierungInput,
            },
            success: function (returnedData) {
                var output = returnedData.output;
                $('#CheckKonvertierung_KodierungOutput').val();
                $('#CheckKonvertierung_KodierungOutput').val(output);
            },
            error: function (xhr, status, error) {
                $('#CheckKonvertierung_KodierungOutput').val();
                $('#CheckKonvertierung_KodierungOutput').val(error);
            },
        });
    }

    function setFallbackCheckbox(index, isParentChecked) {
        if (index < 0)
            return;

        var fallbackCheckBoxSelector = '#ListTransponderEinstellungen_' + index + '__IsFallback';

        $(fallbackCheckBoxSelector).prop("disabled", !isParentChecked);

        if (!isParentChecked) {
            $(fallbackCheckBoxSelector).prop("checked", false);
        }
    }

    return {
        init: function () {

            $(".checkboxIsActive:checkbox").each(function (index) {
                setFallbackCheckbox(index, this.checked);
            });

            $('.checkboxIsActive').change(function () {
                var index = $('.checkboxIsActive').index(this);

                setFallbackCheckbox(index, this.checked);
            })

            $('#CheckKonvertierung').click(function () {
                checkKonvertierung();
            });

            $('.checkboxIsFallback').change(function () {
                if (this.checked) {
                    var changedId = this.id;

                    $(".checkboxIsFallback:checkbox:checked").each(function () {
                        if (this.id != changedId) {
                            $(this).prop("checked", false);
                        }
                    });
                }
            })
        }
    }
})