﻿define([], function () {
    "use strict";

    var controllerName = "Speedtest";
    function _StartTest(servicetoken) {
        if (!servicetoken) {
            return;
        }

        $("#alertError").addClass("hidden");
        $("#alertError").empty();

        var replacedServicetoken = _ReplaceForHtmlId(servicetoken);

        var idBtnStartTest      = "#btnStartTest_" + replacedServicetoken;
        var idBtnStopTest       = "#btnStopTest_" + replacedServicetoken;
        var idBtnIconTest       = "#btnIcon_" + replacedServicetoken;
        var idWaitTest          = "#waitTest_" + replacedServicetoken;

        try {
            $('.startSpeedTest').prop('disabled', true);
            //$('.stopSpeedTest').prop('disabled', true);

            $(idBtnStartTest).addClass('hidden');
            //$(idBtnIconTest).addClass('hidden');
            //$(idWaitTest).removeClass('hidden');

            $(idBtnStopTest).prop('disabled', false);
            $(idBtnStopTest).removeClass('hidden');

            $.ajax({
                url: controllerName + '/StartSpeedtestForServiceToken',
                type: 'POST',
                cache: false,
                data: { datahubServiceToken: servicetoken },  
                success: function (response) {
                    _GetResult(servicetoken);
                },
                error: function (xhr, status, error) {
                    console.log(error);

                    $("#alertError").html(error);
                    $("#alertError").removeClass("hidden");

                    $('.startSpeedTest').prop('disabled', false);
                    $(idWaitTest).addClass('hidden');
                    $(idBtnIconTest).removeClass('hidden');

                    $(idBtnStopTest).prop('disabled', true);
                    $(idBtnStopTest).addClass('hidden');
                    $(idBtnStartTest).removeClass('hidden');
                }
            });
        }
        catch (error) {
            console.error('Error:', error);

            $("#alertError").html(error);
            $("#alertError").removeClass("hidden");

            $('.startSpeedTest').prop('disabled', false);
            $(idWaitTest).addClass('hidden');
            $(idBtnIconTest).removeClass('hidden');

            $(idBtnStopTest).prop('disabled', true);
            $(idBtnStopTest).addClass('hidden');
            $(idBtnStartTest).removeClass('hidden');
        }
    }

    function _StopTest() {
        try {
            $.ajax({
                url: controllerName + '/StopSpeedtest',
                type: 'POST',
                cache: false,
                success: function (response) {
                    $('.stopSpeedTest').prop('disabled', true);
                },
                error: function (xhr, status, error) {
                    console.log(error);

                    $("#alertError").html(error);
                    $("#alertError").removeClass("hidden");
                }
            });
        }
        catch (error) {
            console.error('Error:', error);

            $("#alertError").html(error);
            $("#alertError").removeClass("hidden");
        }
    }

    function _GetResult(servicetoken) {

        var replacedServicetoken = _ReplaceForHtmlId(servicetoken);

        var idBtnIconTest = "#btnIcon_" + replacedServicetoken;
        var idWaitTest = "#waitTest_" + replacedServicetoken;
        var idBtnStartTest = "#btnStartTest_" + replacedServicetoken;
        var idBtnStopTest = "#btnStopTest_" + replacedServicetoken;

        $('.startSpeedTest').prop('disabled', true);

        $.ajax({
            url: controllerName + '/GetResult',
            type: 'GET',
            cache: false,
            dataType: "json",
            success: function (speedtestResult) {
                if (speedtestResult) {
                    if (speedtestResult.message) {
                        $("#alertError").html(speedtestResult.message);
                        $("#alertError").removeClass("hidden");
                    }
                    else {
                        $("#alertError").addClass("hidden");
                        $("#alertError").empty();
                    }

                    if (speedtestResult.speedtestResults) {
                        speedtestResult.speedtestResults.forEach(function (item) {
                                                                        _displayServiceResult(item, speedtestResult.isCancellationRequested);
                                                                });
                    }

                    if (speedtestResult.isCompleted !== true) {
                        setTimeout(function () { _GetResult(servicetoken); }, 2000);

                        return;
                    }

                    $('.startSpeedTest').prop('disabled', false);
                    $(idWaitTest).addClass('hidden');
                    $(idBtnIconTest).removeClass('hidden');

                    $(idBtnStopTest).prop('disabled', true);
                    $(idBtnStopTest).addClass('hidden');
                    $(idBtnStartTest).removeClass('hidden');
                }
                else {
                    setTimeout(function () { _GetResult(servicetoken); }, 5000);
                }
            },
            error: function (jqXHR, textStatus, error) {
                if (jqXHR && jqXHR.responseJSON) {
                    if (jqXHR.responseJSON.message) {
                        $("#alertError").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $('#alertError').html("error occured");
                    }
                }
                else {
                    $("#alertError").html(error);
                }

                $("#alertError").removeClass("hidden");
                $('.startSpeedTest').prop('disabled', false);
                $(idWaitTest).addClass('hidden');
                $(idBtnIconTest).removeClass('hidden');

                $(idBtnStopTest).prop('disabled', true);
                $(idBtnStopTest).addClass('hidden');
                $(idBtnStartTest).removeClass('hidden');
            },
            complete: function (jqXHR, textStatus) {

            }
        });
    }

    function _displayServiceResult(speedtestServiceSummaryResultViewModel, isCancellationRequested) {
        _displayUploadResult(speedtestServiceSummaryResultViewModel.speedtestUploadResult, speedtestServiceSummaryResultViewModel.serviceToken, isCancellationRequested);
        _displayDownloadResult(speedtestServiceSummaryResultViewModel.speedtestDownloadResult, speedtestServiceSummaryResultViewModel.serviceToken, isCancellationRequested);
    }

    function _displayUploadResult(uploadResultModel, serviceToken, isCancellationRequested) {

        serviceToken = serviceToken.replaceAll(".", "_");
        var idSize = "#size_" + serviceToken;
        var idUploadResult = "#uploadResult_" + serviceToken;

        if (isCancellationRequested === true) {
            if ($(idUploadResult).text() == "") {
                $(idUploadResult).text("cancel ...");
            }
        }

        if (!uploadResultModel) {
            return;
        }

        if (uploadResultModel.sizeBytes) {
            $(idSize).text(uploadResultModel.sizeBytes / 1024 / 1024);
        }

        $(idUploadResult).text(uploadResultModel.resultDisplayMessage);
    }

    function _displayDownloadResult(downloadResultModel, serviceToken, isCancellationRequested) {

        serviceToken = serviceToken.replaceAll(".", "_");
        var idDownloadResult = "#downloadResult_" + serviceToken;

        if (isCancellationRequested === true) {
            if ($(idDownloadResult).text() == "") {
                $(idDownloadResult).text("cancel ...");
            }
        }

        if (!downloadResultModel) {
            return;
        }

        $(idDownloadResult).text(downloadResultModel.resultDisplayMessage);
    }

    function _ReplaceForHtmlId(servicetoken) {
        var replacedServicetoken = servicetoken.replaceAll(".", "_");

        return replacedServicetoken;
    }

    return {
        init: function () {
            $('.startSpeedTest').on('click', function (event) {
                _StartTest($(this).data("servicetoken"));
            });
            $('.stopSpeedTest').on('click', function (event) {
                _StopTest();
            });
        }
    };
});
