﻿define([], function () {

    var controllerName = "NetzwerkMonitor";

    function _EnableBtnSubmitPing() {
        var pinghost = $('#InputPingHost').val();

        if (pinghost.length > 0) {
            $('#btnSubmitPing').removeAttr('disabled');
        }
        else {
            $('#btnSubmitPing').attr('disabled', 'disabled');
        }
    }

    function _RunPing() {

        $('#btnSubmitPing').attr('disabled', 'disabled');
        $('#ajaxLoaderGif').removeClass('hidden');

        $('#resultResolve').addClass('hidden');
        $('#resultPing').addClass('hidden');
        $('#resultMessage').addClass('hidden');

        $('#resultMessage').html();
        $('#resultResolveText').html();
        $('#resultPingText').html();

        $('#resultResolve').removeClass('alert-danger');
        $('#resultResolve').removeClass('alert-success');
        $('#resultPing').removeClass('alert-danger');
        $('#resultPing').removeClass('alert-success');
        $('#resultMessage').removeClass('alert-danger');
        $('#resultMessage').removeClass('alert-success');

        var pingHost = $('#InputPingHost').val();

        $.ajax({
            url:        controllerName + '/Ping',
            type:       'POST',
            datatype:   'json',
            data:       { hostName: pingHost },

            success: function (returnedData) {
                var successDnsResolve = returnedData.successDnsResolve;
                var successPing = returnedData.successPing;
                var message = returnedData.message;
               
                if (successDnsResolve == true) {
                    $('#resultResolve').addClass('alert-success');
                    $('#resultResolveText').html('Ok');
                }
                else {
                    $('#resultResolve').addClass('alert-danger');
                    $('#resultResolveText').html('Error');
                }
               
                if (successPing == true) {
                    $('#resultPing').addClass('alert-success');
                    $('#resultPingText').html('Ok');
                }
                else {
                    $('#resultPing').addClass('alert-danger');
                    $('#resultPingText').html('Error');
                }

                if (message.length > 0) {
                    $('#resultMessage').html(message);
                    $('#resultMessage').removeClass('hidden');
                    $('#resultMessage').addClass('alert-danger');
                }
            },
            error: function (xhr, status, error) {
                $('#resultMessage').html(error);
                $('#resultMessage').removeClass('hidden');
            },
            complete: function () {
                $('#resultResolve').removeClass('hidden');
                $('#resultPing').removeClass('hidden');  
                $('#ajaxLoaderGif').addClass('hidden');

                _EnableBtnSubmitPing();
            }
        });
    }
    return {
        init: function () {
            $('#InputPingHost').on("input",
                function () {
                    _EnableBtnSubmitPing();
                });

            $('#btnSubmitPing').on("click",
                function () {
                    _RunPing();
                });

            _EnableBtnSubmitPing();
        }
    };

});