﻿define([], function () {

    var controllerName = "NetzwerkEinstellung";

    function enableDisableInputs() {

        var checkedRadioValue_Lan = $('input:radio[id = "DHCPisTrue"]:checked').val();
        if (checkedRadioValue_Lan) {
            $('.display-ip-manual').prop('disabled', true);
        }
        else {
            $('.display-ip-manual').prop('disabled', false);
        }
    }

    function onChangeUseDefaultMtu() {

        var checkedUseDefault = $('input:checkbox[id = "UseDefaultMtuSize"]:checked').val();
        if (checkedUseDefault) {
            $('#MtuSize').attr('disabled', 'disabled');
            $('#MtuSize').attr('readonly', 'readonly');
        }
        else {
            $('#MtuSize').removeAttr('disabled');
            $('#MtuSize').removeAttr('readonly');
        }
    }

    function openModal() {

        $("#btn-reload").prop('disabled', true)
        $("#computeDialog").modal("show");

        _ScanWirelessLan()
    }

    function closeModal() {
        $("#computeDialog").modal('hide');
        $("#btn-reload").prop('disabled', false);
    }

    function _ScanWirelessLan() {

        $("#wlanSsids").empty();
        $("#waitScanWlan").removeClass("hidden");
        $("#dialogNoWlan").addClass("hidden")
        $("#dialogErrorWlan").addClass("hidden");
        $("#dialogErrorWlan").empty();

        var selectedAuthenticationMode = $("#WpaSupplicantViewModel_AuthenticationMode").find('option:selected').val();

        $.ajax({
            url: "/" + controllerName + '/ScanWirelessLan',
            dataType: "json",
            type: 'GET',
            data: {
                "selectedAuthenticationMode": selectedAuthenticationMode,
            },
            cache: false,
            success: function (data) {
                if ($.trim(data)) { 
                    for (var i = 0; i < data.length; i++)
                    {
                        _ShowSsid(data[i]);
                    }
                }
                else {
                    $("#dialogNoWlan").removeClass("hidden")
                }
            },
            error: function (error) {
                $("#dialogErrorWlan").removeClass("hidden");
                if (error != null) {
                    $("#dialogErrorWlan").html(error.responseText);
                }
                else {
                    $("#dialogErrorWlan").html("Error");
                }
            },
            complete: function () {
                $("#waitScanWlan").addClass("hidden");
            }
        });
    }

    function _ShowSsid(item) {
        var itemId = "Ssid_" + item.replace(/[^a-zA-Z0-9_]|\W+|\s+/gi, '').trim();
        if (itemId.length <= 0) {
            return;
        }

        $("#wlanSsids").append('<li class="list-group-item ssid-item" id="' + itemId + '">' + item + '</li>');
        $("#" + itemId).click(function () {
            var selectedText = $(this).text();
            $("#WpaSupplicantViewModel_Ssid").val(selectedText);
            $("#btn-closeModal").trigger("click");
        });
    }

    function _ignoreKeyEnter(event) {

        var keyPressed = event.keyCode;
        if (keyPressed === 13) {
            event.preventDefault();
            return false;
        } 
    }

    return {
        init: function () {

            $('input:radio[name = "IsDhcp"]').change(enableDisableInputs);

            $("#btn-openModal").click(function () {
                openModal();
            });

            $("#btn-closeModal").click(function () {
                closeModal();
            });

            $("#formNetwork").on("keydown", function (event) {
                _ignoreKeyEnter(event);
            });

            $(".toggle-password").click(function () {
                $(this).toggleClass("glyphicon-eye-open glyphicon-eye-close");
                var input = $($(this).attr("toggle"));
                if (input.attr("type") == "password") {
                    input.attr("type", "text");
                } else {
                    input.attr("type", "password");
                }
            });

            $('#UseDefaultMtuSize').on("change", onChangeUseDefaultMtu);

            enableDisableInputs();
            onChangeUseDefaultMtu();
        }
    }
})