﻿define([], function () {

    var controllerName = "ErrorReporting";

    function openModal() {

        $("#computeDialog").modal("show");

        _CreateAndSend()
    }

    function closeModal() {
        $("#computeDialog").modal('hide');
        $('#btn-openModal').removeAttr('disabled');
    }

    function _GetResult() {
        $.ajax({
            url: controllerName + '/GetResult',
            type: 'GET',
            cache: false,
            dataType: "json",
            success: function (errorReportingResult) {

                var timeoutResultId;

                if (errorReportingResult) {
                    if (errorReportingResult.isCompleted !== true) {
                        timeoutResultId = setTimeout(function () { _GetResult(); }, 2000);

                        return;
                    }

                    clearTimeout(timeoutResultId);

                    if (errorReportingResult.errorMessage) {
                        $("#dialogResultWarningMessage").html(errorReportingResult.errorMessage);
                        $("#dialogResultWarningMessage").removeClass("hidden");
                    }

                    if (errorReportingResult.isSucceedSendMail === true) {
                        $("#dialogResultSuccess").removeClass("hidden");
                        $("#formSystemreport").trigger("reset");
                    }
                    else {
                        if (errorReportingResult.filePathBase64) {
                            $("#dialogResultWarningDownload").attr("href", controllerName + "/DownloadFile?filePathBase64=" + errorReportingResult.filePathBase64);
                        }

                        $("#dialogResultWarning").removeClass("hidden");
                    }

                    $('#dialogAjaxLoaderIcon').addClass("hidden");
                    $("#dialogInProgressMessage").addClass("hidden");
                    $('#btn-openModal').removeAttr('disabled');

                    closeModal();
                }
                else {
                    timeoutResultId = setTimeout(function () { _GetResult(); }, 5000);
                }
            },
            error: function (jqXHR, textStatus, error) {
                if (jqXHR) {
                    if (jqXHR.responseJSON.message) {
                        $("#dialogResultException").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $("#dialogResultException").html("error occured");
                    }
                }
                else {
                    $("#dialogResultException").html(error);
                }

                $("#dialogResultException").removeClass("hidden");
            }
        });
    }

    function _CreateAndSend() {

        $("#dialogResultSuccess").addClass("hidden");
        $("#dialogResultException").addClass("hidden");
        $("#dialogResultException").html();

        $("#dialogResultWarning").addClass("hidden");
        $("#dialogResultWarningMessage").addClass("hidden");
        $("#dialogResultWarningMessage").html();
        $("#dialogResultWarningDownload").removeAttr("href");

        $('#btn-openModal').attr('disabled', 'disabled');
        $('#dialogAjaxLoaderIcon').removeClass("hidden");
        $("#dialogInProgressMessage").removeClass("hidden");

        $.ajax({
            url: controllerName + '/CreateAndSend',
            type: 'POST',
            data: {
                'Name': $('#Name').val(),
                'Email': $('#Email').val(),
                'Bemerkung': $('#Bemerkung').val(),
            },
            dataType: "json",
            traditional: true,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            beforeSend: function (xhr) {
                xhr.setRequestHeader("RequestVerificationToken", $('input:hidden[name="__RequestVerificationToken"]').val());
            },
            success: function () {
                setTimeout(function () { _GetResult(); }, 2000);
            },
            error: function (jqXHR, textStatus, error) {
                if (jqXHR) {
                    if (jqXHR.responseJSON.message) {
                        $("#dialogResultException").html(jqXHR.responseJSON.message);
                        console.log(jqXHR.responseJSON.message);
                    }
                    else {
                        $("#dialogResultException").html("error occured");
                    }
                }
                else {
                    $("#dialogResultException").html(error);
                }

                $("#dialogResultException").removeClass("hidden");
            }
        });
    }

    return {
        init: function () {
            $("#formSystemreport").submit(function (e) {
                if ($(this).find('.input-validation-error').length != 0) {
                    return false;   
                }

                openModal();

                return false; //submit abbrechen. nicht vom controller verarbeitet
            });

            $("#btn-closeModal").on('click', function () {
                closeModal();
            });
        }
    }
})