﻿define(['Moduls/dataService', 'Moduls/data-tables', 'Moduls/bootstrapDatetimePicker'],
    function (dataService, dataTable, bootstrapDatetimePicker) {

    var _controllerName = 'EreignisLog';

    function _RestoreRefreshButton() {
        $("#refreshEreignisseWait").addClass('hidden');
        $("#refreshEreignisseText").removeClass('hidden');
    }

    function _RestoreDeleteButton() {
        $("#deleteAllEreignisseWait").addClass('hidden');
        $("#deleteAllEreignisseText").removeClass('hidden');
        $("#btnDeleteAllEreignisse").prop('disabled', false);
    }

    function _GetDateTimePickerValueAsIsoDate(elementSelector) {
        var datetimepickerDate      = $(elementSelector).data('DateTimePicker').date().toDate();     // DatetimePicker liefert momentJS-Object. In Date-Object konvertieren
        var selectedZeitraumValue   = bootstrapDatetimePicker.convertDatetimeToIso(datetimepickerDate);

        return selectedZeitraumValue;
    }

    function _GetActiveTabRootElement() {
        return activeTabRootIndexGridElement = $('.tab-pane.active');
    }

    function _GetDataTableElement(activeTabRootIndexGridElement) {
        var activeTabIndexGridElement       = activeTabRootIndexGridElement.children().first();

        return activeTabIndexGridElement.children('.data-table');
    }

    function _RefreshEreignisLimitWarning() {
        $('#ereignisLimitMsg').addClass('hidden');

        var activeTabRootIndexGridElement   = _GetActiveTabRootElement();
        var table                           = _GetDataTableElement(activeTabRootIndexGridElement).DataTable();   //$('#indexGridTuercontrollerTable').DataTable();

        if (table) {
            if (table.rows().count() >= $('#EreignisLimit').val()) {
                $('#ereignisLimitMsg').removeClass('hidden');
            }
        }
    }

    function _RefreshIndexGrid() {
        var dateTimeVonAsIsoString = _GetDateTimePickerValueAsIsoDate('#idDatetimePickerVon');
        var dateTimeBisAsIsoString = _GetDateTimePickerValueAsIsoDate('#idDatetimePickerBis');

        if (dateTimeVonAsIsoString === null)
            return;
        if (dateTimeBisAsIsoString === null)
            return;

        $('#statusMsg').empty();
        $('#ereignisLimitMsg').addClass('hidden');

        var activeTabRootIndexGridElement = _GetActiveTabRootElement();  
        var activeTabIndexGridElement = activeTabRootIndexGridElement.children().first();

        if (!activeTabRootIndexGridElement) {
            throw "No active tab found";
        }

        if (activeTabIndexGridElement.length) {
            var table = activeTabIndexGridElement.children('.data-table').DataTable();
            table.clear();
            activeTabIndexGridElement.children().empty();

            $("#refreshEreignisseWait").removeClass('hidden');
            $("#refreshEreignisseText").addClass('hidden');

            var deviceBaseType = activeTabRootIndexGridElement.data('devicebasetype');
            var tuercontrollerProfilId = $('#SelectedProfilTuerControllerId').val();

            dataService.getEreignisLogIndexGridPartial
                (_controllerName, deviceBaseType, dateTimeVonAsIsoString, dateTimeBisAsIsoString, tuercontrollerProfilId, function (err, html) {
                    if (err) {
                        $('#statusMsg').text(err);
                        _RestoreRefreshButton();
                        throw err;
                    }

                    var activeTabIndexGridId = activeTabIndexGridElement.attr('id');
                    activeTabRootIndexGridElement.children(activeTabIndexGridId).remove();
                    activeTabRootIndexGridElement.html(html);

                    dataTable.InitDataTable(activeTabRootIndexGridElement.find('.data-table'));

                    _RestoreRefreshButton();

                    _RefreshEreignisLimitWarning();
                });
        }
    }

    function _DeleteAllEreignisse() {

        $("#btnDeleteAllEreignisse").prop('disabled', true);
        $("#deleteAllEreignisseWait").removeClass('hidden');
        $("#deleteAllEreignisseText").addClass('hidden');

        $('#statusMsg').empty();
        $('#ereignisLimitMsg').addClass('hidden');

        var activeTabRootIndexGridElement = _GetActiveTabRootElement();
        var deviceBaseType = activeTabRootIndexGridElement.data('devicebasetype');

        dataService.deleteAllEreignisLog
            (_controllerName, deviceBaseType, function (err, html) {

                _RestoreDeleteButton();

                _RefreshIndexGrid();

                if (err) {
                    $('#statusMsg').text(err);
                    throw err;
                }
            });
    }

    return {
        init: function (config) {

            bootstrapDatetimePicker.setConfig(null, 'DD.MM.Y HH:mm', null, null);

            _RefreshEreignisLimitWarning();

            $(".btn-deleteOk").click(function () {
                $("#myDeleteOkModal").modal("hide");
                _DeleteAllEreignisse();
            });

            $('#btnDeleteAllEreignisse').click(function () {
                $("#myDeleteOkModal").modal("show");
            });

            $('#btnRefreshEreignis').click(function () {
                _RefreshIndexGrid();
            });
        }
    };

});