﻿define([], function () {
    "use strict";

    var controllerName = "FirmwareUpdate";

    function _getCookie(name) {
        var value = "; " + document.cookie;
        var parts = value.split("; " + name + "=");

        if (parts.length === 2)
            return parts.pop().split(";").shift();
    }

    function _ResetUIUpload() {
        $('#fileSelector').prop('disabled', false);

        _SetUIUploadButton(false);
    }

    function _ResetUIDownload() {
        $("#ServerFirmwareVersion").val("");

        _SetUIDownloadButton(false);
    }

    function _ResetUIStatus() {

        $('#statusWaitIcon').addClass('hidden');

        $('#panelStatus').addClass('hidden');

        $('#alertStatusResultSuccess').addClass('hidden');
        $('#alertStatusResultSuccess').html("")

        $('#alertStatusResultError').addClass('hidden');
        $('#alertStatusResultError').html("")

        $('#alertStatusInProgress').addClass('hidden');
        $('#alertStatusInProgress').html("")
    }

    function _SetUIDownloadButton(isEnabled) {
        if (isEnabled) {
            $("#btnDownload").prop("disabled", false);
            $("#btnDownload").prop("readonly", false);
            $("#btnDownload").removeClass('disabled');
        }
        else {
            $("#btnDownload").prop("disabled", true);
            $("#btnDownload").prop("readonly", true);
            $("#btnDownload").addClass('disabled');
        }
    }

    function _SetUIUploadButton(isEnabled) {
        if (isEnabled) {
            $("#btnUpload").prop("disabled", false);
            $("#btnUpload").prop("readonly", false);
            $("#btnUpload").removeClass('disabled');
        }
        else {
            $("#btnUpload").prop("disabled", true);
            $("#btnUpload").prop("readonly", true);
            $("#btnUpload").addClass('disabled');
        }
    }

    function _SetUIStatusError(isEnabled, errorMessage) {
        if (isEnabled) {
            $('#alertStatusResultError').html(errorMessage)
            $('#alertStatusResultError').removeClass('hidden');
            $('#statusWaitIcon').addClass('hidden');
            $('#panelStatus').removeClass('hidden');

            $('#alertStatusInProgress').addClass('hidden');
            $('#alertStatusResultSuccess').addClass('hidden');
        }
        else {
            $('#alertStatusResultError').addClass('hidden');
            $('#alertStatusResultError').html("")
        }
    }

    function _SetUIStatusSuccess(isEnabled, message) {
        if (isEnabled) {
            $('#alertStatusResultSuccess').html(message)
            $('#alertStatusResultSuccess').removeClass('hidden');
            $('#statusWaitIcon').addClass('hidden');
            $('#panelStatus').removeClass('hidden');

            $('#alertStatusInProgress').addClass('hidden');
            $('#alertStatusResultError').addClass('hidden');
        }
        else {
            $('#alertStatusResultSuccess').addClass('hidden');
            $('#alertStatusResultSuccess').html("")
        }
    }

    function _SetUIStatusInProgrss(isInProgress, message) {
        if (isInProgress) {
            $('#alertStatusInProgress').html(message)
            $('#alertStatusInProgress').removeClass('hidden');
            $('#statusWaitIcon').removeClass('hidden');
            $('#panelStatus').removeClass('hidden');

            $('#alertStatusResultSuccess').addClass('hidden');
            $('#alertStatusResultError').addClass('hidden');
        }
        else {
            $('#alertStatusInProgress').addClass('hidden');
            $('#alertStatusInProgress').html("")
            $('#statusWaitIcon').addClass('hidden');
        }
    }

    async function _SubmitUpload(oFormElement) {

        _ResetUIStatus()
        _ResetUIDownload();
        _ResetUIUpload();

        try {
            const formData = new FormData(oFormElement);

            if ($('#fileSelector').get(0).files.length === 0) {
                console.log("no files selected");
                return;
            }

            _SetUIUploadButton(false);
            _SetUIStatusInProgrss(true, "Upload ...");

            const response = await fetch(oFormElement.action, {
                method: 'POST',
                headers: { 'RequestVerificationToken': _getCookie('RequestVerificationToken') },
                body: formData
            });

            if (response.status === 200) {
                response.json().then(
                    function (value) {
                        $('#fileSelector').val('');
                        _SetUIStatusSuccess(true, value.message);

                        _GetResult();
                    })
                    .catch(err => {
                        console.log(err);
                    });
            }
            else {
                response.json().then(
                    function (value) {
                        _SetUIStatusError(true, value.message);
                    })
                    .catch(err => {
                        console.log(err);
                    });
            }
        }
        catch (error) {
            console.error('Error:', error);

            _SetUIStatusError(true, error);
        }
    }

    function _GetResult() {

        _ResetUIDownload();
        _ResetUIUpload();

        $('#statusWaitIcon').removeClass('hidden');

        $.ajax({
            url: controllerName + '/GetUploadResult',
            type: 'GET',
            cache: false,
            dataType: "json",
            success: function (firmwareUpdateResult) {
                if (firmwareUpdateResult) {
                    if (firmwareUpdateResult.message) {
                        _SetUIStatusInProgrss(true, firmwareUpdateResult.message)
                    }

                    if (firmwareUpdateResult.isCompleted !== true) {
                        setTimeout(function () { _GetResult(); }, 5000);

                        return;
                    }

                    if (firmwareUpdateResult.isSucceeded === true) {
                        if (firmwareUpdateResult.message) {
                            _SetUIStatusSuccess(true, firmwareUpdateResult.message)
                        }
                        else {
                            _SetUIStatusSuccess(true, "success")
                        }

                        _PostPrepareCompleted(firmwareUpdateResult);    //Redirect
                    }
                    else {
                        var errMessage = "error";
                        if (firmwareUpdateResult.message) {
                            errMessage = firmwareUpdateResult.message;
                        }

                        _SetUIStatusError(true, errMessage)
                    }
                }
                else {
                    setTimeout(function () { _GetResult(); }, 5000);
                }
            },
            error: function (jqXHR, textStatus, error) {
                var errMessage = "error occured";

                if (jqXHR && jqXHR.responseJSON) {
                    if (jqXHR.responseJSON.message) {
                        errMessage = jqXHR.responseJSON.message;
                    }
                }
                else if(error) {
                    errMessage = error;
                }

                _SetUIStatusError(true, errMessage)

                console.log(errMessage);
            }
        });
    }

    function _PostPrepareCompleted(firmwareUpdateResult) {

        _ResetUIDownload();
        _ResetUIUpload();

        $.ajax({
            url: controllerName + '/RedirectStartUpdate',
            type: 'POST',
            headers: { 'RequestVerificationToken': _getCookie('RequestVerificationToken') },
            cache: false,
            dataType: "json",
            data: firmwareUpdateResult,
            success: function (redirectUrl) {
                window.location.replace(redirectUrl);    //Redirect
            },
            error: function (jqXHR, textStatus, error) {

                var errMessage = "error occured"

                if (jqXHR && jqXHR.responseJSON) {
                    if (jqXHR.responseJSON.message) {
                        errMessage = jqXHR.responseJSON.message;
                    }
                }
                else {
                    errMessage = error;
                }

                _SetUIStatusError(true, errMessage);
                console.log(error);
            }
        });
    }

    function _CheckForUpdate() {

        _ResetUIStatus();
        _ResetUIDownload();
        _ResetUIUpload();

        try {
            _SetUIStatusInProgrss(true, "Suche Version auf Server ...");

            var feed = $('#selectFirmwareUpdateFeed').val();

            $.ajax({
                url: controllerName + '/CheckForUpdate',
                type: 'GET',
                cache: false,
                data: { selectedFeed: feed },
                success: function (checkUpdateModelResponse) {

                    if (checkUpdateModelResponse.isSucceeded) {
                        _SetUIStatusSuccess(true, checkUpdateModelResponse.message);

                        $("#ServerFirmwareVersion").val(checkUpdateModelResponse.versionServer);

                        if (checkUpdateModelResponse.newVersionFound) {
                            _SetUIDownloadButton(true);
                        }
                    }
                    else {
                        _SetUIStatusError(true, checkUpdateModelResponse.message);
                    }
                },
                error: function (jqXHR, status, error) {
                    var errMessage = "error occured"

                    if (jqXHR && jqXHR.responseJSON) {
                        if (jqXHR.responseJSON.message) {
                            errMessage = jqXHR.responseJSON.message;
                        }
                    }
                    else if(error) {
                        errMessage = error;
                    }

                    _SetUIStatusError(true, errMessage);

                    console.log(errMessage);
                }
            });
        }
        catch (error) {
            console.error('Error:', error);

            _SetUIStatusError(true, error);
        }
    }

    async function _SubmitDownload(oFormElement)
    {
        _ResetUIStatus()
        _ResetUIDownload();
        _ResetUIUpload();

        _SetUIDownloadButton(false);
        _SetUIStatusInProgrss(true, "Download ...");

        const formData = new FormData(oFormElement);

        try {
            const response = await fetch(oFormElement.action, {
                method: 'POST',
                headers: { 'RequestVerificationToken': _getCookie('RequestVerificationToken') },
                body: formData
            });

            if (response.status === 200) {
                response.json().then(
                    function (value) {
                        _SetUIStatusSuccess(true, value.message)
                        _GetResult();
                    })
                    .catch(err => {
                        console.log(err);
                    });
            }
            else {
                response.json().then(
                    function (value) {
                        _SetUIStatusError(true, value.message);
                    })
                    .catch(err => {
                        console.log(err);
                    });
            }
        }
        catch (error) {
            console.error('Error:', error);

            _SetUIStatusError(true, error);
        }
    }

    return {
        init: function () {
            $('#uploadForm').on("submit", function (event) {
                _SubmitUpload(this);

                return false;
            });

            $('#downloadLatestForm').on("submit", function (event) {
                _SubmitDownload(this);

                return false;
            });

            $('#fileSelector').on("change", function () {
                _ResetUIStatus();
                _ResetUIDownload();
                _SetUIUploadButton(true);
            });

            $('#selectFirmwareUpdateFeed').on("change", function () {
                _CheckForUpdate()
            });

            if ($('#NoCheckUpdate').val() !== "True") { 
                _CheckForUpdate();
            }
        }
    };
});
