#!/bin/sh
# Version 00.00.03
# Update Script fuer Betriebsystem Patche
# letzte Aenderungen:
# - anpassung Systemversion an die Patchlist Dateien anhaengen
# - korrektur des scripts , wenn keine Patches vorhanden sind

ENABLE_REBOOT=$((1))

CTIHOMEDIR=/home/cti
LOGFILE=$CTIHOMEDIR/system_patch.log

VERSIONSFILE=$CTIHOMEDIR/version.txt
CURRENT_BS_VERSION="#unbekannt#"

SCRIPT_PATH="`dirname \"$0\"`"

#-------------------------------
GetSystemVersion()
{
	while read -r line; do
	# reading each line
	case $line in
	 	*"CTI System"*)
	# Splits String, Versionsnummer extrehieren
		SUBSTRINGLEFT=${line% (erstellt*}     # alles links von  (erstellt
		BS_VERSION_NR=${SUBSTRINGLEFT#*System }     # alles rechts von Sytsem
		echo " input:  <$line>"
		echo " Version: <${BS_VERSION_NR}>"
		CURRENT_BS_VERSION=${BS_VERSION_NR}
		;;
	esac
	done < $VERSIONSFILE
}
#-------------------------------
sysupdate()
{
   ENABLE_REBOOT=$((0))
   realrun
}
#-------------------------------

# NOTE : Quote it else use array to avoid problems #

realrun()
{
	GetSystemVersion
	FILES="$SCRIPT_PATH/*.upd"
	SUCCESS_SCRIPT=0

	for f in $FILES
	do
		echo "Processing $f file..."
		if [ ! -e $f ]; then
         echo "ignore non existent <$f>"
		else
         # take action on each file. $f store current file name
         chmod +x $f
         echo -en "  $f $LOGFILE $CURRENT_BS_VERSION $1 \n"
         $f "$LOGFILE" "$CURRENT_BS_VERSION" "$1"
         ReturnValue=$?
         if [ $ReturnValue -eq "0" ]; then
            echo -en "Erfolg exec: $f\n"
            SUCCESS_SCRIPT=$((SUCCESS_SCRIPT+1))
         else
            echo -en "\nUpdate [$f] nicht installiert\n"
         fi
      fi
	done
	if [ $SUCCESS_SCRIPT -gt 0 ]; then
		echo -en "\n reboot $SUCCESS_SCRIPT\n"
		echo -en "Updates installiert $(date "+%d.%m.%Y %T") \n-------------------------------------\n\n" >> $LOGFILE
      if [ $ENABLE_REBOOT -gt 0 ]; then
         now=$(date)
         NAME=$(basename "$0")
         REASON="Installation Patch(e)"
         echo "{\"source\":\"$NAME\",\"date\":\"$now\",\"reason\":\"$REASON\"}" > /home/cti/rebootinfo.json
         reboot
      fi
	else
		echo -en "fertig, nichts zu tun \n"
	fi
}

#-------------------------------
emulation()
{
  	LOGFILE="system_patch_simulation.log"
	StringList="./BS_1_1 ./BS_1-2 ./BS1_3-1_7 ./BS_2_xx ./BS_3_xx"
#	StringList="./BS1_3-1_7 ./BS_2_xx ./BS_3_xx"
#	StringList="./BS1_3-1_7"
#StringList="./BS_1_1 "
	echo -en "\nE M U L A T I O N\n-------------------"
# Iterate the string variable using for loop
	for makeBS in $StringList; do
		EMUDIR=$makeBS
		CTIHOMEDIR=$EMUDIR/home/cti
		VERSIONSFILE=$CTIHOMEDIR/version.txt
		PATCH_INFO_DIR=$CTIHOMEDIR/system_patch_list
		StartScriptDir=$EMUDIR/etc/init.d
		echo -en "\nTeste $VERSIONSFILE \n"
		realrun $EMUDIR
		echo -en "\n-------------------\n"
	done
}
#--------------------------------
#====================
# main case ...
#====================

case "$1" in
  sim)
	emulation
	;;
  update)
  sysupdate
	;;
  *)
	realrun
esac

exit $?

