#!/bin/sh
# Version 00.00.10
# Script fuer Hotplug & Routing, wegen ppp Verbindungen
# VPN ist momentan ignoriert
# Debug und log zugefuegt

#help - Linux Shell
# http://www.linux-praxis.de/linux1/shell2_5.html
#help - interfaces/wpa
# https://manpages.debian.org/stretch/ifupdown/interfaces.5.en.html
# wpa status codes  - https://www.toomanyatoms.com/computer/disconnection_codes.html
# kernel Doc operstate - https://docs.kernel.org/networking/operstates.html

SCRIPTNAME=`basename "$0"`
ACTION=$1
INTERFACE_NAME=$2
PRODUCT_ID=$3
VENDOR_ID=$4

USERHOMEDIR=/home/cti
MOBILPATH=$USERHOMEDIR/mobilfunk
SCRIPTPATH=$USERHOMEDIR/shellscripts

DEV_WLAN=/sys/class/net/wlan0
WIRELES_ENABLED=$USERHOMEDIR/wireless
MOBILE_ENABLED=$USERHOMEDIR/mobilekomm

WLANLED=/sys/class/leds/wlanled/brightness

MTU_CONF_DIR=${USERHOMEDIR}/conf/mtu

# Zahlen entfernen, damit aus eth0 nur eth wird usw.
PART_INTERFACE_NAME=`echo ${INTERFACE_NAME} | sed 's/[0-9]\+$//'`
# debug
# echo " -> $PART_INTERFACE_NAME"

# add wird aufgerufen, wenn Hardware aktiviert wird. Könnte man nutzen um sich zu merken, welche HW vorhanden ist
# debug
# /usr/bin/logger -s "CTI $SCRIPTNAME all: 1-($1), 2-($2), 3-($3), 4-($4), 5-($5), 6-($6), 7-($7), 8-($8), 9-($9), 10-($10)"
#--------------
STATUS_OK=$((0))
STATUS_ERR=$((1))
STATUS_ERR_PARAMETER=$((3))  #fehlender Parameter
#--------------

ERRORLOGFILE=/var/log/network_helper.log
DEBUG_ENABLED_FILE=/home/cti/wlan_debug_enable

if [ ! -e $DEBUG_ENABLED_FILE ]; then
   g_debug_enabled=$((0))
else
   g_debug_enabled=$((1))
fi
# echo "debug: $g_debug_enabled"

#--------------
PrintDebug()
{
   if [ $g_debug_enabled -gt 0 ]; then
      echo "[DEBUG]:---- $(date) ---- $1" >>$ERRORLOGFILE
   fi
}
#--------------
check_usb()
{
# Note, wenn WLAN Dongel entfernt wird, led ausschalten
	if [ "$ACTION" = "remove" ] ; then
		if [ ! -e $DEV_WLAN ]; then
         SetupWlan 0
		fi
	fi
# Modem weg, wenn andere Modems dazukommen, muss hier angepasst werden
# fibocom NL 866
	if [ "$VENDOR_ID" == "1508" ] && [ "$PRODUCT_ID" == "1001" ] ; then
		MOBILEPID=$(cat /var/run/mobile_komm.pid)
		/usr/bin/logger -s "CTI $SCRIPTNAME Modem fibocom NL 866 Signal to $MOBILEPID, $INTERFACE_NAME -> $ACTION, P: $PRODUCT_ID, V: $VENDOR_ID ($PART_INTERFACE_NAME), killall pppd"
# user signal senden an MobileKommTool
		kill -18 $MOBILEPID
		/usr/bin/killall pppd || true
# debug
#		echo -en "\n======= $(date "+%d.%m.%Y %T") ====== \n $(ps) \n" >>  /home/cti/pslog.txt
#		if [ "$ACTION" = "remove" ] ; then
#			/usr/bin/logger -s "CTI $SCRIPTNAME stop pppd $INTERFACE_NAME -> $ACTION, P: $PRODUCT_ID, V: $VENDOR_ID ($PART_INTERFACE_NAME) removed"

	fi
}
#--------------
checkWPAStatus()
{
# Funktion kann fuer alle moeglichen Adapter benutzt werden
   DEVICE=$1
#Debug       echo "---- $(date) - call Check [$DEVICE] wpa status -------"
   if [ ! -r /var/run/wpa_supplicant.$DEVICE.pid ]; then
#Debug       /usr/bin/logger -s
      PrintDebug "WARNING: no wpa_supplicant running for [$DEVICE] "
      # wenn wpa_supplikant fuer den Adapter nicht aktiv ist -> ende, keine Meldung
      exit 2
   fi
   NumCheck=0
	while [ $NumCheck -lt 5 ]; do
   WPASTATE=$(wpa_cli -i $DEVICE status | grep wpa_state | sed -e "s/wpa_state=//g" 2>&1)
	if [ "$WPASTATE" == "COMPLETED" ]; then
      PrintDebug "ok [$DEVICE] wpa status: active"
	   exit 0
   else
      let NumCheck=NumCheck+1
      sleep 3
      PrintDebug "Check [$DEVICE] wpa status [$WPASTATE] -> next try"
   fi
   done
   PrintDebug "error [$DEVICE] wpa status: not active: $WPASTATE"
   exit 1

}
#--------------
SetupWlan()
{
   MODE=$1
   if [ $MODE == "1" ] ; then
      if [ -x /usr/sbin/iw ] ; then
         iw $INTERFACE_NAME set power_save off
      else
         iwconfig $INTERFACE_NAME power off
      fi
      echo 1 >$WLANLED
    	/usr/bin/logger -s "CTI $SCRIPTNAME wlan0 aktiv/enabled"
    	PrintDebug "SetupWlan() wlan0 aktiv/enabled"
   fi
   if [ $MODE == "0" ] ; then
      wpa_cli -i wlan0 terminate
      echo 0 >$WLANLED
    	/usr/bin/logger -s "CTI $SCRIPTNAME wlan0 inaktiv/disabled"
    	PrintDebug "SetupWlan() wlan0 inaktiv/disabled"
   fi
}
#--------------
check_wlan()
{
# wenn device entfernt wird ist Pruefung ob Gerat vorhanden ja sinnlos
	if [ "$ACTION" = "remove" ] ; then
			ifdown $INTERFACE_NAME
		return 0
	fi
# pruefen ob device wlan0 existiert /sys/class/net/wlan0
	if [ ! -e $DEV_WLAN ]; then
		/usr/bin/logger -s "CTI $SCRIPTNAME $INTERFACE_NAME not exists, exec <$ACTION>"
		return 0
	fi
	/usr/bin/logger -s "CTI $SCRIPTNAME $INTERFACE_NAME -> $ACTION, P: $PRODUCT_ID, V: $VENDOR_ID ($INTERFACE_NAME)  "
	if [ "$ACTION" = "add" ] ; then
		PrintDebug "wlan add -> call mtu check! GetMinMaxMtu $INTERFACE_NAME"
		GetMinMaxMtu $INTERFACE_NAME
		ifdown $INTERFACE_NAME
		ifup $INTERFACE_NAME
	fi
	if [ "$ACTION" = "down" ] ; then
		SetupWlan 0
   fi
	if [ "$ACTION" = "up" ] ; then
		SetupWlan 1
   fi

   if [ ! -e $WIRELES_ENABLED ]; then
		/usr/bin/logger -s "CTI $SCRIPTNAME not enabled wireless(wlan)"
		return 0
	fi
	if [ "$ACTION" = "pre_up" ] ; then
		# falls es noch aktiv ist
      wpa_cli -i $INTERFACE_NAME terminate || true
      if [ -r /var/run/wpa_supplicant.$INTERFACE_NAME.pid ]; then
         kill -9 $(cat /var/run/wpa_supplicant.$INTERFACE_NAME.pid)
      fi
      wpa_supplicant -t -B -Dnl80211,wext -i$INTERFACE_NAME -c /etc/wpa_supplicant.conf -f /var/log/wpa_supplicant.$INTERFACE_NAME.log  -P /var/run/wpa_supplicant.$INTERFACE_NAME.pid
# eth example:      wpa_supplicant -B -Dnl80211,wext -ieth0 -c/etc/wpa_supplicant_eth0.conf -P /var/run/wpa_supplicant.eth0.pid
     sleep 2
     checkWPAStatus $INTERFACE_NAME
	fi
	if [ "$ACTION" = "post_up" ] ; then
      Set_MTU_IF
   fi
}
#--------------
check_ppp()
{
	if [ ! -e $MOBILE_ENABLED ]; then
		/usr/bin/logger -s "CTI $SCRIPTNAME not enabled Mobilekomm (ppp) "
		return 0
	fi
	if [ "$ACTION" = "add" ] ; then
		/usr/bin/logger -s "CTI $SCRIPTNAME ppp connected set default route { ${INTERFACE_NAME} }"
		#wait  ppp0 up
		COUNTER=0
		while [ $COUNTER -lt 5 ]; do
		ADAPTER=$( ifconfig | awk -F '[ =]+' '/ppp/{ print $1 }' )
		if [ $ADAPTER = $INTERFACE_NAME ] ; then
			logger -s  "ppp online Set route $COUNTER"
			/sbin/route add default dev ${INTERFACE_NAME}
				COUNTER=50
			else
            logger -s  "$ADAPTER != $INTERFACE_NAME -> wait 2 secs"
				let COUNTER=COUNTER+1
				sleep 2
			fi
		done
	fi
	if [ "$ACTION" = "remove" ] ; then
		/usr/bin/logger -s "CTI $SCRIPTNAME ppp dropped remove default route { ${INTERFACE_NAME} }"
		/sbin/route del default dev ${INTERFACE_NAME}
	fi
}
#--------------
check_eth()
{
# MTU setzen
	if [ "$ACTION" = "add" ] ; then
      GetMinMaxMtu $INTERFACE_NAME
   fi
	if [ "$ACTION" = "post_up" ] ; then
      Set_MTU_IF
   fi
}
#---------------
Set_MTU_IF()
{
   if [ -f ${MTU_CONF_DIR}/$INTERFACE_NAME.conf ]; then
      MTU_Value=$(cat ${MTU_CONF_DIR}/$INTERFACE_NAME.conf)
      exec_Cmd=$(ip link set dev $INTERFACE_NAME mtu $MTU_Value )
      result=$?
#DEBUG
echo "set mtu result: $result"
      if [ "$result" -eq "0" ] ; then
      # setzen war erfolgreich,
         echo "set $INTERFACE_NAME mtu $MTU_Value ok"
      else
         logger -s "Error set $INTERFACE_NAME mtu  $MTU_Value"
      fi
   fi
}
#---------------
GetMinMaxMtu()
{
   MinMTU="576"
   MaxMTU="1500"
   TEST_MTU=65536
   IFACE=$1
	MTU_DEFAULT=`cat /sys/class/net/$IFACE/mtu `
   if [ -z "$IFACE" ]; then
      echo "Error: missing Parameter IFACE"
      return
   fi
#   MTU_DEFAULT=$(cat /tmp/mtu.$IFACE.default)
   exec_Cmd=$(ip link set dev $IFACE mtu $TEST_MTU )
	result=$?
#DEBUG   echo "result: $result"
	if [ "$result" -eq "0" ] ; then
# setzen war erfolgreich, was aber hier falsch ist
# MaxMTU nicht ermittelbar, also default Wert
      if [ -z "$MTU_DEFAULT" ]; then
         MTU_DEFAULT=1500
         echo "not set default -> $MTU_DEFAULT"
      fi
      MaxMTU=$MTU_DEFAULT
      echo "set <too big> mtu -> reset to default: $MTU_DEFAULT"
      ip link set dev $IFACE mtu $MTU_DEFAULT
   else
#DEBUG      echo "ok"
   exec_Cmd=$(dmesg  | tail -n 1)
#DEBUG   echo "$exec_Cmd"
#	while read -r line; do
	case $exec_Cmd in
#ok	 	*"hw max"*)
      *"$IFACE: Invalid MTU $TEST_MTU requested, hw max"*)
		MaxMTU=${exec_Cmd#*max }     # alles rechts von max
		;;
	esac
#	done < $exec_Cmd
   fi
#DEBUG    echo "$MinMTU,$MaxMTU,$MTU_DEFAULT -> in Json packen" 1
#json Datei fuer System Info erstellen
echo "{ \"Min\": \"$MinMTU\", \"Max\": \"$MaxMTU\",  \"Default\": \"$MTU_DEFAULT\" }" > /var/run/mtu.$IFACE.json


}
#====================
# main case ...
#====================
case "$PART_INTERFACE_NAME" in
 wlan)
	check_wlan
	;;
 ppp)
	check_ppp
	;;
 usb)
	check_usb
	;;
 eth)
   check_eth
   ;;
 DEBUG)
	/usr/bin/logger -s "CTI $SCRIPTNAME DEBUG- Info: 1-($1), 2-($2), 3-($3), 4-($4), 5-($5), 6-($6), 7-($7), 8-($8), 9-($9), 10-($10)"
	;;
	CheckWPAStatus)
	checkWPAStatus "$1"
	;;
 *)
   # nur ttyACM3 beachten, es werden 6 ACM erzeugt, pppd starten, wenn Device aktiviert wird
 #	if [[ $INTERFACE_NAME = "/dev/ttyACM3" ]]; then
	#	check_ppp
#	else
#		echo "ignored dev $PART_INTERFACE_NAME"
#	fi
	exit 1
esac

exit $?
