#!/bin/sh
# Version 00.00.03
# Update Script fuer Betriebsystem auf CTI Karo Module:
# - Anpassung fuer Renesas TXRZ
# Korrektiur Versionsabfrage
#
# help Linux Shell
# http://www.linux-praxis.de/linux1/shell2_5.html
# 1. signierung pruefen - algo steht im sys_script, klauen
# 2. entpachen alles nach BS_Update, mit unterverzeichnissen
#    * tar xf file.tar -C /path/to/directory
# u-boot.env anpassen

USERHOMEDIR=/home/cti
BSUPDATEDIR=${USERHOMEDIR}/Update_BS
ERROR_LOG_FILE=${USERHOMEDIR}/update_os.log
VERSIONSFILE=${USERHOMEDIR}/version.txt
PLATTFORM=${USERHOMEDIR}/.karo-txrz
NEW_VERSIONFILE=/tmp/new_version.txt
CHECKIMAGEMOUNT=/mnt/checkfs

CURRENT_BS_VERSION="#unbekannt#"
NEW_BS_VERSION="#unbekannt#"
SCRIPT_PATH="`dirname \"$0\"`"

DEBUG_ENABLE=
IMGFILENAME=
ENVBOOT=0

STATUS_OK=$((0))
STATUS_ERR3=$((3))  # fehlender Parameter
STATUS_ERR11=$((11))  #Fehler, binäres Signaturfile konnte nicht erstellt werden
STATUS_ERR12=$((12))  #Fehler, Firmware/Tarfile und und Signatur passen nicht zueinander
STATUS_ERR13=$((13))  #Fehler, Tarfile konnte nicht entpackt werden
STATUS_ERR14=$((14))  #Fehler, Init der u-boot.env fehlgeschlagen
STATUS_ERR15=$((15))  #Fehler, Setzen der u-boot.env fehlgeschlagen (ram/mmc)
STATUS_ERR16=$((16))  #Fehler, Version des Betriebsystem falsch (oder Plattform, Architektur(arm, arm64) passen nicht)
STATUS_ERR17=$((17))  #Fehler, Installation der Systempatches fehlgeschlagen
STATUS_ERR18=$((18))  #Fehler, im Verzeichnis "_update/os/install_BS" befindet sich  \b kein System(Kernel oder RootFS) für mmc oder ram
STATUS_ERR19=$((19))  #Fehler, Downgrade nicht zulaessig, es ist bereits ein neueres System installiert

PrintErrorExit()
{
   if [ ${DEBUG_ENABLE} = "1" ]; then
      echo "[DB] error $1, $2"
   fi
	echo "$(date "+%d.%m.%Y %T") error $1, $2" >> ${ERROR_LOG_FILE}
	CleanupError
   exit $1
}
#--------------------
PRINT_DEBUG()
{
   if [ ${DEBUG_ENABLE} = "1" ]; then
      echo "[DB] $1"
   fi
}
#--------------------
Cleanup()
{
   umount ${CHECKIMAGEMOUNT}
# Kein Image angegeben, nichts zum löschen da
   if [ -z ${IMGFILENAME} ] ; then
      return
   fi
# Dateien löschen
	rm ${IMGFILENAME}.tar
	rm ${IMGFILENAME}.signature

}
#--------------------
CleanupError()
{
   PRINT_DEBUG "cleanup, lösche image/dir"
   if [ "$ENVBOOT" -eq "1" ] ; then
      RestoreEnv
   fi
   Cleanup
   rm -r ${BSUPDATEDIR}
}
#--------------------
RestoreEnv()
{
	PRINT_DEBUG "setze Bootenv auf default"
	MyCommand=$(${USERHOMEDIR}/hw_data/hw_setup_cti -b mmc 2>&1)
	result=$?
	if [ "$result" -ne "0" ] ; then
		echo " {E R R O R} MyCommand: < ${MyCommand} >, result: ${result}"
      PrintErrorExit ${STATUS_ERR4} "Fehler Wiederherstellung der u-boot.env <${MyCommand}>"
	fi
      echo "Wiederherstellung u-boot.env OK"

}
#--------------------
CheckDirectory()
{
# Verzeichnis erstellen, wenn es nicht existiert
	if [ ! -d ${BSUPDATEDIR} ]; then
      mkdir -p ${BSUPDATEDIR}
   fi
}
#--------------------
CheckCurrentBS()
{
   VersionString=$1
   verMaj=$(echo $VersionString | awk -F. '{print $1}' | sed 's/^0*//')
   verMid=$(echo $VersionString | awk -F. '{print $2}' | sed 's/^0*//')
   verMin=$(echo $VersionString | awk -F. '{print $3}' | sed 's/^0*//')
#DEBUGecho " Version calc(()) --> [$(($verMaj))] [$(($verMid))] [$(($verMin))]"
#mindestens  04.00.02
   if [ $(($verMaj)) -lt 4 ]; then
         return $((0))
   fi
   if [ $(($verMin)) -lt 2 ]; then
         return $((0))
   fi
   return $((1))
}
#--------------------
CheckNewBSVersion()
{
# Test
#   CURRENT_BS_VERSION="03.00.07"
#   CURRENT_BS_VERSION="01.01.03"
# Test 	NEW_BS_VERSION="03.00.04"
   CURRENT_BS_VERSION=$1
   NEW_BS_VERSION=$2

   newMaj=$(echo $NEW_BS_VERSION | awk -F. '{print $1}' | sed 's/^0*//')
   newMid=$(echo $NEW_BS_VERSION | awk -F. '{print $2}' | sed 's/^0*//')
   newMin=$(echo $NEW_BS_VERSION | awk -F. '{print $3}' | sed 's/^0*//')

   currMaj=$(echo $CURRENT_BS_VERSION | awk -F. '{print $1}' | sed 's/^0*//')
   currMid=$(echo $CURRENT_BS_VERSION | awk -F. '{print $2}' | sed 's/^0*//')
   currMin=$(echo $CURRENT_BS_VERSION | awk -F. '{print $3}' | sed 's/^0*//')

   if [ $(($newMid))  -ne  $(($currMid)) ]; then
# wenn custom Version, dann nicht installieren-> log
      echo " ERROR : $CURRENT_BS_VERSION -> $NEW_BS_VERSION  -- $(($newMid)) special"
      return $STATUS_ERR19
   fi
# -gt groessser als
   if [ $(($newMaj))  -gt  $(($currMaj)) ]; then
      echo " INSTALL: $CURRENT_BS_VERSION -> $NEW_BS_VERSION "
      return $STATUS_OK
   fi
# -lt kleiner als
   if [ $(($newMaj))  -lt  $(($currMaj)) ]; then
      echo " IGNORE: $CURRENT_BS_VERSION -> $NEW_BS_VERSION -- $(($newMaj)) old sys maj"
      return $STATUS_ERR19
   fi
   if [ $(($newMaj))  -eq  $(($currMaj)) ]; then
# -le kleiner oder gleich
      if [ $(($newMin))  -le  $(($currMin)) ]; then
         echo " IGNORE: $CURRENT_BS_VERSION -> $NEW_BS_VERSION -- $(($newMin)) old sys min"
         return $STATUS_ERR19
      fi
   fi
    echo " INSTALL: $CURRENT_BS_VERSION -> $NEW_BS_VERSION "
   return $STATUS_OK

#STATUS_ERR16=$((16))  #Fehler, Version des Betriebsystem zu alt, kleiner 3.x.x
#STATUS_ERR19=$((19))  #Fehler, Downgrade nicht zulaessig, es ist bereits ein neueres System installiert

}
#--------------------
CheckSystemVersion()
{
	if [ ! -e ${PLATTFORM} ]; then
		PrintErrorExit ${STATUS_ERR16}   "falsche Plattform, kein Update möglich!"
	fi

	while read -r line; do
	# reading each line
	case $line in
	 	*"CTI System"*)
	# Splits String, Versionsnummer extrehieren
		SUBSTRINGLEFT=${line% (erstellt*}     # alles links von  (erstellt
		BS_VERSION_NR=${SUBSTRINGLEFT#*System }     # alles rechts von Sytsem
		PRINT_DEBUG " input:  <$line>"
		PRINT_DEBUG " Version: <${BS_VERSION_NR}>"
      CURRENT_BS_VERSION=${BS_VERSION_NR}
		;;
	esac
	done < $VERSIONSFILE

   CheckCurrentBS ${CURRENT_BS_VERSION}
	Result=$?
   if [ $Result -eq 0 ] ; then
		PrintErrorExit ${STATUS_ERR16} " ---- System Version zu alt/unbekannt <$CURRENT_BS_VERSION>! ----   \n -> Update des Betriebsystemes nicht möglich!\n"
	else
		PRINT_DEBUG "---- $2 - System Version OK <$CURRENT_BS_VERSION>! \n"
		echo "$(date "+%d.%m.%Y %T") ---- $2 - System Version OK <$CURRENT_BS_VERSION>! ----" >> ${ERROR_LOG_FILE}
# das ist Test   exit $((0))
	   if [ ! -f /home/cti/old_BS-* ]; then
			echo "-----------old sysinfo-----------"
			touch /home/cti/old_BS-$CURRENT_BS_VERSION
			chmod 444 /home/cti/old_BS-$CURRENT_BS_VERSION
		fi
	fi
}
#--------------------
CheckFileExtract()
{
#
# signatur pruefen und tar entpacken
#
   TARFILENAME=${IMGFILENAME}.tar
	PRINT_DEBUG "Tarfile: <$TARFILENAME> "
	MyCommand=`openssl base64 -d -in ${IMGFILENAME}.signature -out /tmp/sign.sha256.bin 2>&1 `
	result=$?
	PRINT_DEBUG " ssl-result: $result"
	if [ "$result" -ne "0" ] ; then
      PrintErrorExit ${STATUS_ERR11} "create hash.bin, remove ${IMGFILENAME}.*"
	else
		PRINT_DEBUG "start verify..."
		MyCommand=`openssl dgst -sha256 -verify  ${USERHOMEDIR}/security/ctipublic.pem -signature /tmp/sign.sha256.bin ${TARFILENAME}  2>&1 `
		result=$?
		rm /tmp/sign.sha256.bin
		PRINT_DEBUG " verify result $result"
		if [ "$result" -ne "0" ] ; then
			PrintErrorExit ${STATUS_ERR12} "signatur verify failed"
		fi
	fi

	PRINT_DEBUG "tarfile is valid"
# entpacken
   PRINT_DEBUG " cmd < tar -x -f ${TARFILENAME} -C ${BSUPDATEDIR}>"
	MyErrorMessage=$(tar -x -f ${TARFILENAME} -C ${BSUPDATEDIR}  2>&1)
	result=$?
	if [ "$result" -eq "0" ] ; then
		PRINT_DEBUG " tar entpacken: ok \n"
	else
		PrintErrorExit ${STATUS_ERR13} "Fehler bei SystemUpdate <$MyErrorMessage> $result"
	fi
}
#--------------------
CheckNewImages()
{
# überprüfen om Ram und MMC Image vorhanden sind
   PRINT_DEBUG "prüfe RamImage ..."
   # Teste Kernel
   if [ -s ${BSUPDATEDIR}/ram_image/uImage ] ; then
      PRINT_DEBUG "RAM Kernel vorhanden "
   else
      PrintErrorExit ${STATUS_ERR18} "Fehler, Ram Kernel nicht gefunden "
   fi
   # Teste rootfs
   if [ -s ${BSUPDATEDIR}/ram_image/rootfs.cpio.uboot ] ; then
      PRINT_DEBUG "RAM RootFS vorhanden "
   else
      PrintErrorExit ${STATUS_ERR18} "Fehler, Ram RootFS nicht gefunden "
   fi
   PRINT_DEBUG "prüfe MMCImage(rootfs) ..."
   if [ -s ${BSUPDATEDIR}/mmc_image/rootfs.ext2 ] ; then
       PRINT_DEBUG "MMC rootfs vorhanden "
    else
       PrintErrorExit ${STATUS_ERR18} "Fehler, MMC rootfs nicht gefunden "
   fi
}
#--------------------
CheckNewImageVersion()
{
   PRINT_DEBUG "prüfe Neue Systemversion ..."
   mkdir -p ${CHECKIMAGEMOUNT}
	RunCommand=$(mount -o loop ${BSUPDATEDIR}/mmc_image/rootfs.ext2 ${CHECKIMAGEMOUNT} 2>&1)
	result=$?
	if [ "$result" -ne "0" ] ; then
		PRINT_DEBUG " {E R R O R} mount RunCommand: < ${RunCommand} >, result: ${result}"
		PrintErrorExit ${STATUS_ERR18} "mount rootfs.ext2: < ${RunCommand} >, result: ${result}"	>> ${ERROR_LOG_FILE}
   fi
   cat ${CHECKIMAGEMOUNT}/home/cti/version.txt >${NEW_VERSIONFILE}

# nur Test   cat /home/cti/version_new.txt >${NEW_VERSIONFILE}

	while read -r line; do
	# reading each line
	case $line in
	 	*"CTI System"*)
	# Splits String, Versionsnummer extrehieren
		SUBSTRINGLEFT=${line% (erstellt*}     # alles links von  (erstellt
		BS_VERSION_NR=${SUBSTRINGLEFT#*System }     # alles rechts von Sytsem
		PRINT_DEBUG " input:  <$line>"
		PRINT_DEBUG " Version: <${BS_VERSION_NR}>"
		NEW_BS_VERSION=${BS_VERSION_NR}
		;;
	esac
	done < $NEW_VERSIONFILE

   CheckNewBSVersion ${CURRENT_BS_VERSION}  ${NEW_BS_VERSION}
   Result=$?
   if [ $Result -ne 0 ] ; then
      PrintErrorExit $(($Result)) "kein passendes Betriebsystem: ${CURRENT_BS_VERSION} ->  ${NEW_BS_VERSION}"
#STATUS_ERR16=$((16))  #Fehler, Version des Betriebsystem zu alt, kleiner 3.x.x
#STATUS_ERR19=$((19))  #Fehler, Downgrade nicht zulaessig, es ist bereits ein neueres System installiert
   fi
	echo "$(date "+%d.%m.%Y %T") ---- starte update auf  <${NEW_BS_VERSION}> ---- " >> ${ERROR_LOG_FILE}
}
#--------------------
InstallSystemPatches()
{
#  mit update alle Patche installieren
   chmod +x ${BSUPDATEDIR}/system_patches/systempatch.sh
	${BSUPDATEDIR}/system_patches/systempatch.sh update
	ReturnValue=$?
	if [ $ReturnValue -eq "0" ]; then
		PRINT_DEBUG "Erfolg exec: [install Patches]\n"
	else
      PrintErrorExit ${STATUS_ERR17} "[install Patches] nicht erfolgreich\n"
	fi
}
#--------------------
SetupEnv()
{
# Archiv entpackt, setze Bootargs & reboot
# Einrichtung Bootargs,  wenn Datei nicht existiert muss init erfolgen
# betrifft nur TX, weil in den Bootenv das booten per ramdisk nicht enthalten ist, Abfrage erfolgt im hw_setup Tool
	if [ ! -f ${USERHOMEDIR}/stamp_updateable ]; then
		MyCommand=$(${USERHOMEDIR}/hw_data/hw_setup_cti -b init 2>&1)
		result=$?
		if [ "$result" -ne "0" ] ; then
         PRINT_DEBUG "{E R R O R} MyCommand: < ${MyCommand} >, result: ${result}"
      PrintErrorExit ${STATUS_ERR14} " Fehler beim Init der u-boot.env <${MyCommand}>"
		fi
		PRINT_DEBUG "Init u-boot.env OK"
		touch ${USERHOMEDIR}/stamp_updateable
	fi
	MyCommand=$(${USERHOMEDIR}/hw_data/hw_setup_cti -b ram 2>&1)
	result=$?
	if [ "$result" -ne "0" ] ; then
      PRINT_DEBUG "{E R R O R} MyCommand: < ${MyCommand} >, result: ${result}"
		PrintErrorExit ${STATUS_ERR15}	"Fehler beim Setzen der u-boot.env <${MyCommand}>"
	fi
	PRINT_DEBUG "bereit zur installation ... (env done)"
	ENVBOOT=1

}
#---------
InstallUpdate()
{
   IMGFILENAME=$1
   CheckSystemVersion
   if [ -z ${IMGFILENAME} ] ; then
      PrintErrorExit ${STATUS_ERR3} "kein Tar angegeben, nichts zu prüfen und entpacken "
   else
      CheckDirectory
      CheckFileExtract
   fi
   CheckNewImages
   CheckNewImageVersion
#echo "Emulation done"
#exit $((0))
   InstallSystemPatches
   SetupEnv
   Cleanup
   PRINT_DEBUG "---- Starte Update ---- von ${CURRENT_BS_VERSION} -> ${NEW_BS_VERSION}"
   echo "$(date "+%d.%m.%Y %T") ---- Starte Update ---- von ${CURRENT_BS_VERSION} -> ${NEW_BS_VERSION}" >> ${ERROR_LOG_FILE}
   sync
   PRINT_DEBUG "all ok, reboot needed..."
   exit ${STATUS_OK}
# macht netcoreapp:   reboot
}
#---------
TestScript()
{
   NEW_BS_VERSION="04.00.03"
   CheckSystemVersion
   echo " Teste neues System!"
   CheckNewBSVersion ${CURRENT_BS_VERSION}  ${NEW_BS_VERSION}
   Result=$?
#   if [ $Result -eq 0 ] ; then
   if [ $Result -ne 0 ] ; then
      PrintErrorExit $(($Result)) " Mahatma ungueltiges Betriebsystem ${CURRENT_BS_VERSION} ->  ${NEW_BS_VERSION}"
#STATUS_ERR16=$((16))  #Fehler, Version des Betriebsystem zu alt, kleiner 3.x.x
#STATUS_ERR19=$((19))  #Fehler, Downgrade nicht zulaessig, es ist bereits ein neueres System installiert
   fi
	echo "$(date "+%d.%m.%Y %T") ---- emulation update auf  <${NEW_BS_VERSION}> ---- " >> ${ERROR_LOG_FILE}
}
#====================
# main case ...
#====================
#echo "[DB] sp: <$SCRIPT_PATH> pwd: `pwd`"
DEBUG_ENABLE=$(($1))
echo "[Info]InstallUpdate $2, (Debug=$DEBUG_ENABLE)\n"

InstallUpdate "$2"
#TestScript
exit $?
