#!/bin/sh
# Version 00.00.01
# Update Script fuer Betriebsystem auf CTI Karo Module:
#
# help Linux Shell
# http://www.linux-praxis.de/linux1/shell2_5.html
# 1. signierung pruefen - algo steht im sys_script, klauen
# 2. entpachen alles nach BS_Update, mit unterverzeichnissen
#    * tar xf file.tar -C /path/to/directory
# u-boot.env anpassen

USERHOMEDIR=/home/cti
BSUPDATEDIR=${USERHOMEDIR}/Update_BS
ERROR_LOG_FILE=${USERHOMEDIR}/update_os.log
VERSIONSFILE=${USERHOMEDIR}/version.txt
NEW_VERSIONFILE=/tmp/new_version.txt

CURRENT_BS_VERSION="#unbekannt#"
SCRIPT_PATH="`dirname \"$0\"`"

DEBUG_ENABLE=
IMGFILENAME=
ENVBOOT=0

STATUS_OK=$((0))
STATUS_ERR3=$((3))  # fehlender Parameter
STATUS_ERR11=$((11))  #Fehler, binäres Signaturfile konnte nicht erstellt werden
STATUS_ERR12=$((12))  #Fehler, Firmware/Tarfile und und Signatur passen nicht zueinander
STATUS_ERR13=$((13))  #Fehler, Tarfile konnte nicht entpackt werden
STATUS_ERR14=$((14))  #Fehler, Init der u-boot.env fehlgeschlagen
STATUS_ERR15=$((15))  #Fehler, Setzen der u-boot.env fehlgeschlagen (ram/mmc)
STATUS_ERR16=$((16))  #Fehler, Version des Betriebsystem zu alt, kleiner 3.x.x
STATUS_ERR17=$((17))  #Fehler, Installation der Systempatches fehlgeschlagen
STATUS_ERR18=$((18))  #Fehler, im Verzeichnis "_update/os/install_BS" befindet sich  \b kein System(Kernel oder RootFS) für mmc oder ram
STATUS_ERR19=$((19))  #Fehler, Downgrade nicht zulaessig, es ist bereits ein neueres System installiert

PrintErrorExit()
{
   if [ ${DEBUG_ENABLE} = "1" ]; then
      echo "[DB] error $1, $2"
   fi
	echo "$(date "+%d.%m.%Y %T") error $1, $2" >> ${ERROR_LOG_FILE}
	CleanupError
   exit $1
}
#--------------------
PRINT_DEBUG()
{
   if [ ${DEBUG_ENABLE} = "1" ]; then
      echo "[DB] $1"
   fi
}
#--------------------
Cleanup()
{
# Kein Image angegeben, nicht zum löschen da
   if [ -z ${IMGFILENAME} ] ; then
      return
   fi
# Dateien löschen
	rm ${IMGFILENAME}.tar
	rm ${IMGFILENAME}.signature

}
#--------------------
CleanupError()
{
   PRINT_DEBUG "cleanup, lösche image/dir"
   if [ "$ENVBOOT" -eq "1" ] ; then
      RestoreEnv
   fi
   Cleanup
   rm -r ${BSUPDATEDIR}
}
#--------------------
RestoreEnv()
{
	PRINT_DEBUG "setze Bootenv auf default"
	MyCommand=$(${USERHOMEDIR}/hw_data/hw_setup_cti -b mmc 2>&1)
	result=$?
	if [ "$result" -ne "0" ] ; then
		echo " {E R R O R} MyCommand: < ${MyCommand} >, result: ${result}"
		echo "${CurrDate}: Fehler beim Init der u-boot.env <${MyCommand}>" >> ${ERROR_LOG_FILE}
      CleanupError
		exit ${STATUS_ERR4}
	fi
	echo "Restore u-boot.env OK"

}
#--------------------
CheckDirectory()
{
# Verzeichnis erstellen, wenn es nicht existiert
	if [ ! -d ${BSUPDATEDIR} ]; then
      mkdir -p ${BSUPDATEDIR}
   fi
}
#--------------------
CheckVersionsNumber()
{
   CalcVersionString=$1
   vMaj=$(echo $CalcVersionString | awk -F. '{print $1}' | sed 's/^0*//')
   vMid=$(echo $CalcVersionString | awk -F. '{print $2}' | sed 's/^0*//')
   vMin=$(echo $CalcVersionString | awk -F. '{print $3}' | sed 's/^0*//')
   PRINT_DEBUG " Version calc(()) --> [$(($vMaj))] [$(($vMid))] [$(($vMin))]"

   if [ $(($vMaj)) -lt 3 ]; then
      PRINT_DEBUG "BS kleiner 3.x.x!"
      return $((0))
   fi
  return $((1))
#NOTE: Nur ab Versionen 03.x.x
}

#--------------------
CheckSystemVersion()
{
	while read -r line; do
	# reading each line
	case $line in
	 	*"CTI System"*)
	# Splits String, Versionsnummer extrehieren
		SUBSTRINGLEFT=${line% (erstellt*}     # alles links von  (erstellt
		BS_VERSION_NR=${SUBSTRINGLEFT#*System }     # alles rechts von Sytsem
		PRINT_DEBUG " input:  <$line>"
		PRINT_DEBUG " Version: <${BS_VERSION_NR}>"
		CURRENT_BS_VERSION=${BS_VERSION_NR}
		;;
	esac
	done < $VERSIONSFILE

	CheckVersionsNumber ${CURRENT_BS_VERSION}
	Result=$?
   if [ $Result -eq 0 ] ; then
		PrintErrorExit ${STATUS_ERR16} " ---- System Version zu alt/unbekannt <$CURRENT_BS_VERSION>! ----   \n -> Update des Betriebsystemes nicht möglich!\n"
	else
		PRINT_DEBUG "---- System Version OK <$CURRENT_BS_VERSION>! ----   \n -> Update des Betriebsystemes möglich!\n"
		echo "$(date "+%d.%m.%Y %T") ---- System Version OK <$CURRENT_BS_VERSION>! Start Update... ----" >> ${ERROR_LOG_FILE}
   fi
# das ist Test   exit $((0))

}
#--------------------
CheckFileExtract()
{
#
# signatur pruefen und tar entpacken
#
   TARFILENAME=${IMGFILENAME}.tar
	PRINT_DEBUG "Tarfile: <$TARFILENAME> "
	MyCommand=`openssl base64 -d -in ${IMGFILENAME}.signature -out /tmp/sign.sha256.bin 2>&1 `
	result=$?
	PRINT_DEBUG " ssl-result: $result"
	if [ "$result" -ne "0" ] ; then
      PrintErrorExit ${STATUS_ERR11} "create hash.bin, remove ${IMGFILENAME}.*"
	else
		PRINT_DEBUG "start verify..."
		MyCommand=`openssl dgst -sha256 -verify  ${USERHOMEDIR}/security/ctipublic.pem -signature /tmp/sign.sha256.bin ${TARFILENAME}  2>&1 `
		result=$?
		rm /tmp/sign.sha256.bin
		PRINT_DEBUG " verify result $result"
		if [ "$result" -ne "0" ] ; then
			PrintErrorExit ${STATUS_ERR12} "signatur verify failed"
		fi
	fi

	PRINT_DEBUG "tarfile is valid"
# entpacken
   PRINT_DEBUG " cmd < tar -x -f ${TARFILENAME} -C ${BSUPDATEDIR}>"
	MyErrorMessage=$(tar -x -f ${TARFILENAME} -C ${BSUPDATEDIR}  2>&1)
	result=$?
	if [ "$result" -eq "0" ] ; then
		PRINT_DEBUG " tar entpacken: ok \n"
	else
		PrintErrorExit ${STATUS_ERR13} "Fehler bei SystemUpdate <$MyErrorMessage> $result"
	fi
}
#--------------------
CheckNewImages()
{
# überprüfen om Ram und MMC Image vorhanden sind
   PRINT_DEBUG "prüfe RamImage ..."
   # Teste Kernel
   if [ -s ${BSUPDATEDIR}/ram_image/uImage ] ; then
      PRINT_DEBUG "RAM Kernel vorhanden "
   else
      PrintErrorExit ${STATUS_ERR18} "Fehler, Ram Kernel nicht gefunden "
   fi
   # Teste rootfs
   if [ -s ${BSUPDATEDIR}/ram_image/rootfs.cpio.uboot ] ; then
      PRINT_DEBUG "RAM RootFS vorhanden "
   else
      PrintErrorExit ${STATUS_ERR18} "Fehler, Ram RootFS nicht gefunden "
   fi
   PRINT_DEBUG "prüfe MMCImage ..."
   # Teste Kernel
   if [ -s ${BSUPDATEDIR}/mmc_image/uImage ] ; then
      PRINT_DEBUG "MMC Kernel vorhanden "
   else
      PrintErrorExit ${STATUS_ERR18} "Fehler, MMC Kernel nicht gefunden "
   fi
   # Teste rootfs
   if [ -s ${BSUPDATEDIR}/mmc_image/rootfs.tar ] ; then
      PRINT_DEBUG "MMC RootFS vorhanden "
   else
      PrintErrorExit ${STATUS_ERR18} "Fehler, MMC RootFS nicht gefunden "
   fi

}
#--------------------
CheckNewImageVersion()
{
   PRINT_DEBUG "prüfe Neue Systemversion ..."
#   tar -xvf  /home/cti/Update_BS/mmc_image/rootfs.tar ./home/cti/version.txt -O > /tmp/new_version.txt
   tar -xvf  /home/cti/Update_BS/mmc_image/rootfs.tar ./home/cti/version.txt -O > ${NEW_VERSIONFILE}
	while read -r line; do
	# reading each line
	case $line in
	 	*"CTI System"*)
	# Splits String, Versionsnummer extrehieren
		SUBSTRINGLEFT=${line% (erstellt*}     # alles links von  (erstellt
		BS_VERSION_NR=${SUBSTRINGLEFT#*System }     # alles rechts von Sytsem
		PRINT_DEBUG " input:  <$line>"
		PRINT_DEBUG " Version: <${BS_VERSION_NR}>"
		NEW_BS_VERSION=${BS_VERSION_NR}
		;;
	esac
	done < $NEW_VERSIONFILE

# Test	CURRENT_BS_VERSION="03.00.07"
# Test 	NEW_BS_VERSION="03.00.04"
   ValueOldSystemNo=$(echo "${CURRENT_BS_VERSION}" | awk -F. '{print $1 $2 $3}' | sed 's/^0*//')
   ValueNewSystemNo=$(echo "${NEW_BS_VERSION}" | awk -F. '{print $1 $2 $3}' | sed 's/^0*//')
   PRINT_DEBUG "Old sys Version: <$ValueOldSystemNo> --> New sys Version: <$ValueNewSystemNo>"
   if [ $ValueOldSystemNo -gt $ValueNewSystemNo ] ; then
      PrintErrorExit ${STATUS_ERR19} "Es ist bereits ein neueres System installiert"
   fi

#   CalcVersionString=${CURRENT_BS_VERSION}
#   vMaj=$(echo $CalcVersionString | awk -F. '{print $1}' | sed 's/^0*//')
#   vMid=$(echo $CalcVersionString | awk -F. '{print $2}' | sed 's/^0*//')
#   vMin=$(echo $CalcVersionString | awk -F. '{print $3}' | sed 's/^0*//')
#   PRINT_DEBUG " Version calc(()) --> [$(($vMaj))] [$(($vMid))] [$(($vMin))]"

#   if [ $(($vMaj)) -lt 3 ]; then
#      PRINT_DEBUG "BS kleiner 3.x.x!"
#      return $((0))
#   fi
#  return $((1))

#   VERSIONSFILE=${USERHOMEDIR}/version.txt

#blah blah
}
#--------------------
InstallSystemPatches()
{
#  mit update alle Patche installieren
   chmod +x ${BSUPDATEDIR}/system_patches/systempatch.sh
	${BSUPDATEDIR}/system_patches/systempatch.sh update
	ReturnValue=$?
	if [ $ReturnValue -eq "0" ]; then
		PRINT_DEBUG "Erfolg exec: [install Patches]\n"
	else
      PrintErrorExit ${STATUS_ERR17} "[install Patches] nicht erfolgreich\n"
	fi
}
#--------------------
SetupEnv()
{
# Archiv entpackt, setze Bootargs & reboot
# Einrichtung Bootargs,  wenn Datei nicht existiert muss init erfolgen
	if [ ! -f ${USERHOMEDIR}/stamp_updateable ]; then
		MyCommand=$(${USERHOMEDIR}/hw_data/hw_setup_cti -b init 2>&1)
		result=$?
		if [ "$result" -ne "0" ] ; then
         PRINT_DEBUG "{E R R O R} MyCommand: < ${MyCommand} >, result: ${result}"
      PrintErrorExit ${STATUS_ERR14} "$(date "+%d.%m.%Y %T") Fehler beim Init der u-boot.env <${MyCommand}>"
		fi
		PRINT_DEBUG "Init u-boot.env OK"
		touch ${USERHOMEDIR}/stamp_updateable
	fi
	MyCommand=$(${USERHOMEDIR}/hw_data/hw_setup_cti -b ram 2>&1)
	result=$?
	if [ "$result" -ne "0" ] ; then
      PRINT_DEBUG "{E R R O R} MyCommand: < ${MyCommand} >, result: ${result}"
		PrintErrorExit ${STATUS_ERR15}	"$(date "+%d.%m.%Y %T") Fehler beim Setzen der u-boot.env <${MyCommand}>"
	fi
	PRINT_DEBUG "bereit zur installation ... (env done)"
	ENVBOOT=1

}
#---------
InstallUpdate()
{
   IMGFILENAME=$1
   CheckSystemVersion
   if [ -z ${IMGFILENAME} ] ; then
      PrintErrorExit ${STATUS_ERR3} "kein Tar angegeben, nichts zu prüfen und entpacken "
   else
      CheckDirectory
      CheckFileExtract
   fi
   CheckNewImages
   CheckNewImageVersion
#echo "Emulation done"
#exit $((0))
   InstallSystemPatches
   SetupEnv
   Cleanup
   PRINT_DEBUG "all ok, reboot needed..."
   exit ${STATUS_OK}
# macht netcoreapp:   reboot
}
#====================
# main case ...
#====================
#echo "[DB] sp: <$SCRIPT_PATH> pwd: `pwd`"
DEBUG_ENABLE=$(($1))
echo "[Info]InstallUpdate $2, (Debug=$DEBUG_ENABLE)\n"

InstallUpdate "$2"
exit $?
