import cti_module 1.0

Rectangle{
   id:         _mainLayout;
   FontLoader { id: fontReg;      source: "../../fonts/OpenSans-Regular.ttf" }
   FontLoader { id: fontSemiBold; source: "../../fonts/OpenSans-SemiBold.ttf" }
   FontLoader { id: fontLatoBold; source: "../../fonts/Lato-Bold.ttf" }
   FontLoader { id: fontLatoReg; source: "../../fonts/Lato-Regular.ttf" }

   property bool g_enableDebug: false
   width:   displaywidth;     // displaywidth = von hardware gesetzt
   height:  displayheight;    // displayheight = von hardware gesetzt
   color:   colorBackground;


   property bool   scrollEnabled:            true;
   property bool   desingnTouch:             false;
   property bool   scaleEnabled:             false;
   property int    fontPixelSizeInput:       22+10*scaleEnabled;
   property int    layoutScaleOffset:        0 + 8*mainLayout.scaleEnabled

   property bool   sysinfovisible:           false;
   property bool   gKeyboard_enabled:        false;
   property bool   analogClock:              false;
//   property bool   analogClock:              true;
      //Hilfslinien
   property bool   showHelpLines:            false;
   property bool   showHelpGrid:             false;

   property bool   automatikModusVisible:    false;
   property bool   automatikModusActive:     true; // wenn false,dann manual Modus


   property alias globalBackgroundImageSource: _globalBackgroundImage.source
   property alias globalBackgroundImagevisible: _globalBackgroundImage.visible

   property string fontRegular_Source:    fontReg.source;
   property string fontSemiBold_Source:   fontSemiBold.source;

   // Customizeable Properties
   property string customLocale :            "de_DE";

   property string colorBackground:          "#000000";

   property string defaultTextColor:         "#BABDBD"// original: "#B6C0C6";, TouchStatus #BABABA
   property string defaultActivColor:        "#2196F3"
   property string defaultButtonFillColor:   "#464545"   // old"#66777777";

   property string colorText:                defaultTextColor
   property string colorActive:              defaultActivColor
   property string listButtonFillColor:      defaultButtonFillColor
   property string listButtonTextColor:      defaultActivColor
   property string colorTextDateTime:        colorText

   property string colorButtonFrame:         colorActive
   property string colorTextStatus:          defaultTextColor;

   property string controlButtonTextColor:      colorText
   property string controlButtonBorderColor:    colorText
   property string buttonSelectedColor:         colorActive

   property string automatikAktivColor:         colorActive
   property string automatikInaktivColor:       colorText
   property string colorClockLarge:             defaultTextColor

   //Styledefinitonen
   property string fontFamilyRegular:        fontReg.name;
   property string fontFamilySemiBold:       fontSemiBold.name;
   property string fontFamilyLatoBold:       fontLatoBold.name;
   property string fontFamilyLatoReg:        fontLatoReg.name;

   property int   fontPixelSizeDefault:     18;
   property int   fontPixelSizeSmall:       12;
   property int   controlButtonFrameWidth:  2;
   property int   bottonFrameRadius:         0
   property int   bottonFrameWidth:          5
   property int   fontPixelSizeStatus:       fontPixelSizeDefault
   property int   fontPixelSizeKeyText:      18 //Textgroesse auch in TouchButtons per default

   property string colorKeyPadText:          "white";

   property string textControlButton_Info:    "Info"
   property string textControlButton_Clear:   "Clear"
   property string textControlButton_Home:    "Home"
   property string textControlButton_OK:      "OK"
   property string textControlButton_Yes:     "Ja"
   property string textControlButton_No:      "Nein"
   property string textControlButton_Auto:    "Automatik Modus"
   property string textControlButton_Manual:  "Manueller Modus"
   property string textStatusMessage:         ""

   /// Nur Touch
   property bool  listColorAlternate:         true
   property int   listNumColumn:              1
   property int   listCellSpacing:            5
   property int   bookingNumColumn:           2
//   property int g_iListCellHeight: 82 // bei 2 Spalten
//   property int g_iListCellHeight: 41 // bei 1 Spalte
    property int   listCellHeight:           58*listNumColumn
   property int   bookCellSpacing:           10+10*scaleEnabled

   property var messageAreaTextAlign:        Text.AlignHCenter
   property var callToActionTextAlign:       Text.AlignHCenter
   property int widthCallToAction:           3*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace;
   property int heightCallToAction:          mainLayout.layoutCellHeight + 2*mainLayout.layoutCellSpace ;
   property int callToActionTopMargin:       0
   property int touchButtonImageSizeDefault: 64 + 8
   property int keyRepeatValue:              4000



   property bool  inputNumberPage_visible:         false
//    property string inputNumberField_text:          ""
//    property bool inputNumberTextField_readOnly:    false
   property bool passwordMode:                     false
   property string inputNumberreg_exp:             "^[0-9,]+$"
   property string inputNumberTxtMessage:          ""
   property string inputNumberCallToActiontext:    ""

   property bool  inputTextPage_visible:           false
   property string inputTextTxtMessage:            ""
   property string inputTextCallToAction_text:     ""
   property string inputTextreg_exp:               ".*"
   property bool  inputTextDigitsOnly:             false

   // Pin eingabe Page
   property bool inputPINPage_visible:            false
   property string inputPinTxtMessage:             ""
   property string inputPinCallToActiontext:       ""
   property int iMinInputPin: 4
   property int iMaxInputPin: 7

   property bool enrollFinger_visible:             false

   property string homeCompanyLogo_source:   ""
   property string homeCallToAction_text:              mainLayout.homeCallToAction_text;
   property string homePinCallToAction_text:           mainLayout.homePinCallToAction_text;


   property string clockImageSecond_source:  "clockimgages/second.png"
   property string clockImageMinute_source:  "clockimgages/minute.png"
   property string clockImageHour_source:    "clockimgages/hour.png"
   property string clockImageFace_source:    "clockimgages/clock-face.png"
   property string clockImagePoint_source:   "clockimgages/point.png"




   AnimatedImage
   {
      id: _globalBackgroundImage
      width: parent.width
      height: parent.height
      anchors.horizontalCenter: parent.horizontalCenter

   }

}
