﻿import QtQuick 2.12
import QtQuick.Window 2.0
import QtQuick.Layouts 1.0
import QtQuick.Controls 2.5
import Features 1.0


import cti_module 1.0
import 'styles'
import 'forms'
import 'scripts'

Window
{
   width: 850
   height: 850
   title: "Timi3 Simulator"
   objectName: "Main_Window";
   visible: true
   id: _mainWindow

   DefaultStyleSimulator {
      id:      mainLayout
   }

   Timer {
      id: timer
   }

   function delay(delayTime, cb) {
      timer.interval = delayTime;
      timer.repeat = false;
      timer.triggered.connect(cb);
      timer.start();
   }

   Component.onCompleted: {
      delay(10000, function() {
         console.log("qml: boot")
            modelV2.boot()
      })
   }

   SignalsModelV2 {
      id: modelV2

      onCustomSignal: function(propertyName, propertyValue) {
         console.log("qml: onCustomSignal fired. propertyName=" + propertyName + " propertyValue=" + propertyValue);
            //cast to boolean
            if(propertyName.endsWith("_visible")) {
               propertyValue = (propertyValue == 'true');
            }
            if(propertyName.endsWith("_enable")) {
               propertyValue = (propertyValue == 'true');
            }
            if(propertyName.endsWith("_active")) {
               propertyValue = (propertyValue == 'true');
            }
            //mainLayout[propertyName]= propertyValue;
               _mainWindow[propertyName]= propertyValue;

      }
   }

   QmlListItemCollection {
      id: elementModeldataListBook;
      Component.onCompleted: { 
        //_mainWindow.bookingButtonList_list.model = Net.toListModel(elementModeldataListBook.collection) 
        //_mainWindow.set_bookingData.model = Net.toListModel(elementModeldataListBook.collection) 

        //console.log("QmlListItemCollection elementModeldataListBook: onCompleted")
        
      }
      onCustomSignal2: function() {
            //_mainWindow.bookingButtonList_list.model = Net.toListModel(elementModeldataListBook.collection)
            //_mainWindow.set_bookingData.model = Net.toListModel(elementModeldataListBook.collection)
            //console.log("QmlListItemCollection elementModeldataListBook: onCustomSignal2")
      }

   }

   Image {
      id: tastaturlayout
      source: "../images/tastaturlayout";
      verticalAlignment:Image.AlignVCenter
      horizontalAlignment:Image.AlignHCenter
   }

   RoundButton {
            id:key1_1
            x: 82
            y: 235
            width: 60
            height: 60
            text: "1,1"
            opacity: 0.2
            visible: true
            antialiasing: false
            z: 2
            radius:50
            onClicked: {
               modelV2.keyPressed("BookKommen", 1075); //Key1_1
            }
      }

   RoundButton {
            id:key1_2
            text: "1,2"
            opacity: 0.2
            visible: true
            z: 3
            x: 706
            y: 235
            width: 60
            height: 60
            radius:50
            onClicked: {
               modelV2.keyPressed("BookGehen",1071); //key1_2
            }
      }

   RoundButton {
            id:key2_1
            text: "2,1"
            opacity: 0.2
            visible: true
            z: 4
            x: 82
            y: 355
            width: 60
            height: 60
            radius:50
            onClicked: {
               modelV2.keyPressed("BookPausenbeginn", 1066); //key2_1
            }
      }

   RoundButton {
            id:key2_2
            text: "2,2"
            opacity: 0.2
            visible: true
            z: 5
            x: 706
            y: 355
            width: 60
            height: 60
            radius:50
            onClicked: {
               modelV2.keyPressed("BookPausenende", 1069); //key2_2
            }
      }

   RoundButton {
      id: btnTransponderSend
      x:363
      y: 645
      width: 125
      height: 125
      text: 'Transponder Presented'
      opacity: 0.2
      z: 6
      onClicked: {
            modelV2.transponderPresented(tId.text)
      }
   }


   RoundButton {
      id: btnPinSend
      x:563
      y: 645
      width: 125
      height: 125
      text: 'PIN absenden'
      opacity: 0.8
      z: 6;
      visible: (mainLayout.iMinInputPin)
      onClicked: {
            modelV2.pinEntered(tPin.text)
      }
   }

   Button {
      id: btn_c
      x: 185
      y: 497
      width: 89
      height: 40
      text: qsTr("c")
      opacity: 0.2
      z: 7
      onClicked: {
               modelV2.keyPressed("ControlCancel",1067) //btn_c
            }
   }

   Button {
      id: btn_up
      x: 280
      y: 497
      width: 94
      height: 40
      text: qsTr("up")
      opacity: 0.2
      z: 8
      onClicked: {
               modelV2.keyPressed("ControlUp", 1072); //btn_up
            }
   }

   Button {
      id: btn_down
      x: 375
      y: 497
      width: 99
      height: 40
      text: qsTr("down")
      opacity: 0.2
      z: 9
      onClicked: {
               modelV2.keyPressed("ControlDown", 1082); //btn_down
            }
   }

   Button {
      id: btn_ok
      x: 473
      y: 497
      width: 98
      height: 40
      text: qsTr("ok")
      opacity: 0.2
      z: 10
      onClicked: {
               modelV2.keyPressed("ControlOk", 1079) //btn_ok
            }
   }

   Button {
      id: btn_pin_request
      x: 671
      y: 497
      width: 98
      height: 40
      text: qsTr("Pin")
      opacity: 1
      z: 12
      onClicked: {
               modelV2.keyPressed("ControlPinDialog", 10)
            }
   }

   Button {
      id: btn_transponder_request
      x: 771
      y: 497
      width: 98
      height: 40
      text: qsTr("Transponder")
      opacity: 1
      z: 13
      onClicked: {
               modelV2.keyPressed("ControlTransponderDialog", 11)
            }
   }


   Button {
      id: btn_info
      x: 571
      y: 497
      width: 83
      height: 40
      text: qsTr("info")
      opacity: 0.2
      z: 11

      MouseArea {
            anchors.fill: parent

         onClicked: {
            modelV2.keyPressed("ControlInfo", 1073) //btn_info
         }

            onPressAndHold: {
               modelV2.keyPressedAndHold("ControlInfo", 1073) //btn_info
            }

      }

   }

   Rectangle {
      id: tId
      radius: 10
      width: 100
      height: 25
      anchors.horizontalCenter: parent.horizontalCenter;
      y: 800
      property alias text: txtId.text

      TextInput {
            id: txtId
            anchors.margins: 5
            anchors.fill: parent
            text: "80440FFA5B2604"
            horizontalAlignment: Text.AlignHCenter
            color: "white"

            onEditingFinished:  modelV2.transponderPresented(text)
      }
   }

   Rectangle {
      id: tPin
      radius: 10
      width: 100
      height: 25
      anchors.horizontalCenter: btnPinSend.horizontalCenter;
      y: 800;
      visible: (mainLayout.iMinInputPin)
      property alias text: txtPin.text

      TextInput {
            id: txtPin
            anchors.margins: 5
            anchors.fill: parent
            text: "1979"
            horizontalAlignment: Text.AlignHCenter
            color: "green"

            onEditingFinished:  modelV2.pinEntered(text)
      }
   }

   // hier Timi3 spezifisches

   property alias sysinfoGlobalPagevisible:  mainLayout.sysinfovisible;
   property int global_visible_Status: 0

   property alias setScaleTouchLayout:             mainLayout.scaleEnabled
   property alias globalColorBackground:              mainLayout.colorBackground

   property alias globalBackground_source:         mainLayout.globalBackgroundImageSource
   property alias globalBackgroundImage_visible:   mainLayout.globalBackgroundImagevisible
   property alias globalKeyboard_enabled:          mainLayout.gKeyboard_enabled

   property alias symbolLan:       g_symbolPanel.iconLanName
   property alias symbolwireless:  g_symbolPanel.iconWirelessName
   property alias symbolVPN:       g_symbolPanel.iconVPNName
   property alias symbolBC:        g_symbolPanel.iconBCName

   property alias customLocale:    mainLayout.customLocale;

   property alias globalKeyRepeatValue:            mainLayout.keyRepeatValue;
   property alias globalColorText:                 mainLayout.colorText;
   property alias globalColorActive:               mainLayout.colorActive
   property alias globalColorTextStatus:           mainLayout.colorTextStatus
   property alias globalListButtonFillColor:       mainLayout.listButtonFillColor
   property alias globalColorClockLarge:           mainLayout.colorClockLarge
   property alias globalListButtonTextColor:       mainLayout.listButtonTextColor

   property alias globalSetAnalogClock_enable:     mainLayout.analogClock;

   property alias sharedStatusClock_visible:    _sharedStatusClock.visible;
   property alias sharedTxtStatusMsgLeft_text:  _sharedTxtStatusMsgLeft.text;
   property alias sharedBusyIndicator_enable:   _sharedBusyIndicator.running;

   // Pageproperties
   property alias boot_visible: bootPage.visible;
   property alias bootTxtMessage_text: bootPage.bootTxtMessage;

   property alias enrollFingerprintPage_text:      enrollFingerprintPage.enrollFingerprintMessage;
   property alias enrollfingerprint_text:          enrollFingerprintPage.enrollFingerprintMessage;
   property alias enrollfingerprint_visible:       enrollFingerprintPage.visible;

   property alias enrollFingerprintOTPMessage_text: enrollFingerprintOTPPage.enrollFingerprintOTPMessage
   property alias enrollFingerprintOTPHeader_text:  enrollFingerprintOTPPage.enrollFingerprintOTPHeader
   property alias enrollfingerprintotp_visible:     enrollFingerprintOTPPage.visible;

   property alias enrollFinger_visible:               mainLayout.enrollFinger_visible

   property alias bootdata_visible: bootDataPage.visible;
   property alias bootDataTxtMessage_text: bootDataPage.bootDataTxtMessage;

   property alias booking_visible: bookingPage.visible;
   property alias bookingTxtMessage_text: bookingPage.bookingTxtMessage
   property alias bookingCallToAction_text: bookingPage.bookingCallToAction;
   property alias set_bookingSource:                  bookingPage.bookingModelSource;
   property alias set_bookingData:                    bookingPage.bookingModelData;
   property alias set_bookingQuery:                   bookingPage.bookingModelQuery;

   property alias bookingdoublequestion_visible: bookingdoublequestionPage.visible;
   property alias bookingDoubleQuestionTxtMessage_text: bookingdoublequestionPage.bookingDoubleQuestionTxtMessage_text;
   property alias bookingDoubleQuestionCallToAction_text: bookingdoublequestionPage.bookingDoubleQuestionCallToAction;

   property alias home_visible:                       homePage.visible;
   property alias homepin_visible:                    homePinPage.visible;
   property alias homeCompanyLogo_source:             mainLayout.homeCompanyLogo_source;
   property alias homeCallToAction_text:              mainLayout.homeCallToAction_text;
   property alias homePinCallToAction_text:           mainLayout.homePinCallToAction_text;
   property alias homeFingerEnrollButton_text:     homePage.homeFingerEnrollButton_text;

   property alias  set_textControlButton_Clear:        mainLayout.textControlButton_Clear;
   property alias  set_textControlButton_OK:        mainLayout.textControlButton_OK;
   property alias  set_textControlButton_Info:        mainLayout.textControlButton_Info;
   property alias  set_textControlButton_Home:        mainLayout.textControlButton_Home;
   property alias  set_textControlButton_Yes:        mainLayout.textControlButton_Yes;
   property alias  set_textControlButton_No:        mainLayout.textControlButton_No;

   property alias  set_textControlButton_Auto:        mainLayout.textControlButton_Auto
   property alias  set_textControlButton_Manual:      mainLayout.textControlButton_Manual
   property alias  set_automatikModus_visible:         mainLayout.automatikModusVisible
   property alias  set_automatikModus_active:          mainLayout.automatikModusActive

   property alias confirmerror_visible:               confirmErrorPage.visible;
   property alias confirmerrorTxtMessage_text:        confirmErrorPage.confirmErrorTxtMessage;
   property alias confirmerrorImgCalltoAction_source: confirmErrorPage.confirmErrorImgCallToAction_source;

   property alias selectlist_visible:                 selectListPage.visible;
   property alias selectlistTxtMessage_text:          selectListPage.selectListTxtMessage;
   property alias selectlistCallToAction_text:        selectListPage.selectListCallToAction;
   property alias set_selectlistSource:               selectListPage.selectListModelSource;
   property alias set_selectListData:                 selectListPage.selectListModelData;
   property alias set_selectListQuery:                selectListPage.selectListModelQuery;

   property alias inputtext_visible:                  mainLayout.inputTextPage_visible
   property alias inputtextTextMessage_text:          mainLayout.inputTextTxtMessage
   property alias inputtextCallToAction_text:         mainLayout.inputTextCallToAction_text
   property alias inputtextTextFieldReg_exp:          mainLayout.inputTextreg_exp
   property alias inputtext_DigitsOnly:               mainLayout.inputTextDigitsOnly
   property alias inputtextTextField_readonly:        inputTextPage.inputTextField_readOnly
   property alias inputtextTextField_text:            inputTextPage.inputTextField_text

   property alias inputnumber_visible:                mainLayout.inputNumberPage_visible
   property alias inputnumberTextField_text:          inputNumberPage.inputNumberField_text
   property alias inputnumberCallToAction_text:       mainLayout.inputNumberCallToActiontext 
   property alias inputnumberTextField_readonly:      inputNumberPage.inputNumberTextField_readOnly
   property alias inputnumber_seperator:              inputNumberPage.inputNumber_seperator
   property alias inputnumberReg_exp:                 mainLayout.inputNumberreg_exp

  // property alias project_saldo_fg_Page_visible: project_saldo_fg_Page.visible 
  // property alias list_textHeadCenter: project_saldo_fg_Page.textheadLine

//	property alias lowerPanel_visible: lowerPanel.visible


   property alias employeemessages_visible: employeeMessagesPage.visible;
   property alias employeeMessagesTxtMessage_text: employeeMessagesPage.employeeMessages_Message_text;
   property alias employeeMessagesMessageTime_text: employeeMessagesPage.employeeMessages_MessageTime_text;
   property alias employeeMessagesStatusRight_text: employeeMessagesPage.employeeMessages_StatusRight_text;

   property alias sysinfoidentity_visible: sysinfoidentityPage.visible;
   property alias sysinfoidentity_li0_name: sysinfoidentityPage.li0_name;
   property alias sysinfoidentity_li0_value: sysinfoidentityPage.li0_value;
   property alias sysinfoidentity_li1_name: sysinfoidentityPage.li1_name;
   property alias sysinfoidentity_li1_value: sysinfoidentityPage.li1_value;
   property alias sysinfoidentity_li2_name: sysinfoidentityPage.li2_name;
   property alias sysinfoidentity_li2_value: sysinfoidentityPage.li2_value;
   property alias sysinfoidentity_li3_name: sysinfoidentityPage.li3_name;
   property alias sysinfoidentity_li3_value: sysinfoidentityPage.li3_value;
   property alias sysinfoidentity_li4_name: sysinfoidentityPage.li4_name;
   property alias sysinfoidentity_li4_value: sysinfoidentityPage.li4_value;
   property alias sysinfoidentity_li5_name: sysinfoidentityPage.li5_name;
   property alias sysinfoidentity_li5_value: sysinfoidentityPage.li5_value;
   property alias sysinfoidentity_li6_name: sysinfoidentityPage.li6_name;
   property alias sysinfoidentity_li6_value: sysinfoidentityPage.li6_value;
   property alias sysinfoidentity_cellCountName: sysinfoidentityPage.cellCountName;
   property alias sysinfoidentity_cellCountValue: sysinfoidentityPage.cellCountValue;

   property alias sysinfonetwork_visible: sysinfonetworkPage.visible;
   property alias sysinfonetwork_li0_name: sysinfonetworkPage.li0_name;
   property alias sysinfonetwork_li0_value: sysinfonetworkPage.li0_value;
   property alias sysinfonetwork_li1_name: sysinfonetworkPage.li1_name;
   property alias sysinfonetwork_li1_value: sysinfonetworkPage.li1_value;
   property alias sysinfonetwork_li2_name: sysinfonetworkPage.li2_name;
   property alias sysinfonetwork_li2_value: sysinfonetworkPage.li2_value;
   property alias sysinfonetwork_li3_name: sysinfonetworkPage.li3_name;
   property alias sysinfonetwork_li3_value: sysinfonetworkPage.li3_value;
   property alias sysinfonetwork_li4_name: sysinfonetworkPage.li4_name;
   property alias sysinfonetwork_li4_value: sysinfonetworkPage.li4_value;
   property alias sysinfonetwork_li5_name: sysinfonetworkPage.li5_name;
   property alias sysinfonetwork_li5_value: sysinfonetworkPage.li5_value;
   property alias sysinfonetwork_li6_name: sysinfonetworkPage.li6_name;
   property alias sysinfonetwork_li6_value: sysinfonetworkPage.li6_value;
   property alias sysinfonetwork_cellCountName: sysinfonetworkPage.cellCountName;
   property alias sysinfonetwork_cellCountValue: sysinfonetworkPage.cellCountValue;

   property alias sysinfoconfiguration_visible: sysinfoconfigurationPage.visible;
   property alias sysinfoconfiguration_li0_name: sysinfoconfigurationPage.li0_name;
   property alias sysinfoconfiguration_li0_value: sysinfoconfigurationPage.li0_value;
   property alias sysinfoconfiguration_li1_name: sysinfoconfigurationPage.li1_name;
   property alias sysinfoconfiguration_li1_value: sysinfoconfigurationPage.li1_value;
   property alias sysinfoconfiguration_li2_name: sysinfoconfigurationPage.li2_name;
   property alias sysinfoconfiguration_li2_value: sysinfoconfigurationPage.li2_value;
   property alias sysinfoconfiguration_li3_name: sysinfoconfigurationPage.li3_name;
   property alias sysinfoconfiguration_li3_value: sysinfoconfigurationPage.li3_value;
   property alias sysinfoconfiguration_li4_name: sysinfoconfigurationPage.li4_name;
   property alias sysinfoconfiguration_li4_value: sysinfoconfigurationPage.li4_value;
   property alias sysinfoconfiguration_li5_name: sysinfoconfigurationPage.li5_name;
   property alias sysinfoconfiguration_li5_value: sysinfoconfigurationPage.li5_value;
   property alias sysinfoconfiguration_li6_name: sysinfoconfigurationPage.li6_name;
   property alias sysinfoconfiguration_li6_value: sysinfoconfigurationPage.li6_value;
   property alias sysinfoconfiguration_cellCountName: sysinfoconfigurationPage.cellCountName;
   property alias sysinfoconfiguration_cellCountValue: sysinfoconfigurationPage.cellCountValue;

   property alias sysinfostate_visible: sysinfostatePage.visible;
   property alias sysinfostate_li0_name: sysinfostatePage.li0_name;
   property alias sysinfostate_li0_value: sysinfostatePage.li0_value;
   property alias sysinfostate_li1_name: sysinfostatePage.li1_name;
   property alias sysinfostate_li1_value: sysinfostatePage.li1_value;
   property alias sysinfostate_li2_name: sysinfostatePage.li2_name;
   property alias sysinfostate_li2_value: sysinfostatePage.li2_value;
   property alias sysinfostate_li3_name: sysinfostatePage.li3_name;
   property alias sysinfostate_li3_value: sysinfostatePage.li3_value;
   property alias sysinfostate_li4_name: sysinfostatePage.li4_name;
   property alias sysinfostate_li4_value: sysinfostatePage.li4_value;
   property alias sysinfostate_li5_name: sysinfostatePage.li5_name;
   property alias sysinfostate_li5_value: sysinfostatePage.li5_value;
   property alias sysinfostate_li6_name: sysinfostatePage.li6_name;
   property alias sysinfostate_li6_value: sysinfostatePage.li6_value;
   property alias sysinfostate_cellCountName: sysinfostatePage.cellCountName;
   property alias sysinfostate_cellCountValue: sysinfostatePage.cellCountValue;

   property alias sysinfotransponder_visible: sysinfotransponderPage.visible;
   property alias sysinfotransponder_li0_name: sysinfotransponderPage.li0_name;
   property alias sysinfotransponder_li0_value: sysinfotransponderPage.li0_value;
   property alias sysinfotransponder_li1_name: sysinfotransponderPage.li1_name;
   property alias sysinfotransponder_li1_value: sysinfotransponderPage.li1_value;
   property alias sysinfotransponder_li2_name: sysinfotransponderPage.li2_name;
   property alias sysinfotransponder_li2_value: sysinfotransponderPage.li2_value;
   property alias sysinfotransponder_li3_name: sysinfotransponderPage.li3_name;
   property alias sysinfotransponder_li3_value: sysinfotransponderPage.li3_value;
   property alias sysinfotransponder_li4_name: sysinfotransponderPage.li4_name;
   property alias sysinfotransponder_li4_value: sysinfotransponderPage.li4_value;
   property alias sysinfotransponder_li5_name: sysinfotransponderPage.li5_name;
   property alias sysinfotransponder_li5_value: sysinfotransponderPage.li5_value;
   property alias sysinfotransponder_li6_name: sysinfotransponderPage.li6_name;
   property alias sysinfotransponder_li6_value: sysinfotransponderPage.li6_value;
   property alias sysinfotransponder_cellCountName: sysinfotransponderPage.cellCountName;
   property alias sysinfotransponder_cellCountValue: sysinfotransponderPage.cellCountValue;

   property alias sysinfomobilfunk_visible: sysinfomobilfunkPage.visible;
   property alias sysinfomobilfunk_li0_name: sysinfomobilfunkPage.li0_name;
   property alias sysinfomobilfunk_li0_value: sysinfomobilfunkPage.li0_value;
   property alias sysinfomobilfunk_li1_name: sysinfomobilfunkPage.li1_name;
   property alias sysinfomobilfunk_li1_value: sysinfomobilfunkPage.li1_value;
   property alias sysinfomobilfunk_li2_name: sysinfomobilfunkPage.li2_name;
   property alias sysinfomobilfunk_li2_value: sysinfomobilfunkPage.li2_value;
   property alias sysinfomobilfunk_li3_name: sysinfomobilfunkPage.li3_name;
   property alias sysinfomobilfunk_li3_value: sysinfomobilfunkPage.li3_value;
   property alias sysinfomobilfunk_li4_name: sysinfomobilfunkPage.li4_name;
   property alias sysinfomobilfunk_li4_value: sysinfomobilfunkPage.li4_value;
   property alias sysinfomobilfunk_li5_name: sysinfomobilfunkPage.li5_name;
   property alias sysinfomobilfunk_li5_value: sysinfomobilfunkPage.li5_value;
   property alias sysinfomobilfunk_li6_name: sysinfomobilfunkPage.li6_name;
   property alias sysinfomobilfunk_li6_value: sysinfomobilfunkPage.li6_value;
   property alias sysinfomobilfunk_cellCountName: sysinfomobilfunkPage.cellCountName;
   property alias sysinfomobilfunk_cellCountValue: sysinfomobilfunkPage.cellCountValue;

   property alias inputpin_visible:                   mainLayout.inputPINPage_visible
   property alias inputPinTxtMessage_text:            mainLayout.inputPinTxtMessage
   property alias inputPinCallToAction_text:          mainLayout.inputPinCallToActiontext
   property alias inputpin_Min:                       mainLayout.iMinInputPin
   property alias inputpin_Max:                       mainLayout.iMaxInputPin

   property alias setClockImageFace_source:     mainLayout.clockImageFace_source;
   property alias setClockImageSecond_source:   mainLayout.clockImageSecond_source;
   property alias setClockImageMinute_source:   mainLayout.clockImageMinute_source;
   property alias setClockImageHour_source:     mainLayout.clockImageHour_source;
   property alias setClockImagePoint_source:    mainLayout.clockImagePoint_source;

   signal qmlkeypressSignaltolib(string text, int iKey, int iType)

   function receiveButtonfromlib(buttonpressed, type )//, buttonID) 
   {
      // NOTE: Taste an QML Seiten mit Listview weiterleiten
      if(booking_visible == true )
         return  bookingPage.receiveButtonfromlib(buttonpressed, type)//, buttonID) 

      if(project_saldo_fg_Page_visible == true )
         return  project_saldo_fg_Page.receiveButtonfromlib(buttonpressed, type)//, buttonID) 

      qmlkeypressSignaltolib("hardware", buttonpressed, type)
//        console.log("---qml Hardware key to lib--->", buttonpressed)
      return 0
   }

   function setGlobalVisible(bvalue)
   {
      if(bvalue)
         global_visible_Status++;
      else
         global_visible_Status--;
      if(global_visible_Status)
         sysinfoGlobalPagevisible = true
      else
         sysinfoGlobalPagevisible = false
   }
   onSysinfoidentity_visibleChanged: {
      setGlobalVisible(sysinfoidentity_visible)
   }
   onSysinfonetwork_visibleChanged: {
      setGlobalVisible(sysinfonetwork_visible)
   }
   onSysinfoconfiguration_visibleChanged: {
      setGlobalVisible(sysinfoconfiguration_visible)
   }
   onSysinfostate_visibleChanged: {
      setGlobalVisible(sysinfostate_visible)
   }
   onSysinfotransponder_visibleChanged: {
      setGlobalVisible(sysinfotransponder_visible)
   }
   HelpGrid {
      id: helpGrid;
   }

   CTIBusyIndicator {
      id:             _sharedBusyIndicator;
      anchors.fill:   mainLayout;
   }

   StatusText {
      id:                 _sharedTxtStatusMsgLeft;
      anchors.leftMargin: mainLayout.statusMargin
      anchors.top:        mainLayout.top
      anchors.left:       mainLayout.left;

   }

   ClockSmall {
      id:                 _sharedStatusClock;
      anchors.rightMargin: mainLayout.statusMargin
      anchors.right:      mainLayout.right
      anchors.top:        mainLayout.top
   }

   Boot {
      id: bootPage;
   }

   EnrollFingerprint {
      id: enrollFingerprintPage;
   }

   
   EnrollFingerprintOTP {
      id: enrollFingerprintOTPPage;
   }
   

   BootData {
      id: bootDataPage;
   }
   BookingDoubleQuestion {
      id: bookingdoublequestionPage;
   }

   Booking {
      id: bookingPage;

//      onVisibleChanged: {
//        if(visible) {
//            //console.log("qml: bookingPage visble");
//            mainLayout.listNumColumn = 1;
//            mainLayout.listViewScrollMode = 0;
//        }
//      }

    MouseArea {
        anchors.fill: parent
          onWheel: {
                wheel.accepted=false;
                if(wheel.angleDelta.y > 0) {
                    //console.log("qml: SelectlistPage onWheel angleDelta " + wheel.angleDelta + " BtnUp");
                    modelV2.keyPressed("ControlUp", 1072); //btn_up
                    //modelV2.keyPressed("ControlUp", 1072); //btn_up Seitenweise
                }
                else {
                    //console.log("qml: SelectlistPage onWheel angleDelta " + wheel.angleDelta + " BtnDown");
                    modelV2.keyPressed("ControlDown", 1082); //btn_down
                    //modelV2.keyPressed("ControlDown", 1082); //btn_down Seitenweise
                }
          }
    }
   }

   Home {
      id: homePage;
   }
   HomePin {
      id: homePinPage
   }

   EmployeeMessages {
      id: employeeMessagesPage;
   }
   ConfirmError {
      id: confirmErrorPage;
   }
   SymbolPanel {
      id: g_symbolPanel
      z: 99
      anchors.right:      sysinfonetworkPage.right
      anchors.top:        sysinfonetworkPage.top
      visible: sysinfoGlobalPagevisible
   }

   AutomaticPanel
   {
      id: automaticPanel;
      visible: mainLayout.automatikModusVisible
   }

   SelectList {
        id:   selectListPage

//      onVisibleChanged: {
//        if(visible) {
//            mainLayout.listNumColumn = 2;
//            mainLayout.listViewScrollMode = 0;
//        }
//      }

        MouseArea {
            anchors.fill: parent
              onWheel: {
                    wheel.accepted=false;
               
                    if(wheel.angleDelta.y > 0) {
                        //console.log("qml: SelectlistPage onWheel angleDelta " + wheel.angleDelta + " BtnUp");
                        modelV2.keyPressed("ControlUp", 1072); //btn_up
                        //modelV2.keyPressed("ControlUp", 1072); //btn_up Seitenweise
                    }
                    else {
                        //console.log("qml: SelectlistPage onWheel angleDelta " + wheel.angleDelta + " BtnDown");
                        modelV2.keyPressed("ControlDown", 1082); //btn_down
                        //modelV2.keyPressed("ControlDown", 1082); //btn_down seitenweise
                    }
              }
        }
   }

//   InputText {
//      id: inputTextPage
//   }
   InputText {
      id: inputTextPage
   }
   InputNumber   {
      id: inputNumberPage
   }
   InputPIN {
      id: inputPINPage
   }

   Sysinfo {
      id: sysinfonetworkPage;
   }
   Sysinfo {
      id: sysinfomobilfunkPage;
   }
   Sysinfo {
      id: sysinfoconfigurationPage;
   }
   Sysinfo {
      id: sysinfostatePage;
   }
   Sysinfo {
      id: sysinfoidentityPage;
   }
   Sysinfo {
      id: sysinfotransponderPage;
   }

}   // Window
