import cti_module 1.0

import QtQuick 2.12
import QtQuick.Controls 2.12


TerminalPage {
   id:        _inputPinPage;
   visible:    mainLayout.inputPINPage_visible

   TimeSmall{ // Uhr ohne Datum
      id: _time
      anchors.right:          _helpPageLeftInput.right
      anchors.topMargin:      0 + mainLayout.layoutScaleOffset
      anchors.rightMargin:    0
      visible:    mainLayout.desingnTouch
   }

   DateSmall { // nur Datum
      id: _date
      anchors.left:           _helpPageLeftInput.left
      anchors.leftMargin:     0
      anchors.topMargin:      0 + mainLayout.layoutScaleOffset
      visible:                mainLayout.desingnTouch
   }

   Rectangle{
      id:         _helpPageLeftInput
      width:      mainLayout.widthCallToAction       //
      height:     _inputPinPage.height-( 2*mainLayout.layoutTopMargin*mainLayout.desingnTouch)
      color:      "transparent"
      x:          mainLayout.layoutTopMargin*mainLayout.desingnTouch+( (mainLayout.width/2-mainLayout.widthCallToAction/2) *!mainLayout.desingnTouch)
      y:          mainLayout.layoutTopMargin*mainLayout.desingnTouch
      z:          20
      visible:    mainLayout.desingnTouch

      MessageArea {
         id:                        _inputTxtMessage;
         y:                         mainLayout.layoutCellSpace*2*mainLayout.desingnTouch+mainLayout.layoutCellHeight*!mainLayout.desingnTouch;
         horizontalAlignment :      mainLayout.messageAreaTextAlign// Text.AlignLeft;
         anchors.horizontalCenter:  _helpPageLeftInput.horizontalCenter;
         width:                     _helpPageLeftInput.width
         text:                      mainLayout.inputPinTxtMessage

      }
      CallToActionArea {
         id:                  _inputCallToAction;
         width:               _helpPageLeftInput.width
         textAlignmentH:      mainLayout.callToActionTextAlign
         height:              mainLayout.heightCallToAction
         anchors.top:         _inputTxtMessage.bottom
         anchors.topMargin:   mainLayout.callToActionTopMargin
         text:                mainLayout.inputPinCallToActiontext
      }

//debug
         Rectangle{ border.width: 2; border.color: "yellow"; anchors.fill: _inputTxtMessage; color: "transparent" ; visible: mainLayout.g_enableDebug  }
         Rectangle{ border.width: 2; border.color: "red"; anchors.fill: _inputCallToAction; color: "transparent"; visible: mainLayout.g_enableDebug  }

      ControlButton {
         myButtonId:       "FKT_Key_Clear"
         iHWKey:           1067
         text:             mainLayout.textControlButton_Home//"Home"
         width:            140
         anchors.bottom:   _helpPageLeftInput.bottom
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:          mainLayout.desingnTouch
      }
      ControlButton {
         myButtonId:       "FKT_Key_OK"
         iHWKey:           1079
         text:             mainLayout.textControlButton_OK
         width:            140
         x:                150+20
         anchors.bottom:   _helpPageLeftInput.bottom
         buttonTextColor:  mainLayout.controlButtonTextColor
         pixelSize:        mainLayout.fontPixelSizeKeyText
         visible:         false // mainLayout.desingnTouch
      }

   }
// debug
   Rectangle{ border.width: 2; border.color: "purple"; anchors.fill: _helpPageLeftInput; color: "transparent"; visible: mainLayout.g_enableDebug  }

   MessageArea {
      id:      _inputTxtMessage480;
      y:       100//mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
      z:       2
      width:    mainLayout.widthCallToAction+mainLayout.layoutCellWidth+mainLayout.layoutCellSpace*3
      height:                       mainLayout.layoutCellHeight+mainLayout.layoutCellSpace*!mainLayout.desingnTouch
      anchors.horizontalCenter:     _helpPageLeftInput.horizontalCenter;
      visible: !mainLayout.desingnTouch
      text:    mainLayout.inputNumberTxtMessage
    }
// Debug    Rectangle{      color: "transparent";  border.width: 2;  border.color: "red";  anchors.fill:  _inputTxtMessage480 }
   CallToActionArea {
      id: _inputCallToAction480;
      width:    mainLayout.widthCallToAction+mainLayout.layoutCellWidth+mainLayout.layoutCellSpace*3
      visible:  !mainLayout.desingnTouch
      text:     mainLayout.inputNumberCallToActiontext
    }
   PanelInputDigits{
      anchors.right: _inputPinPage.right
      anchors.rightMargin: mainLayout.layoutTopMargin*mainLayout.desingnTouch*!mainLayout.scaleEnabled + (!mainLayout.desingnTouch*(_inputPinPage.width/2-width/2))
      anchors.verticalCenter : _inputPinPage.verticalCenter
      anchors.verticalCenterOffset: 60*!mainLayout.desingnTouch // fuer classic, weiter oben
   }
}   // _inputPinPage
