import cti_module 1.0

import QtQuick 2.12
import QtQuick.Controls 2.12

TerminalPage {
   id: _homePage;

   property alias homeFingerEnrollButton_text : _homeEnrollFingerButtonText.text;

   function sendButtonPressed(buttonpressed)
   {
//      console.log("Homepage Button:", buttonpressed, "ignored")
     return 1
   }
   Image {
      id: _homeCompanyLogo
      x: mainLayout.layoutTopMargin;
      y: mainLayout.layoutTopMargin-mainLayout.desingnTouch*25;
      sourceSize.width:    100+mainLayout.desingnTouch*25;
      sourceSize.height:   50+mainLayout.desingnTouch*25;
      source: mainLayout.homeCompanyLogo_source
   }
   AnalogClock
   {
      width:      140 + 120*mainLayout.desingnTouch
      height:     140 + 120*mainLayout.desingnTouch
      datePosX:   10 + 30*mainLayout.desingnTouch
      dateYoffset: -40 -40*mainLayout.desingnTouch
      //y: mainLayout.layoutCellHeight //+ mainLayout.layoutCellSpace;
      anchors.bottom: _homeCallToAction.top;
      anchors.horizontalCenter: parent.horizontalCenter;
      visible: mainLayout.analogClock
   }

    ClockLarge {
      id: _homeClockLarge;
      y: mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
      anchors.horizontalCenter: parent.horizontalCenter;
      visible: !mainLayout.analogClock
   }

   CallToActionArea {
      id: _homeCallToAction;
      width:           3*mainLayout.layoutCellWidth + 2*mainLayout.layoutCellSpace +60 + 20*mainLayout.desingnTouch;
      height:          mainLayout.layoutCellHeight + 2*mainLayout.layoutCellSpace +20;
      text: mainLayout.homeCallToAction_text;
      dotLineEnabled: 0
   }

   TouchButton{ // Info, wenn lange gedrueckt
      id: _longI
      x:                   mainLayout.layoutTopMargin;
      y:                   mainLayout.layoutTopMargin-mainLayout.desingnTouch*25;
      width:               (100+mainLayout.desingnTouch*25) *2 ;
      height:              50+mainLayout.desingnTouch*25;
      iHWKey: 1073
      myButtonId:     "hardware";
      tapHandler_id.bLongPressOnly:    true
   }

   TouchButton{
      id: _ButtonPinDialog
      anchors.right:          _homePage.right;
      anchors.rightMargin:    mainLayout.layoutTopMargin;
      y:                      mainLayout.layoutTopMargin-mainLayout.desingnTouch*25;
      width:                  (100+mainLayout.desingnTouch*25)
      height:                 50+mainLayout.desingnTouch*25
      iImageWidth:            40 + 10*mainLayout.scaleEnabled  ;
      iImageHeight:           46 + 10*mainLayout.scaleEnabled  ;
      iHWKey: 1084   // Touchbutton
      myButtonId:     "FKT_Key_PIN";
      source:        globalPathToImages+"pin_eingabe_hand_48h.png"   
      visible: (mainLayout.iMinInputPin)
   }

   TouchButton{
      id: _ButtonEnrollFinger
      anchors.right:          _homePage.right;
      anchors.rightMargin:    mainLayout.layoutTopMargin;
      y:                      120;
      width:                  (100+mainLayout.desingnTouch*25)
      height:                 50+mainLayout.desingnTouch*25
      iImageWidth:            40 + 10*mainLayout.scaleEnabled  ;
      iImageHeight:           46 + 10*mainLayout.scaleEnabled  ;
      iHWKey: 1084   // Touchbutton
      myButtonId:     "FKT_Key_EnrollFinger";
      source:        globalPathToImages+"pin_eingabe_hand_48h.png"   
      visible:      (mainLayout.enrollFinger_visible)
   }
   Rectangle{ border.width: 2; border.color: "red"; anchors.fill: _ButtonEnrollFinger; color: "transparent"; visible:  (mainLayout.enrollFinger_visible)  }

    Text {
          id:      _homeEnrollFingerButtonText
          color:   "goldenrod";
          y:       70;
          anchors.right: parent.right;
          horizontalAlignment: Text.AlignRight
          anchors.rightMargin: 18
          font.pixelSize:   (mainLayout.fontPixelSizeMessage ? mainLayout.fontPixelSizeMessage : 12);
          font.family:      mainLayout.fontFamilySemiBold;
          elide:            Text.ElideRight;
          wrapMode:         Text.Wrap;
          height:           50;
          width:            parent.width - 20;
       }
   Rectangle{ border.width: 1; border.color: "yellow"; anchors.fill: _homeCallToAction; color: "transparent"; visible: mainLayout.g_enableDebug   }
   Rectangle{ border.width: 2; border.color: "red"; anchors.fill: _homeClockLarge; color: "transparent"; visible: mainLayout.g_enableDebug  }

}   // homePage

