import cti_module 1.0


TerminalPage {
    id:        _bookingPage;

   property alias  bookingButtonList:    _bookingButtonList;
   property alias  bookingTxtMessage:    _bookingTxtMessage.text;
   property alias  bookingCallToAction:  _bookingCallToAction.text;


   property alias    bookingModelSource:   _jsonDataModelBooking.source
   property alias    bookingModelData:     _jsonDataModelBooking.json
   property alias    bookingModelQuery:    _jsonDataModelBooking.query // aktuell unbenutzt, Filtern geht in C# besser

   property int iViewPage:          0
   property int iPagesMax:          0
   property int iMovingDirection:   0

   function resetListView()
   {
      // Reset Auswahl: kein Element gewaehlt, Ansicht auf Anfang
      _bookingButtonList.currentIndex = 1
      iViewPage=0;
      iMovingDirection=0;
      iPagesMax=(_bookingButtonList.count/4)-1
      _bookingButtonList.positionViewAtIndex(0, GridView.Beginning)
   }

   onVisibleChanged:
   {
      resetListView()
   }
/*      if (visible)
      {
         // Reset Auswahl: kein Element gewaehlt, Ansicht auf Anfang
         _bookingButtonList.currentIndex = 1
         iViewPage=0;
         iPagesMax=(_bookingButtonList.count/4)-1
         _bookingButtonList.positionViewAtIndex(0, GridView.Beginning)
      }
   }
*/
   function receiveButtonfromlib(buttonpressed, type)
   {
      var i_index =-1
      if(buttonpressed==1075)    // Oben/Links
         i_index=_bookingButtonList.indexAt(80, 10+_bookingButtonList.cellHeight*iViewPage*2)

      if(buttonpressed==1071)    // Oben/Rechts
         i_index=_bookingButtonList.indexAt(400, 10+_bookingButtonList.cellHeight*iViewPage*2)

      if(buttonpressed==1066)    // Unten/Links
         i_index=_bookingButtonList.indexAt(80, 10+_bookingButtonList.cellHeight*(iViewPage*2+1) )

      if(buttonpressed==1069)    // Unten/Rechts
         i_index=_bookingButtonList.indexAt(400, 10+_bookingButtonList.cellHeight*(iViewPage*2+1) )

      if(i_index>=0)
      {
         _bookingButtonList.currentIndex=i_index
         qmlkeypressSignaltolib(_bookingButtonList.currentItem.myButtonId, buttonpressed, type);

      }
      else // sonstige Taste zurueckgeben
      {
         keyTapSignal("hardware", buttonpressed, type)
      }

      return _bookingButtonList.currentIndex
   }
   function keyTapSignal(text, iKey,iType)
   {
      if(iType<2)
      {
         if(iMovingDirection)
            return;  // Bewegung noch aktiv, warten!

         if(iKey == 1072)  // move up / Key down
         {
            if(iViewPage>0)
            {
               iMovingDirection=1;
//               iViewPage--;
               _bookingButtonList.flick(0,750)

            }
         }

         if(iKey == 1082)  // move down
         {
            if(iViewPage < iPagesMax )
            {
               iMovingDirection=2;
//               iViewPage++;
                _bookingButtonList.flick(0,-750)
            }
         }
      }

      qmlkeypressSignaltolib(text,  iKey,iType )
   }

   MessageArea {
      id:    _bookingTxtMessage;
      y:     mainLayout.layoutCellHeight + mainLayout.layoutCellSpace;
      z:     2
      anchors.horizontalCenter: parent.horizontalCenter;
      visible: parent.visible
    }
   CallToActionArea {
      id: _bookingCallToAction;
    }
   JSONListModel {
      id:              _jsonDataModelBooking

      onDataChanged:
      {
         resetListView()
      }
   }

   GridView {
      id:                        _bookingButtonList
      width:                     _bookingPage.width
      height:                    cellHeight*2
      y:                         mainLayout.layoutCellHeight+6
      anchors.right:             _bookingPage.right
      clip:                      true;
      snapMode:                  GridView.SnapToRow;
      currentIndex:              -1 // nichts ausgewält beim start
      boundsMovement:            Flickable.StopAtBounds;
      cellWidth:                 (_bookingButtonList.width/mainLayout.bookingNumColumn)
      cellHeight:                mainLayout.layoutButtonHeight*2//mainLayout.layoutButtonHeight+mainLayout.layoutCellHeight+mainLayout.layoutCellSpace;
      model:                     _jsonDataModelBooking.model
      delegate:                  BookingButton
      {

         text:                   model.ButtonText
         myButtonId:             model.ButtonID
         source:                 model.IconPath ? model.IconPath : ""
         isEnabled:              model.enable
         colorPreselect:          model.ColorPreselect ? model.ColorPreselect : ""
         hpos:                   index%2
         height:                 _bookingButtonList.cellHeight


      }  // ListEntry
      onMovementStarted:
      {  //console.log("--- start move --- ", _bookingButtonList.currentIndex)
         // TimeKeeper Key
         qmlkeypressSignaltolib("FKT_Key_Move_Start", 1084,1)
      }
      onMovementEnded:
      {  //console.log("--- end move --- ", _bookingButtonList.currentIndex)
         if(iMovingDirection==1) //Down, list up
         {  //console.log("move end pages --");
            iViewPage--;
         }
         if(iMovingDirection==2) //Up, list Down
         {  //console.log("move end pages ++ ");
            iViewPage++
         };
         iMovingDirection=0
         qmlkeypressSignaltolib("FKT_Key_Move_End", 1084,1)
      }

   } // GridView
//   Rectangle{ color: "transparent" ;      border.width: 2;      border.color: "green"; anchors.fill:_bookingButtonList }

}   // bookingPage
