import QtQuick 2.9

Rectangle {
    id: itemClock;
    anchors.top: parent.top
    anchors.topMargin: mainLayout.layoutTopMargin
    anchors.rightMargin: mainLayout.statusMargin
    anchors.right: parent.right

    property string _textColor:           mainLayout.colorTextDateTime
    property int  currentPixelSize:       (mainLayout.fontPixelSizeSmallDate_Time  ? mainLayout.fontPixelSizeSmallDate_Time : mainLayout.fontPixelSizeDefault);

    property alias  clockHours_text:      txtClockHours.text;
    property alias  clockMinutes_text:    txtClockMinutes.text;
    property alias  clockPoint_text:      txtClockPoint.text;

    ClockFunctions {
        id: clockFunc

        property string shortDateFormatDefault: String("dd.MM.yyyy");

        property string currentDateFormat:   mainLayout.shortDateFormat ? mainLayout.shortDateFormat : shortDateFormatDefault;
        property var	currentLocale:          mainLayout.myLocale        ? mainLayout.myLocale        : mainLayout.localeDefault;

            Timer {
                interval: 500; running: true; repeat: true; triggeredOnStart: true;
                onTriggered: clockFunc.showTimeonly(itemClock, clockFunc.currentDateFormat, clockFunc.currentLocale);
            }
        }

//        z:			10;
        color:    "transparent";
        height:   mainLayout.layoutCellHeightStatus;
        width:    3*mainLayout.layoutCellWidth + 3*mainLayout.layoutCellSpace;

        Text {
            id:                  txtClockHours
            color:               _textColor
            text:                "00"
            anchors.bottom:      itemClock.bottom;
            anchors.right:       txtClockPoint.left
            verticalAlignment:   Text.AlignBottom
            font.family:         mainLayout.fontFamilyRegular;
            horizontalAlignment: Text.AlignHCenter
            height:              parent.height;
            font.pixelSize:      itemClock.currentPixelSize;
        }

        Text {
            id:                  txtClockPoint
            color:               _textColor
            text:                ":"
            anchors.right:       txtClockMinutes.left;
            anchors.bottom:      parent.bottom;
            verticalAlignment:   Text.AlignBottom
            font.family:         mainLayout.fontFamilyRegular;
            horizontalAlignment: Text.AlignHCenter
            width:               8;
            height:              parent.height;
            font.pixelSize:      itemClock.currentPixelSize;
        }

        Text {
            id:                  txtClockMinutes
            color:               _textColor
            text:                "00"
            anchors.right:       parent.right
            anchors.bottom:      parent.bottom;
            verticalAlignment:   Text.AlignBottom
            font.family:         mainLayout.fontFamilyRegular;
            horizontalAlignment: Text.AlignHCenter
            height:              parent.height;
            font.pixelSize:      itemClock.currentPixelSize;
            anchors.rightMargin: 5;
        }

}
