import QtQuick 2.12
import QtQuick.Controls 2.12

import cti_module 1.0

Rectangle {
   id: _InputPanelDigits
   property bool isNumberInput:        false
   property bool showKeyPanel:         false
   property bool passwordMode:         true
   property bool enableAnimation:      true
   property alias mCTRL_home_IconSource:  inputPanelDigits.mCTRL_home_IconSource
   property alias mCTRL_home_enabled:     inputPanelDigits.mCTRL_home_enabled
   property int ySpaceOffset:             20-10*mainLayout.scaleEnabled
   property int maxInputLen:              mainLayout.iMaxInputPin + 500*_InputPanelDigits.isNumberInput

   property string seperator: ","
   width: mainLayout.width/2
   height:    inputPanelDigits.height+ _inputField.height +ySpaceOffset
// Debug border.color: "blue" ; border.width: 2; color: "transparent";

   signal showTextPlain(int iValue)

   onShowTextPlain:
   {
//      console.log("status chanched, text visible: ", iValue)
      if( iValue )
         _inputField.echoMode = TextInput.Normal
      else
         _inputField.echoMode= TextInput.Password
   }

   onVisibleChanged:
   {
      if (visible)
      {
         _InputPanelDigits.showKeyPanel=true
//         _inputField.echoMode= TextInput.Password // immer passwort(*)
         _inputField.text="" // Eingabefeld leeren
         if(_InputPanelDigits.passwordMode)
             _inputField.echoMode= TextInput.Password
         else
            _inputField.echoMode = TextInput.Normal
      }
      else
         _InputPanelDigits.showKeyPanel=false
   }

   TextField  {
      id:                     _inputField
      font.pixelSize:         mainLayout.fontPixelSizeInput - 6 //*mainLayout.scaleEnabled
      color:                  mainLayout.colorText;
      anchors.top:            _InputPanelDigits.top
      anchors.right:          _InputPanelDigits.right
      anchors.rightMargin:    mainLayout.desingnTouch*mainLayout.layoutTopMargin+(!mainLayout.desingnTouch*(_InputPanelDigits.width/2-_inputField.width/2)) - 16*mainLayout.scaleEnabled

      width:  inputPanelDigits.width-inputPanelDigits.keySpacing*2

      horizontalAlignment:    TextInput.AlignHCenter;
      inputMethodHints:       Qt.ImhDigitsOnly
      validator:              RegExpValidator { regExp: RegExp(mainLayout.inputNumberreg_exp) }
      readOnly:               mainLayout.desingnTouch  //true// wenn nicht Touch muss readonly false sein, sonst ist eingabe per Tastatur nicht moeglich
      maximumLength :         _InputPanelDigits.maxInputLen //mainLayout.iMaxInputPin
      focus:                  _InputPanelDigits.visible
      cursorVisible:          false//      activeFocus
      background: Rectangle {
                     implicitWidth: 10
                     implicitHeight: 10
                      color:           "#323232"
                      anchors.fill:    _inputField
         }
      onReadOnlyChanged:
      {
//         console.log("----------->>Edit Readonly: ", readOnly);
         if(readOnly)
         {
            _InputPanelDigits.showKeyPanel=false
         }
      }
      onAccepted:
      { // console.log("----------->>Edit finished :", focusReason, "Text: ", _inputField.text, "inputMethodHints: ", _inputField.inputMethodHints );
         if(_InputPanelDigits.isNumberInput)
         {
            qmlkeypressSignaltolib(_inputField.text, 25, 4); //HACK: die Funktion ruft Tasteneingabe auf, mit der 4 wird das Ereignis 25 draus-> Texteingabe
         }
         else
         {
            qmlkeypressSignaltolib(_inputField.text, 26, 5); //HACK: die Funktion ruft Tasteneingabe auf, mit der 4 wird das Ereignis 26 draus-> PINeingabe (die 26 steht nur zur Info
         }
      }

   }

   Rectangle{      color: "transparent";  border.width: 2;  border.color: "gray";  anchors.fill:  _inputField }
   KeyPad{
      id: inputPanelKeyPad
      y: _InputPanelDigits.height
      anchors.top: _inputField.bottom
      anchors.topMargin: ySpaceOffset
      anchors.horizontalCenter:  _inputField.horizontalCenter;
      active: mainLayout.gKeyboard_enabled && mainLayout.desingnTouch && _InputPanelDigits.isNumberInput
      seperator: _InputPanelDigits.seperator

      states: State {
            name: "visible"
            when: _InputPanelDigits.showKeyPanel
            PropertyChanges {  target: inputPanelKeyPad;  y: _inputField.y+_inputField.height+ySpaceOffset}

        }

        transitions: Transition {
           enabled: _InputPanelDigits.enableAnimation
            from: ""
            to: "visible"
            reversible: true
            ParallelAnimation {
                NumberAnimation {
                    properties: "y"
                    duration: 300
                    easing.type: Easing.InOutQuad
                }
            }
        }
   }
   KeyPad_PIN {
      id: inputPanelDigits
//      visible: !_InputPanelDigits.isNumberInput
//      y: _InputPanelDigits.height*_InputPanelDigits.enableAnimation + (_inputField.y+_inputField.height+ySpaceOffset)*_InputPanelDigits.enableAnimation// Position oben: _inputField.y+_inputField.height+20
      anchors.top: _inputField.bottom
      anchors.topMargin: ySpaceOffset
      anchors.horizontalCenter:  _inputField.horizontalCenter;
      active: mainLayout.gKeyboard_enabled && mainLayout.desingnTouch && !_InputPanelDigits.isNumberInput

      states: State {
            name: "visible"
            when: _InputPanelDigits.showKeyPanel
            PropertyChanges {  target: inputPanelDigits;  y: _inputField.y+_inputField.height+ySpaceOffset}

        }

        transitions: Transition {
           enabled: _InputPanelDigits.enableAnimation
            from: ""
            to: "visible"
            reversible: true
            ParallelAnimation {
                NumberAnimation {
                    properties: "y"
                    duration: 300
                    easing.type: Easing.InOutQuad
                }
            }
        }
 // // Debug
 //         onClicked: //(string text, int iKey)
 //         {
 //            console.log("Eingabe :", text, " : ", iKey)
 //         }
 // //   onShowText:
 // //   {
 // //      console.log("Eingabe visible:", iStatus)
 // //   }
    }
   function checkInputLen()
   {  // nur bei PIN Eingabe pruefen
      if(_InputPanelDigits.isNumberInput)
      {
         if(!_inputField.text.length)
         {
            return 0
         }
         return 1
      }
      if(_inputField.text.length < mainLayout.iMinInputPin)
      {
//       console.log("Debug - Edit zu wenig " ,  mainLayout.iMinInputPin);
         return 0
      }
      return 1
   }

//Debug Rectangle{      color: "transparent";  border.width: 2;  border.color: "yellow";  anchors.fill:  inputPanelDigits }
   signal clicked(string text, int iKey)
    onClicked:
    {
       if( _InputPanelDigits.showKeyPanel)
       {
         if(iKey == Qt.Key_Backspace)
         {    var position = _inputField.cursorPosition
               _inputField.text = _inputField.text.substring(0, _inputField.cursorPosition - 1) +
                              _inputField.text.substring(_inputField.cursorPosition, _inputField.text.length)
               _inputField.cursorPosition = position - 1
         }
         else if( (iKey ==  Qt.Key_Enter) || (iKey == Qt.Key_Return) )
         {
            if( checkInputLen() )
               _inputField.accepted()
//            if(_inputField.text.length) // blocken, wenn nichts eingegeben
//            _inputField.accepted()
         }
         else  if(iKey == Qt.Key_Clear) _inputField.text = ''
         else { // insert text
               var position = _inputField.cursorPosition
               _inputField.text = _inputField.text.substring(0, _inputField.cursorPosition) + text +
                              _inputField.text.substring(_inputField.cursorPosition, _inputField.text.length)
               _inputField.cursorPosition = position + 1
         }
       }
// Test         qmlkeypressSignaltolib("FKT_Key_MakeLight", 1084,1)
    }
/*
    Rectangle {
       id: my_dummy
       height:  inputPanelDigits.height + _inputField.height +ySpaceOffset
       width: 150
      border.color: "red" ; border.width: 1; color: "transparent"
      visible: mainLayout.g_enableDebug
    }
*/
      // border.color: "green" ; border.width: 1; color: "transparent"
} //_InputPanelDigits
