import QtQuick 2.12

Rectangle {
   id: _keypadrectangle
   signal clicked(string text, int iKey)
   signal  setInputTextVisible(int iValue)
   property string baseColor: "#383533"
   property alias active: _keypadrectangle.visible
   property double keySpacing:  10
//   property string seperator: ","
   property string mCTRL_home_IconSource: ""
   property bool mCTRL_home_enabled: false

   width: _keygrid.width + _controlKeys.width
   height: _keygrid.height
   color:   "transparent" //baseColor
   visible: false

   onSetInputTextVisible: {parent.showTextPlain(iValue);  }
   onClicked: { parent.clicked(text, iKey);  }

    MessageFrame {
        id: _PadFrame
        visible: false
        borderWidth: 1
        baseColor: "#A0A0A0" //"lightgray"

    }
   Grid {
      id: _keygrid
      signal clicked(string text, int iKey)
      columns: 3
      columnSpacing: _keypadrectangle.keySpacing
      rowSpacing: _keypadrectangle.keySpacing
      padding: _keypadrectangle.keySpacing


      KeyPadButton { text: "1"; iHWKey: Qt.Key_1 }
      KeyPadButton { text: "2"; iHWKey: Qt.Key_2 }
      KeyPadButton { text: "3"; iHWKey: Qt.Key_3 }
      KeyPadButton { text: "4"; iHWKey: Qt.Key_4 }
      KeyPadButton { text: "5"; iHWKey: Qt.Key_5 }
      KeyPadButton { text: "6"; iHWKey: Qt.Key_6 }
      KeyPadButton { text: "7"; iHWKey: Qt.Key_7 }
      KeyPadButton { text: "8"; iHWKey: Qt.Key_8 }
      KeyPadButton { text: "9"; iHWKey: Qt.Key_9 }
      KeyPadButton { text: ""; source: mCTRL_home_IconSource; iHWKey: Qt.Key_Home; bAnimation: _keypadrectangle.mCTRL_home_enabled;
         onClicked: {
            if(_keypadrectangle.mCTRL_home_enabled)
            {
               qmlkeypressSignaltolib( "FKT_Key_Transponder", 1084, 0 );
            }

         }
      }
      KeyPadButton { text: "0"; iHWKey: Qt.Key_0 }
      KeyPadButton { text: ""; source: globalPathToImages+"control_vieweye.svg"; iHWKey: Qt.Key_View;
//      KeyPadButton { text: ""; source: "/home/cti/control_vieweye.svg"; iHWKey: Qt.Key_View;
            onStatusChanged:
            { // nur hier
//               console.log("status chanched?", iStatus)
               setInputTextVisible(iStatus)
            }
         }
      onClicked: { parent.clicked(text, iKey); }
   }
   Column{
      id: _controlKeys
      signal clicked(string text, int iKey)
      anchors.left: _keygrid.right
      anchors.leftMargin:  -_keypadrectangle.keySpacing
      padding: _keypadrectangle.keySpacing
      spacing: _keypadrectangle.keySpacing
      rightPadding: 0
      KeyPadButton_Control { text: ""; source: globalPathToImages+"control_backspace.svg"; iHWKey: Qt.Key_Backspace}
      KeyPadButton_Control { text: ""; source: globalPathToImages+"control_trash.svg"; iHWKey: Qt.Key_Clear}
      KeyPadButton_Control { text: ""; source: globalPathToImages+"control_enter.svg"; height: 16+32*mainLayout.scaleEnabled+128+_keypadrectangle.keySpacing;  iHWKey: Qt.Key_Enter; myButtonId:"Pin rein"}
/*
      KeyPadButton { text: ""; bAnimation: false; source: globalPathToImages+"backspace-868482.svg"; width: 76; iImageHeight: 16; iImageWidth: 32; iHWKey: Qt.Key_Backspace}
      KeyPadButton { text: ""; bAnimation: false; source: globalPathToImages+"icons8-trash.svg"; width: 80;iImageHeight: 32; iImageWidth: 32; iHWKey: Qt.Key_Clear}
      KeyPadButton { text: ""; bAnimation: false;source: globalPathToImages+"enter-868482.svg"; width: 80; height: 128+8; iImageHeight: 16; iImageWidth: 32; iHWKey: Qt.Key_Enter}
      */
      onClicked: { parent.clicked(text, iKey); }
   }

}
