import QtQuick 2.12
import QtQuick.Controls 2.12

Rectangle {
   id:   _BackGroundPad

   signal clicked(string text, int iKey)
   signal statusChanged(int iStatus)
   property bool bAnimation: true
   property bool isCtrlKey: false
   property string parentColor:  "#323232"
   property string defaultColor: "#323232"
   property string pressedColor:  Qt.lighter(defaultColor, 2.0)
   property alias source:        _icon.source
   property int     iHWKey:           1084
   property string  myButtonId:       "empty";
   property alias   label_id:         _label;
   property alias   text:             _label.text;
   property int     iImageWidth:       56+8*mainLayout.scaleEnabled //mainLayout.touchButtonImageSizeDefault   ? mainLayout.touchButtonImageSizeDefault	: mainLayout.bookingButtonImageWidth;
   property int     iImageHeight:      56+8*mainLayout.scaleEnabled //mainLayout.touchButtonImageSizeDefault  ? mainLayout.touchButtonImageSizeDefault  : mainLayout.bookingButtonImageHeight;
   property double scaleFactor:        1.25
   // 48
// Touch    56 -> 48 -8
//bookingButtonImageWidth   iImageHeight: 48; iImageWidth: 48;

   color: defaultColor
   radius: 5 //width/2
   width:  mainLayout.touchButtonImageSizeDefault + 16*mainLayout.scaleEnabled
   height: mainLayout.touchButtonImageSizeDefault + 16*mainLayout.scaleEnabled

   onClicked:
   {
      if(isCtrlKey)
         receiveButtonfromlib(iHWKey, 1 )
      else
         parent.clicked(text,iKey)

   }
   Text
   {
      id: _labelBackGround;
      anchors.centerIn:    _BackGroundPad
      font.pixelSize:      mainLayout.fontPixelSizeInput
      color:                mainLayout.colorKeyPadText
      text: _BackGroundPad.text

   }

   Rectangle {
      id:      _touchButtonPad
      radius: _BackGroundPad.radius
      width:  _BackGroundPad.width
      height: _BackGroundPad.height
      color: _BackGroundPad.defaultColor
      property alias defaultColor: _BackGroundPad.defaultColor
      property alias pressedColor:  _BackGroundPad.pressedColor
      property int iSaveY: 0

   Text
   {
      id: _label;
      anchors.centerIn:       _touchButtonPad
      font.pixelSize:         mainLayout.fontPixelSizeInput
      color:                  mainLayout.colorKeyPadText

   }
   Image
   {
      id: _icon;
      anchors.centerIn:             _touchButtonPad
      sourceSize.width:           _BackGroundPad.iImageWidth
      sourceSize.height:          _BackGroundPad.iImageHeight

   }

   state: "INACTIVE"

   states: [
       State {
           name: "ACTIVE"
               PropertyChanges { target: _touchButtonPad ; color: _touchButtonPad.pressedColor }

       },
       State {
           name: "INACTIVE"
               PropertyChanges { target: _touchButtonPad ; color: _touchButtonPad.defaultColor }
       }

   ]

   transitions: [
       Transition {
            to: "ACTIVE"
            ParallelAnimation
            {
               PropertyAnimation { property: "y";  target: _touchButtonPad; from: _touchButtonPad.y ; to: _touchButtonPad.y-(48+16*mainLayout.scaleEnabled); duration: 30
                     easing.type: Easing.InOutQuad
                  }
               ScaleAnimator { target: _touchButtonPad; from: 1; to: scaleFactor; duration: 10 }
            }
       },
       Transition {
           to: "INACTIVE"
            ParallelAnimation
            {
               PropertyAnimation { property: "y"; target: _touchButtonPad; from: _touchButtonPad.y ; to: _touchButtonPad.iSaveY; duration: 50
                    easing.type: Easing.InOutQuad
                }
               ScaleAnimator { target: _touchButtonPad; from: scaleFactor; to: 1; duration: 10 }
            }
       }
   ]

//    debug    	 border.color: "yellow";      border.width: 1

   // Position merken, damit Animation wieder an diese Position zurueckkehrt
   Component.onCompleted : { _touchButtonPad.iSaveY=_touchButtonPad.y }

   } // _touchButtonPad
   MouseArea {
      anchors.fill: _BackGroundPad  //parent -> ist falsch?//
      onReleased:
      {
         if(_touchButtonPad.state == "ACTIVE")
            _BackGroundPad.clicked(_label.text, _BackGroundPad.iHWKey)
         if(bAnimation)
            _touchButtonPad.state = "INACTIVE"
      _BackGroundPad.statusChanged(0)
      }

      onPressed:
      {
         if(bAnimation)
            _touchButtonPad.state = "ACTIVE"
     _BackGroundPad.statusChanged(1)
      }

      onCanceled:
      {
         _touchButtonPad.state = "INACTIVE"
     _BackGroundPad.statusChanged(2)

      }
      onPositionChanged:
      {  //NOTE: pruefen ob Bewegung den Touchbereich verlassen hat, falls ja ist status gedrueckt ungueltig
         if( ( (mouseX>_touchButtonPad.width) || (mouseX<0) || (mouseY>_touchButtonPad.height+15) || (mouseY<(0-15*mainLayout.scaleEnabled))  ) )
         {
            onCanceled()
         }
      }
   } // MouseArea
}// _BackGroundPad
