﻿import QtQuick 2.9
import QtQuick.Controls 2.2

BusyIndicator {
   id:         control;
   running:    false;
   z:          99;

   contentItem: Item {
      implicitWidth:    64
      implicitHeight:   64

      Item {
         id:      item
         x:       mainLayout.width / 2 - 32
         y:       mainLayout.height / 2 - 32

         width:   64
         height:  64
         opacity: control.running ? 1 : 0

         Behavior on opacity {
            OpacityAnimator {
               duration: 250
            }
         }

         RotationAnimator {
            target: item
            running: control.visible && control.running
            from: 0
            to: 360
            loops: Animation.Infinite
            duration: 1250
         }

         Repeater {
            id: repeater
            model: 6

            Rectangle {
               x: item.width / 2 - width / 2
               y: item.height / 2 - height / 2
               implicitWidth: 10
               implicitHeight: 10
               radius: 5
               color: mainLayout.colorActive
               transform: [
                  Translate {
                     y: -Math.min(item.width, item.height) * 0.5 + 5
                  },
                  Rotation {
                     angle: index / repeater.count * 360
                     origin.x: 5
                     origin.y: 5
                  }
               ]
            }
         } // Repeater
      }  // Item
   }	// Item
}
